/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.opplugin;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.fcc.opplugin.validator.CheckoutFlowDetailSaveValidator;

public class CheckoutFlowSaveOpPlugin
extends AbstractOperationServicePlugIn {
    private static final String FCC_CHECKOUT_PRETASKS = "fcc_checkout_pretasks";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(this.billEntityType.getAllFields().keySet());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new CheckoutFlowDetailSaveValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.endOperationTransaction(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            DynamicObjectCollection taskentry;
            DynamicObject[] allPreTasks = BusinessDataServiceHelper.load((String)FCC_CHECKOUT_PRETASKS, (String)"flowid,taskrowid", (QFilter[])new QFilter[]{new QFilter("flowid", "=", dataEntity.getPkValue())});
            if (allPreTasks.length <= 0 || (taskentry = dataEntity.getDynamicObjectCollection("taskentry")).size() <= 0) continue;
            List taskIds = Arrays.stream(allPreTasks).map(preTask -> preTask.getLong("taskrowid")).collect(Collectors.toList());
            for (DynamicObject task : taskentry) {
                long id = task.getLong("id");
                taskIds.remove(id);
            }
            DeleteServiceHelper.delete((String)FCC_CHECKOUT_PRETASKS, (QFilter[])new QFilter[]{new QFilter("taskrowid", "in", taskIds)});
        }
    }
}

