/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.opplugin;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.fcc.opplugin.validator.CheckoutPlanDeleteValidator;

public class CheckoutPlanDeleteOpPlugin
extends AbstractOperationServicePlugIn {
    private static final String FCC_CHECKOUT_FLOW_DETAIL = "fcc_checkout_flow_detail";
    private static final String FCC_CHECKOUT_PLAN = "fcc_checkout_plan";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(this.billEntityType.getAllFields().keySet());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        this.getOption().setVariableValue("ignorerefentityids", FCC_CHECKOUT_PLAN);
        e.addValidator((AbstractValidator)new CheckoutPlanDeleteValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.endOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if (!"delete".equals(operationKey)) {
            return;
        }
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            QFilter deleteFilter = new QFilter("plan", "=", dataEntity.getPkValue());
            DeleteServiceHelper.delete((String)FCC_CHECKOUT_FLOW_DETAIL, (QFilter[])new QFilter[]{deleteFilter});
        }
    }
}

