/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.ext.fi.util.DateUtils;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.bd.util.ContextUtil;
import kd.fi.fcc.common.enums.CheckoutCycleEnum;
import kd.fi.fcc.common.enums.CheckoutFlowStatusEnum;
import kd.fi.fcc.common.enums.OrgPermissionEnum;
import kd.fi.fcc.common.enums.TaskStatusEnum;
import kd.fi.fcc.common.utils.CheckOutViewUtil;
import kd.fi.fcc.common.utils.FccUtil;
import kd.fi.fcc.opplugin.validator.CheckoutPlanReleaseValidator;

public class CheckoutPlanReleasePlugin
extends AbstractOperationServicePlugIn {
    private static final String FCC_CHECKOUT_PLAN = "fcc_checkout_plan";
    private static final String FCC_CHECKOUT_FLOW_DETAIL = "fcc_checkout_flow_detail";
    private static final String FCC_CHECKOUT_TASK = "fcc_checkout_task";
    private static final Long ACC_VIEW = 10L;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(this.billEntityType.getAllFields().keySet());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new CheckoutPlanReleaseValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        if (!"release".equals(operationKey)) {
            return;
        }
        for (DynamicObject dataEntity : dataEntities) {
            OperationResult operationResult = CheckOutViewUtil.copyOrgStrcutureToFcc((DynamicObject)dataEntity);
            if (!operationResult.isSuccess()) {
                ValidationErrorInfo info = new ValidationErrorInfo("", dataEntity.getPkValue(), 0, 0, "errorcode_002", "", operationResult.getMessage(), ErrorLevel.Error);
                this.operationResult.addErrorInfo((OperateErrorInfo)info);
                e.setCancelOperation(true);
                return;
            }
            dataEntity.set("planstatus", (Object)"B");
            dataEntity.set("publisher", (Object)this.getCurrentUser());
            dataEntity.set("releasetime", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        super.beginOperationTransaction(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        StringBuilder changeViewMessage = new StringBuilder();
        for (DynamicObject plan : dataEntities) {
            long view = CheckOutViewUtil.getView((Long)plan.getLong("id"));
            Map<Object, DynamicObject> orgStructures = this.getEnableLeafOrgByView(view);
            List<Long> viewOrgIds = orgStructures.values().stream().map(dynamicObject -> dynamicObject.getLong("org.id")).collect(Collectors.toList());
            QFilter qFilter = new QFilter("plan", "=", plan.getPkValue());
            if (CheckoutCycleEnum.MONTH_END.getValue().equals(plan.getString("method"))) {
                Date month = plan.getDate("month");
                QFilter monthFilter = new QFilter("flowdate", "=", (Object)month);
                List<Long> decreaseOrgIds = this.getDecreaseOrgIds(monthFilter.and(qFilter), viewOrgIds);
                if (decreaseOrgIds != null && decreaseOrgIds.size() > 0) {
                    QFilter deleteFilter = new QFilter("id", "in", decreaseOrgIds);
                    DeleteServiceHelper.delete((String)FCC_CHECKOUT_FLOW_DETAIL, (QFilter[])new QFilter[]{deleteFilter});
                }
                this.setStartAndEndTime(plan, plan.getDate("month"), "starttime", "endtime");
                continue;
            }
            if (CheckoutCycleEnum.DAY_END.getValue().equals(plan.getString("method"))) {
                QFilter futureFilter = new QFilter("flowdate", ">=", (Object)DateUtils.getCurrentDate());
                boolean exists = QueryServiceHelper.exists((String)FCC_CHECKOUT_FLOW_DETAIL, (QFilter[])new QFilter[]{qFilter, futureFilter});
                Date latestFlowDate = FccUtil.getLatestFlowDate((Long)plan.getLong("id"));
                if (latestFlowDate != null) {
                    qFilter.and("flowdate", "=", (Object)latestFlowDate);
                }
                if (exists) {
                    List<Long> list = this.getDecreaseOrgIds(qFilter, viewOrgIds);
                    if (list != null && list.size() > 0) {
                        QFilter deleteFilter = new QFilter("id", "in", list);
                        DeleteServiceHelper.delete((String)FCC_CHECKOUT_FLOW_DETAIL, (QFilter[])new QFilter[]{deleteFilter});
                    }
                } else {
                    DynamicObject[] flows = BusinessDataServiceHelper.load((String)FCC_CHECKOUT_FLOW_DETAIL, (String)"id,plan,org,flowstatus,canconfirmtime,canconfirmuser,confirmuser,confirmtime,creator,createtime,tasknum,flowdate,billstatus,taskentry.tasknumber,taskentry.pid,taskentry.eorg,taskentry.ebizorg,taskentry.type,taskentry.executor,taskentry.seq,taskentry.starttime,taskentry.endtime,taskentry.startdaytime,taskentry.enddaytime,taskentry.pretasks,taskentry.bizbooktype", (QFilter[])new QFilter[]{qFilter});
                    if (flows.length > 0) {
                        changeViewMessage = this.copyLatestFlow(flows, plan, viewOrgIds, orgStructures);
                    }
                }
                this.setStartAndEndTime(plan, latestFlowDate, "startdaytime", "enddaytime");
            }
            String changeViewMess = ResManager.loadKDString((String)"\u7ed3\u8d26\u89c6\u56fe\u53d8\u52a8\uff1a", (String)"CheckoutPlanReleasePlugin_3", (String)"fi-fcc-opplugin", (Object[])new Object[0]);
            String copyMess = ResManager.loadKDString((String)"\u590d\u5236\u63d0\u793a2", (String)"CheckoutPlanReleasePlugin_4", (String)"fi-fcc-opplugin", (Object[])new Object[0]);
            if (changeViewMessage.length() <= changeViewMess.length()) continue;
            ValidationErrorInfo info = new ValidationErrorInfo("", plan.getPkValue(), 0, 0, "errorcode_002", copyMess, changeViewMessage.toString(), ErrorLevel.Error);
            this.operationResult.addErrorInfo((OperateErrorInfo)info);
        }
    }

    private List<Long> getDecreaseOrgIds(QFilter qFilter, List<Long> viewOrgIds) {
        DynamicObject[] flows = BusinessDataServiceHelper.load((String)FCC_CHECKOUT_FLOW_DETAIL, (String)"id,plan,org", (QFilter[])new QFilter[]{qFilter});
        List<Long> list = Arrays.stream(flows).filter(flow -> !viewOrgIds.contains(flow.getLong("org_id"))).map(flow -> flow.getLong("id")).collect(Collectors.toList());
        return list;
    }

    private void setStartAndEndTime(DynamicObject plan, Date flowdate, String startField, String endField) {
        QFilter qFilter = new QFilter("plan", "=", plan.getPkValue());
        qFilter.and("flowdate", "=", (Object)flowdate);
        DynamicObject[] flows = BusinessDataServiceHelper.load((String)FCC_CHECKOUT_FLOW_DETAIL, (String)"id,plan,org,flowstatus,flowdate,taskentry.tasknumber,taskentry.pid,taskentry.starttime,taskentry.endtime,taskentry.startdaytime,taskentry.enddaytime", (QFilter[])new QFilter[]{qFilter});
        if (flows.length > 0) {
            for (DynamicObject flow : flows) {
                long id;
                HashMap<Long, Date> endDateMap;
                HashMap<Long, Date> startDateMap;
                DynamicObjectCollection taskentry = flow.getDynamicObjectCollection("taskentry");
                if (taskentry.size() <= 0) continue;
                if (CheckoutCycleEnum.MONTH_END.getValue().equals(plan.getString("method"))) {
                    startDateMap = new HashMap<Long, Date>(taskentry.size());
                    endDateMap = new HashMap<Long, Date>(taskentry.size());
                    this.getStartAndEndDate(taskentry, startDateMap, endDateMap, startField, endField);
                    for (DynamicObject task : taskentry) {
                        id = task.getLong("id");
                        Date startDate = (Date)startDateMap.get(id);
                        Date endDate = (Date)endDateMap.get(id);
                        if (startDate != null) {
                            task.set(startField, (Object)startDate);
                        }
                        if (endDate == null) continue;
                        task.set(endField, (Object)endDate);
                    }
                    continue;
                }
                startDateMap = new HashMap(taskentry.size());
                endDateMap = new HashMap(taskentry.size());
                this.getStartAndEndDayTime(taskentry, startDateMap, endDateMap, startField, endField);
                for (DynamicObject task : taskentry) {
                    id = task.getLong("id");
                    if (!startDateMap.containsKey(id) || !endDateMap.containsKey(id)) continue;
                    int startDate = (Integer)startDateMap.get(id);
                    int endDate = (Integer)endDateMap.get(id);
                    if (startDate >= 0) {
                        task.set(startField, (Object)startDate);
                    }
                    if (endDate < 0) continue;
                    task.set(endField, (Object)endDate);
                }
            }
            SaveServiceHelper.save((DynamicObject[])flows);
        }
    }

    private void getStartAndEndDate(DynamicObjectCollection taskentry, Map<Long, Date> startDateMap, Map<Long, Date> endDateMap, String startField, String endFiled) {
        for (DynamicObject task : taskentry) {
            long id = task.getLong("id");
            long pid = task.getLong("pid");
            Date starttime = task.getDate(startField);
            Date endtime = task.getDate(endFiled);
            if (pid == 0L) {
                startDateMap.put(id, null);
                endDateMap.put(id, null);
                continue;
            }
            Date startDate = startDateMap.get(pid);
            Date endDate = endDateMap.get(pid);
            if (startDate == null || starttime.before(startDate)) {
                startDateMap.put(pid, starttime);
            }
            if (endDate != null && !endtime.after(endDate)) continue;
            endDateMap.put(pid, endtime);
        }
    }

    private void getStartAndEndDayTime(DynamicObjectCollection taskentry, Map<Long, Integer> startDateMap, Map<Long, Integer> endDateMap, String startField, String endFiled) {
        for (DynamicObject task : taskentry) {
            long id = task.getLong("id");
            long pid = task.getLong("pid");
            int starttime = task.getInt(startField);
            int endtime = task.getInt(endFiled);
            if (pid == 0L) {
                startDateMap.put(id, 86400);
                endDateMap.put(id, 0);
                continue;
            }
            Integer startDate = startDateMap.get(pid);
            Integer endDate = endDateMap.get(pid);
            if (startDate != null && starttime < startDate) {
                startDateMap.put(pid, starttime);
            }
            if (endDate == null || endtime <= endDate) continue;
            endDateMap.put(pid, endtime);
        }
    }

    private StringBuilder copyLatestFlow(DynamicObject[] flows, DynamicObject plan, List<Long> viewOrgIds, Map<Object, DynamicObject> orgStructures) {
        StringBuilder changeViewMessage = new StringBuilder(ResManager.loadKDString((String)"\u7ed3\u8d26\u89c6\u56fe\u53d8\u52a8\uff1a", (String)"CheckoutPlanReleasePlugin_3", (String)"fi-fcc-opplugin", (Object[])new Object[0]));
        Map<Long, String> orgIdToName = orgStructures.values().stream().collect(Collectors.toMap(org1 -> org1.getLong("org.id"), org2 -> org2.getString("org.name")));
        this.getNewOrg(flows, viewOrgIds, orgIdToName, changeViewMessage);
        for (DynamicObject flow : flows) {
            DynamicObject org = (DynamicObject)flow.get("org");
            if (!viewOrgIds.contains(org.getLong("id"))) {
                this.addRedOrgTipMessage(org, changeViewMessage);
                continue;
            }
            DynamicObjectType dynamicObjectType = flow.getDynamicObjectType();
            DynamicObject copyFlow = new DynamicObject(dynamicObjectType);
            copyFlow.set("plan", plan.getPkValue());
            copyFlow.set("org", (Object)org);
            copyFlow.set("flowstatus", (Object)CheckoutFlowStatusEnum.confirm.getType());
            copyFlow.set("confirmuser", flow.get("confirmuser"));
            copyFlow.set("confirmtime", flow.get("confirmtime"));
            copyFlow.set("canconfirmuser", flow.get("canconfirmuser"));
            copyFlow.set("canconfirmtime", flow.get("canconfirmtime"));
            copyFlow.set("creator", (Object)RequestContext.get().getCurrUserId());
            copyFlow.set("createtime", (Object)new Date());
            copyFlow.set("billstatus", (Object)"A");
            copyFlow.set("tasknum", (Object)flow.getInt("tasknum"));
            copyFlow.set("flowdate", (Object)DateUtils.getCurrentDate());
            DynamicObjectCollection taskEntry = flow.getDynamicObjectCollection("taskentry");
            DynamicObjectCollection copyTaskEntry = copyFlow.getDynamicObjectCollection("taskentry");
            HashMap<String, Long> idMapping = new HashMap<String, Long>(taskEntry.size());
            HashMap<String, Long> pidMapping = new HashMap<String, Long>(taskEntry.size());
            if (taskEntry.size() > 0) {
                for (DynamicObject task : taskEntry) {
                    DynamicObject tasknumber = task.getDynamicObject("tasknumber");
                    DynamicObject copyTask = copyTaskEntry.addNew();
                    copyTask.set("executor", (Object)task.getLong("executor_id"));
                    copyTask.set("tasknumber", (Object)tasknumber.getLong("id"));
                    copyTask.set("eorg", task.get("eorg"));
                    copyTask.set("ebizorg", task.get("ebizorg"));
                    copyTask.set("type", task.get("type"));
                    copyTask.set("bizbooktype", task.get("bizbooktype"));
                    copyTask.set("startdaytime", task.get("startdaytime"));
                    copyTask.set("enddaytime", task.get("enddaytime"));
                    copyTask.set("starttime", task.get("starttime"));
                    copyTask.set("endtime", task.get("endtime"));
                    copyTask.set("seq", task.get("seq"));
                    copyTask.set("taskstatus", (Object)TaskStatusEnum.NOT_START.getType());
                    DynamicObjectCollection pretasks = task.getDynamicObjectCollection("pretasks");
                    List list = pretasks.stream().map(preTask -> preTask.getLong("fbasedataid_id")).collect(Collectors.toList());
                    DynamicObjectCollection copyPreTasks = copyTask.getDynamicObjectCollection("pretasks");
                    if (list.size() > 0) {
                        for (Long aLong : list) {
                            DynamicObject dynamicObject = copyPreTasks.addNew();
                            dynamicObject.set("fbasedataid_id", (Object)aLong);
                        }
                    }
                    String key = this.getKey(task);
                    if (task.getLong("pid") == 0L) {
                        idMapping.put(key, task.getLong("id"));
                        continue;
                    }
                    pidMapping.put(key, task.getLong("pid"));
                }
            }
            DynamicObject[] newTasks = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{copyFlow});
            if (pidMapping.isEmpty()) continue;
            DynamicObject newTask = BusinessDataServiceHelper.loadSingle((Object)newTasks[0].getPkValue(), (String)FCC_CHECKOUT_FLOW_DETAIL);
            this.setTaskParentRelation(newTask, idMapping, pidMapping);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newTask});
        }
        return changeViewMessage;
    }

    private void getNewOrg(DynamicObject[] flows, List<Long> viewOrgIds, Map<Long, String> map, StringBuilder changeViewMessage) {
        List orgIds = Arrays.stream(flows).map(flow -> flow.getLong("org.id")).collect(Collectors.toList());
        ArrayList<Long> viewOrgIds2 = new ArrayList<Long>(viewOrgIds);
        viewOrgIds2.removeAll(orgIds);
        if (viewOrgIds2.size() > 0) {
            for (Long orgId : viewOrgIds2) {
                if (!map.containsKey(orgId)) continue;
                String name = map.get(orgId);
                String format = String.format(ResManager.loadKDString((String)"\u7ed3\u8d26\u7ec4\u7ec7\u89c6\u56fe\u4e0b\u65b0\u589e\u6838\u7b97\u7ec4\u7ec7%1$s,\u8bf7\u5728\u8ba1\u5212\u4e0b\u8bbe\u7f6e\u7ed3\u8d26\u4efb\u52a1\u3002", (String)"CheckoutPlanSaveOpPlugin_2", (String)"fi-fcc-opplugin", (Object[])new Object[0]), name);
                changeViewMessage.append("\n").append(format);
            }
        }
    }

    private void addRedOrgTipMessage(DynamicObject org, StringBuilder changeViewMessage) {
        String format = String.format(ResManager.loadKDString((String)"\u539f\u7ed3\u8d26\u8ba1\u5212\u4e2d\u7684\u6838\u7b97\u7ec4\u7ec7%1$s\u5df2\u5220\u9664\u3002", (String)"CheckoutPlanSaveOpPlugin_1", (String)"fi-fcc-opplugin", (Object[])new Object[0]), org.getString("name"));
        changeViewMessage.append("\n").append(format);
    }

    public String getKey(DynamicObject task) {
        long taskId = task.getLong("tasknumber_id");
        long eorgId = task.getLong("eorg_id");
        String type = task.getString("type");
        if (StringUtils.isEmpty((String)type)) {
            type = " ";
        }
        DynamicObject bizbooktype = task.getDynamicObject("bizbooktype");
        long bizbooktypeid = 0L;
        if (bizbooktype != null) {
            bizbooktypeid = bizbooktype.getLong("id");
        }
        String key = taskId + "-" + eorgId + "-" + type + "-" + bizbooktypeid;
        return key;
    }

    private void setTaskParentRelation(DynamicObject newTask, Map<String, Long> idMapping, Map<String, Long> pidMapping) {
        DynamicObjectCollection taskentry = newTask.getDynamicObjectCollection("taskentry");
        HashMap<String, String> relationMap = new HashMap<String, String>(taskentry.size());
        for (Map.Entry<String, Long> entry : idMapping.entrySet()) {
            String key = entry.getKey();
            long id = entry.getValue();
            for (Map.Entry<String, Long> pidEntry : pidMapping.entrySet()) {
                String key1 = pidEntry.getKey();
                long value = pidEntry.getValue();
                if (value != id) continue;
                relationMap.put(key1, key);
            }
        }
        HashMap<String, Long> map = new HashMap<String, Long>(taskentry.size());
        for (DynamicObject task : taskentry) {
            String key = this.getKey(task);
            long pid = task.getLong("id");
            if (pid == 0L) continue;
            map.put(key, pid);
        }
        for (DynamicObject task : taskentry) {
            String key = this.getKey(task);
            String paramStr = (String)relationMap.get(key);
            if (!StringUtils.isNotEmpty((String)paramStr)) continue;
            Long pid = (Long)map.get(paramStr);
            task.set("pid", (Object)pid);
        }
    }

    private Map<Object, DynamicObject> getEnableLeafOrgByView(long view) {
        HasPermOrgResult fcc = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)"fcc", (String)FCC_CHECKOUT_FLOW_DETAIL, (String)OrgPermissionEnum.VIEW.getValue());
        QFilter qFilter = new QFilter("view", "=", (Object)view);
        qFilter.and("isleaf", "=", (Object)"1");
        qFilter.and("org.enable", "=", (Object)"1");
        if (!fcc.hasAllOrgPerm()) {
            qFilter.and("org", "in", (Object)fcc.getHasPermOrgs());
        }
        String selectProperties = "id,org.id,org.name,org.number,parent.id,isleaf,longnumber";
        Map orgStructures = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
        return orgStructures;
    }

    private DynamicObject getCurrentUser() {
        long currUserId = UserServiceHelper.getCurrentUserId();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)currUserId, (String)"bos_user");
        return dynamicObject;
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        if ("release".equals(operationKey)) {
            for (DynamicObject dataEntity : dataEntities) {
                this.sendMessageWithBusiness(dataEntity);
            }
        }
    }

    private void sendMessageWithBusiness(DynamicObject dataEntity) {
        long currUserId = UserServiceHelper.getCurrentUserId();
        ILocaleString name = (ILocaleString)dataEntity.get("name");
        long bizId = dataEntity.getLong("id");
        String methodText = ResManager.loadKDString((String)"\u65e5\u7ed3", (String)"CheckoutPlanReleasePlugin_7", (String)"fi-fcc-opplugin", (Object[])new Object[0]);
        String checkmethod = "day_check";
        if (CheckoutCycleEnum.MONTH_END.getValue().equals(dataEntity.getString("method"))) {
            methodText = ResManager.loadKDString((String)"\u6708\u7ed3", (String)"CheckoutPlanReleasePlugin_8", (String)"fi-fcc-opplugin", (Object[])new Object[0]);
            checkmethod = "month_check";
        }
        LocaleString tagName = ResManager.getLocaleString((String)"\u7ed3\u8d26\u9a7e\u9a76\u8231", (String)"CheckoutPlanReleasePlugin_2", (String)"fi-fcc-opplugin");
        String entityNumber = FCC_CHECKOUT_PLAN;
        HashMap titleValues = new HashMap();
        ResManager.getLocaleString((String)"\u7ed3\u8d26\u8ba1\u5212\u201c%1$s\u201d\u53d1\u5e03\u3002", (String)"CheckoutPlanReleasePlugin_0", (String)"fi-fcc-opplugin").forEach((k, v) -> {
            String title = String.format(v, name.get(k));
            titleValues.put(k, title);
        });
        LocaleString title = LocaleString.fromMap(titleValues);
        String finalMethodText = methodText;
        HashMap contentValues = new HashMap();
        ResManager.getLocaleString((String)"\u7ed3\u8d26\u8ba1\u5212\u201c%1$s\u201d\u5df2\u53d1\u5e03\uff0c\u8bf7\u767b\u5f55\u3010\u7ed3\u8d26\u9a7e\u9a76\u8231>\u4e2a\u4eba\u5de5\u4f5c\u53f0\u3011\uff0c\u53ca\u65f6\u5b8c\u6210%2$s\u4efb\u52a1\u3002", (String)"CheckoutPlanReleasePlugin_1", (String)"fi-fcc-opplugin").forEach((k, v) -> {
            String content = String.format(v, name.get(k), finalMethodText);
            contentValues.put(k, content);
        });
        LocaleString content = LocaleString.fromMap(contentValues);
        long planId = dataEntity.getLong("id");
        QFilter qFilter = new QFilter("plan_id", "=", (Object)planId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)FCC_CHECKOUT_FLOW_DETAIL, (String)"id,taskentry.executor", (QFilter[])new QFilter[]{qFilter});
        if (query.size() > 0) {
            Date month = dataEntity.getDate("month");
            Date startdate = dataEntity.getDate("startdate");
            Date enddate = dataEntity.getDate("enddate");
            Date date = this.getLastestDate(startdate, enddate);
            Set<Long> receivers = query.stream().map(r -> (Long)r.get("taskentry.executor")).collect(Collectors.toSet());
            this.sendMessage((ILocaleString)title, (ILocaleString)content, currUserId, (ILocaleString)tagName, entityNumber, receivers, bizId, checkmethod, date, month);
        }
    }

    private Date getLastestDate(Date startdate, Date enddate) {
        Date now = new Date();
        if (startdate == null || enddate == null) {
            return now;
        }
        if (now.before(startdate)) {
            return startdate;
        }
        if (now.after(enddate)) {
            return enddate;
        }
        return now;
    }

    private void sendMessage(ILocaleString title, ILocaleString content, long senderId, ILocaleString tag, String entityNumber, Set<Long> receivers, Long bizId, String checkmethod, Date date, Date month) {
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        MessageInfo message = new MessageInfo();
        message.setMessageTitle(title);
        message.setMessageContent(content);
        message.setMessageTag(tag);
        message.setUserIds(receivers.stream().collect(Collectors.toList()));
        message.setSenderId(Long.valueOf(senderId));
        message.setEntityNumber(entityNumber);
        message.setType("notice");
        message.setOperation("submit");
        message.setTemplateNumber("FCC_001");
        message.setBizDataId(bizId);
        message.setNestBillno(String.valueOf(bizId));
        String clientUrl = UrlService.getDomainContextUrl();
        String contentUrl = clientUrl + "/index.html?formId=fcc_workbench_person&pkId=1972058526805354496&checkmethod=" + checkmethod;
        if (checkmethod.equals("month_check")) {
            String monthString = DateUtils.formatString((Date)month, (String)"yyyy-MM-dd HH:mm:ss");
            contentUrl = contentUrl + "&month=" + monthString;
        } else if (checkmethod.equals("day_check")) {
            String dateString = DateUtils.formatString((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
            contentUrl = contentUrl + "&date=" + dateString;
        }
        message.setContentUrl(contentUrl);
        HashMap params = new HashMap();
        message.setParams(params);
        StringBuilder notifyType = new StringBuilder();
        notifyType.append(MessageChannels.MC);
        message.setNotifyType(notifyType.toString());
        messageInfos.add(message);
        MessageCenterServiceHelper.batchSendMessages(messageInfos);
    }
}

