/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.form.MessageBoxResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fcc.common.enums.CheckoutCycleEnum;
import kd.fi.fcc.common.enums.CheckoutFlowStatusEnum;
import kd.fi.fcc.common.utils.CheckOutViewUtil;
import kd.fi.fcc.common.utils.FccUtil;
import kd.fi.fcc.opplugin.validator.CheckoutPlanSaveValidator;

public class CheckoutPlanSaveOpPlugin
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(CheckoutPlanSaveOpPlugin.class);
    private static final String FCC_CHECKOUT_FLOW_DETAIL = "fcc_checkout_flow_detail";
    private static final String FCC_CHECKOUT_TASK = "fcc_checkout_task";
    private static final String FCC_CHECKOUT_PLAN = "fcc_checkout_plan";
    private static final String FCC_CHECKOUT_MEMBER = "fcc_checkout_user";
    private static final String FCC_CHECKOUT_PRETASKS = "fcc_checkout_pretasks";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(this.billEntityType.getAllFields().keySet());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new CheckoutPlanSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            dataEntity.set("status", (Object)"C");
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] flows;
        DynamicObject[] flowDateDescs;
        super.endOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if (!"save".equals(operationKey)) {
            return;
        }
        OperateOption option = this.getOption();
        if (!option.containsVariable("afterCopyConfirm") || !option.containsVariable("sourcePk")) {
            String operationStatus;
            if (option.containsVariable("OperationStatus") && (operationStatus = option.getVariableValue("OperationStatus")).equals(OperationStatus.ADDNEW.name())) {
                this.createFlows(e);
            }
            return;
        }
        StringBuilder deleteTaskMessage = new StringBuilder(ResManager.loadKDString((String)"\u4efb\u52a1\u5220\u9664\uff1a", (String)"CheckoutPlanSaveOpPlugin_4", (String)"fi-fcc-opplugin", (Object[])new Object[0]));
        StringBuilder changeViewMessage = new StringBuilder(ResManager.loadKDString((String)"\u7ed3\u8d26\u89c6\u56fe\u53d8\u52a8\uff1a", (String)"CheckoutPlanSaveOpPlugin_5", (String)"fi-fcc-opplugin", (Object[])new Object[0]));
        String copyConfirm = option.getVariableValue("afterCopyConfirm");
        String sourcePk = option.getVariableValue("sourcePk");
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject dataEntity = dataEntities[0];
        DynamicObject plan = BusinessDataServiceHelper.loadSingleFromCache((Object)dataEntity.getPkValue(), (String)FCC_CHECKOUT_PLAN);
        String method = plan.getString("method");
        Date month = plan.getDate("month");
        DynamicObject oldPlan = BusinessDataServiceHelper.loadSingle((Object)sourcePk, (String)FCC_CHECKOUT_PLAN);
        QFilter qFilter = new QFilter("plan_id", "=", (Object)Long.valueOf(sourcePk));
        if (!CheckoutCycleEnum.MONTH_END.getValue().equals(method) && (flowDateDescs = BusinessDataServiceHelper.load((String)FCC_CHECKOUT_FLOW_DETAIL, (String)"id,flowdate", (QFilter[])new QFilter[]{qFilter}, (String)"flowdate desc", (int)1)).length > 0) {
            DynamicObject lastFlow = flowDateDescs[0];
            Date flowdate = lastFlow.getDate("flowdate");
            qFilter.and("flowdate", "=", (Object)flowdate);
        }
        if ((flows = BusinessDataServiceHelper.load((String)FCC_CHECKOUT_FLOW_DETAIL, (String)"id,plan,org,flowstatus,flowperson,creator,createtime,tasknum,flowdate,billstatus,taskentry.tasknumber,taskentry.pid,taskentry.eorg,taskentry.ebizorg,taskentry.type,taskentry.executor,taskentry.seq,taskentry.starttime,taskentry.endtime,taskentry.startdaytime,taskentry.enddaytime,taskentry.pretasks,taskentry.bizbooktype,taskentry.taskstatus", (QFilter[])new QFilter[]{qFilter})).length > 0) {
            long view = CheckOutViewUtil.getView((Long)plan.getLong("id"));
            Map<Object, DynamicObject> orgStructures = this.getLeafOrgByViewIgnoreAuth(view);
            List<Long> viewOrgIds = orgStructures.values().stream().map(dynamicObject -> dynamicObject.getLong("org.id")).collect(Collectors.toList());
            Map<Long, String> orgIdToName = orgStructures.values().stream().collect(Collectors.toMap(org1 -> org1.getLong("org.id"), org2 -> org2.getString("org.name")));
            this.getNewOrg(plan, flows, viewOrgIds, orgIdToName, changeViewMessage);
            HashMap<String, Long> memberMap = new HashMap<String, Long>();
            if (copyConfirm.equals(String.valueOf(MessageBoxResult.Yes.getValue()))) {
                QFilter orgFilter = new QFilter("org.id", "in", viewOrgIds);
                String selectFields = "org.id,fcc_checkout_members.businesssystem.id,fcc_checkout_members.member.id";
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)FCC_CHECKOUT_MEMBER, (String)selectFields, (QFilter[])new QFilter[]{orgFilter}, (String)"");){
                    while (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        memberMap.put(row.getLong("org.id") + "-" + row.getLong("fcc_checkout_members.businesssystem.id"), row.getLong("fcc_checkout_members.member.id"));
                    }
                }
            }
            for (DynamicObject flow : flows) {
                DynamicObject org = (DynamicObject)flow.get("org");
                if (!viewOrgIds.contains(org.getLong("id"))) {
                    this.addRedOrgTipMessage(org, changeViewMessage);
                    log.info("CheckoutPlanSaveOpPlugin():" + org.getString("name") + "\u7ec4\u7ec7\u51cf\u5c11,\u63d0\u793a\u4fe1\u606f,\u8df3\u8fc7\u590d\u5236");
                    continue;
                }
                DynamicObjectCollection permissionTasks = BaseDataServiceHelper.queryBaseData((String)FCC_CHECKOUT_TASK, (Long)org.getLong("id"), (QFilter)new QFilter("enable", "=", (Object)"1"), (String)"id");
                if (permissionTasks.isEmpty()) {
                    log.info("CheckoutPlanSaveOpPlugin():" + org.getString("name") + "\u7ec4\u7ec7\u6ca1\u6709\u6709\u6743\u9650\u7684\u4efb\u52a1\uff0c\u8df3\u8fc7\u590d\u5236\u6d41\u7a0b");
                    this.createFlow(plan, org.getLong("id"));
                    continue;
                }
                log.info("CheckoutPlanSaveOpPlugin():" + org.getString("name") + "\u7ec4\u7ec7\u5f00\u59cb\u590d\u5236\u6d41\u7a0b");
                List<Long> taskIds = permissionTasks.stream().map(task -> task.getLong("id")).collect(Collectors.toList());
                DynamicObjectType dynamicObjectType = flow.getDynamicObjectType();
                DynamicObject copyFlow = new DynamicObject(dynamicObjectType);
                copyFlow.set("plan", dataEntity.getPkValue());
                copyFlow.set("org", (Object)org);
                copyFlow.set("flowstatus", (Object)CheckoutFlowStatusEnum.unconfirm.getType());
                copyFlow.set("creator", (Object)RequestContext.get().getCurrUserId());
                copyFlow.set("createtime", (Object)new Date());
                copyFlow.set("billstatus", (Object)"A");
                if (CheckoutCycleEnum.MONTH_END.getValue().equals(method)) {
                    copyFlow.set("flowdate", (Object)month);
                } else {
                    copyFlow.set("flowdate", (Object)dataEntity.getDate("startdate"));
                }
                DynamicObjectCollection taskEntry = flow.getDynamicObjectCollection("taskentry");
                DynamicObjectCollection copyTaskEntry = copyFlow.getDynamicObjectCollection("taskentry");
                HashMap<String, Long> idMapping = new HashMap<String, Long>(taskEntry.size());
                HashMap<String, Long> pidMapping = new HashMap<String, Long>(taskEntry.size());
                HashMap<String, List<String>> preTaskMapping = new HashMap<String, List<String>>(taskEntry.size());
                int taskNum = 0;
                if (taskEntry.size() > 0) {
                    Map<Long, Long> idAndPid = taskEntry.stream().collect(Collectors.toMap(task -> task.getLong("id"), task -> task.getLong("pid")));
                    this.checkNoPermTask(taskEntry, taskIds, idAndPid, org, deleteTaskMessage);
                    for (DynamicObject task2 : taskEntry) {
                        DynamicObject preTask;
                        DynamicObjectCollection entryentity;
                        Collection<Long> allPid;
                        DynamicObject tasknumber = (DynamicObject)task2.get("tasknumber");
                        long taskId = task2.getLong("id");
                        long pid = task2.getLong("pid");
                        if (!idAndPid.containsKey(taskId) || pid == 0L && !(allPid = idAndPid.values()).contains(taskId)) continue;
                        DynamicObject copyTask = copyTaskEntry.addNew();
                        if (copyConfirm.equals(String.valueOf(MessageBoxResult.Yes.getValue()))) {
                            if (!memberMap.isEmpty()) {
                                Long id = (Long)memberMap.get(org.getLong("id") + "-" + tasknumber.getLong("bizsystem.id"));
                                if (id != null && id != 0L) {
                                    copyTask.set("executor", (Object)id);
                                } else {
                                    copyTask.set("executor", (Object)task2.getLong("executor_id"));
                                }
                            }
                        } else {
                            copyTask.set("executor", (Object)task2.getLong("executor_id"));
                        }
                        copyTask.set("tasknumber", (Object)tasknumber.getLong("id"));
                        copyTask.set("eorg", task2.get("eorg"));
                        copyTask.set("ebizorg", task2.get("ebizorg"));
                        copyTask.set("type", task2.get("type"));
                        copyTask.set("bizbooktype", task2.get("bizbooktype"));
                        copyTask.set("taskstatus", (Object)"a");
                        copyTask.set("seq", task2.get("seq"));
                        if (task2.getLong("pid") != 0L) {
                            ++taskNum;
                            if (CheckoutCycleEnum.MONTH_END.getValue().equals(method)) {
                                Date starttime = task2.getDate("starttime");
                                Date endtime = task2.getDate("endtime");
                                Date oldMonth = oldPlan.getDate("month");
                                copyTask.set("starttime", (Object)this.getDayOfCurrentMonth(oldMonth, starttime, month));
                                copyTask.set("endtime", (Object)this.getDayOfCurrentMonth(oldMonth, endtime, month));
                            } else {
                                copyTask.set("startdaytime", task2.get("startdaytime"));
                                copyTask.set("enddaytime", task2.get("enddaytime"));
                            }
                        } else if (CheckoutCycleEnum.DAY_END.getValue().equals(method)) {
                            copyTask.set("startdaytime", (Object)-1);
                            copyTask.set("enddaytime", (Object)-1);
                        }
                        QFilter preTaskFilter = new QFilter("flowid", "=", (Object)flow.getLong("id"));
                        preTaskFilter.and("taskrowid", "=", (Object)task2.getLong("id"));
                        DynamicObject[] preTasks = BusinessDataServiceHelper.load((String)FCC_CHECKOUT_PRETASKS, (String)"flowid,taskrowid,entryentity.tasknumber,entryentity.ebizorg,entryentity.type,entryentity.bizbooktype", (QFilter[])new QFilter[]{preTaskFilter});
                        if (preTasks.length > 0 && (entryentity = (preTask = preTasks[0]).getDynamicObjectCollection("entryentity")) != null && entryentity.size() > 0) {
                            String key = this.getKey(task2);
                            ArrayList<String> preTaskList = new ArrayList<String>(entryentity.size());
                            for (DynamicObject preTaskEntry : entryentity) {
                                String value = this.getKey(preTaskEntry);
                                preTaskList.add(value);
                            }
                            preTaskMapping.put(key, preTaskList);
                        }
                        String key = this.getKey(task2);
                        if (task2.getLong("pid") == 0L) {
                            idMapping.put(key, task2.getLong("id"));
                            continue;
                        }
                        pidMapping.put(key, task2.getLong("pid"));
                    }
                }
                copyFlow.set("tasknum", (Object)taskNum);
                DynamicObject[] newTasks = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{copyFlow});
                if (!pidMapping.isEmpty()) {
                    DynamicObject newTask = BusinessDataServiceHelper.loadSingle((Object)newTasks[0].getPkValue(), (String)FCC_CHECKOUT_FLOW_DETAIL);
                    this.setTaskParentRelation(newTask, idMapping, pidMapping);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newTask});
                }
                if (preTaskMapping.isEmpty()) continue;
                this.copyPreTasks(preTaskMapping, newTasks[0].getPkValue());
            }
        }
        String delTaskMess = ResManager.loadKDString((String)"\u4efb\u52a1\u5220\u9664\uff1a", (String)"CheckoutPlanSaveOpPlugin_4", (String)"fi-fcc-opplugin", (Object[])new Object[0]);
        String changeViewMess = ResManager.loadKDString((String)"\u7ed3\u8d26\u89c6\u56fe\u53d8\u52a8\uff1a", (String)"CheckoutPlanSaveOpPlugin_5", (String)"fi-fcc-opplugin", (Object[])new Object[0]);
        if (deleteTaskMessage.length() > delTaskMess.length()) {
            deleteTaskMessage.append("\n\n");
            this.getOption().setVariableValue("deleteTaskMessage", deleteTaskMessage.toString());
        }
        if (changeViewMessage.length() > changeViewMess.length()) {
            this.getOption().setVariableValue("changeViewMessage", changeViewMessage.toString());
        }
    }

    private void checkNoPermTask(DynamicObjectCollection taskEntry, List<Long> taskIds, Map<Long, Long> idAndPid, DynamicObject org, StringBuilder deleteTaskMessage) {
        ArrayList<Long> firstTaskIds = new ArrayList<Long>();
        for (DynamicObject task : taskEntry) {
            String format;
            String taskName;
            DynamicObject tasknumber = (DynamicObject)task.get("tasknumber");
            long taskId = task.getLong("id");
            long pid = task.getLong("pid");
            if (!taskIds.contains(task.getLong("tasknumber.id"))) {
                firstTaskIds.add(taskId);
                taskName = "";
                if (tasknumber != null) {
                    taskName = tasknumber.getString("name");
                }
                format = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7%1$s\u65e0\u6743\u9650\u4f7f\u7528\u7ed3\u8d26\u4efb\u52a1%2$s\uff0c\u5df2\u81ea\u52a8\u5220\u9664\u3002", (String)"CheckoutPlanSaveOpPlugin_3", (String)"fi-fcc-opplugin", (Object[])new Object[0]), org.getString("name"), taskName);
                deleteTaskMessage.append("\n").append(format);
                idAndPid.remove(taskId);
                continue;
            }
            if (!firstTaskIds.contains(pid)) continue;
            taskName = "";
            if (tasknumber != null) {
                taskName = tasknumber.getString("name");
            }
            format = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7%1$s\u65e0\u6743\u9650\u4f7f\u7528\u7ed3\u8d26\u4efb\u52a1%2$s\uff0c\u5df2\u81ea\u52a8\u5220\u9664\u3002", (String)"CheckoutPlanSaveOpPlugin_3", (String)"fi-fcc-opplugin", (Object[])new Object[0]), org.getString("name"), taskName);
            deleteTaskMessage.append("\n").append(format);
            idAndPid.remove(taskId);
        }
    }

    private Date getDayOfCurrentMonth(Date oldMonth, Date date, Date month) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int h = cal.get(11);
        int m = cal.get(12);
        int s = cal.get(13);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        Date param = cal.getTime();
        Date oldTDate = FccUtil.getTDate((Date)oldMonth);
        long l = param.getTime() - oldTDate.getTime();
        int n = (int)(l / 86400000L);
        Date tDate = FccUtil.getTDate((Date)month);
        cal.setTime(tDate);
        cal.add(5, n);
        cal.set(11, h);
        cal.set(12, m);
        cal.set(13, s);
        return cal.getTime();
    }

    private void copyPreTasks(Map<String, List<String>> preTaskMapping, Object newTaskId) {
        String key;
        DynamicObject newTask = BusinessDataServiceHelper.loadSingle((Object)newTaskId, (String)FCC_CHECKOUT_FLOW_DETAIL);
        DynamicObjectCollection taskentry = newTask.getDynamicObjectCollection("taskentry");
        HashMap<String, Long> taskIdMapping = new HashMap<String, Long>(taskentry.size());
        for (DynamicObject task : taskentry) {
            if (task.getLong("pid") == 0L) continue;
            key = this.getKey(task);
            taskIdMapping.put(key, task.getLong("id"));
        }
        for (DynamicObject task : taskentry) {
            key = this.getKey(task);
            List<String> list = preTaskMapping.get(key);
            if (list == null || list.size() <= 0) continue;
            DynamicObject copyPreTask = BusinessDataServiceHelper.newDynamicObject((String)FCC_CHECKOUT_PRETASKS);
            copyPreTask.set("flowid", (Object)newTask.getLong("id"));
            copyPreTask.set("taskrowid", (Object)task.getLong("id"));
            DynamicObjectCollection entryentity = copyPreTask.getDynamicObjectCollection("entryentity");
            for (String keyString : list) {
                log.info(((Object)((Object)this)).getClass().getName() + "-\u524d\u7f6e\u4efb\u52a1\u8054\u5408\u552f\u4e00\u5b57\u6bb5\uff1a" + keyString);
                DynamicObject preTaskEntry = entryentity.addNew();
                Long preTaskId = (Long)taskIdMapping.get(keyString);
                preTaskEntry.set("othertaskid", (Object)preTaskId);
                String[] split = keyString.split("-");
                log.info(((Object)((Object)this)).getClass().getName() + "-\u524d\u7f6e\u4efb\u52a1\u8054\u5408\u552f\u4e00\u5b57\u6bb5\u62c6\u5206-\u4efb\u52a1split[0]\uff1a" + split[0]);
                log.info(((Object)((Object)this)).getClass().getName() + "-\u524d\u7f6e\u4efb\u52a1\u8054\u5408\u552f\u4e00\u5b57\u6bb5\u62c6\u5206-\u4e1a\u52a1\u7ec4\u7ec7split[1]\uff1a" + split[1]);
                log.info(((Object)((Object)this)).getClass().getName() + "-\u524d\u7f6e\u4efb\u52a1\u8054\u5408\u552f\u4e00\u5b57\u6bb5\u62c6\u5206-\u7c7b\u578b(\u4e1a\u52a1\u5e94\u7528)split[2]\uff1a" + split[2]);
                log.info(((Object)((Object)this)).getClass().getName() + "-\u524d\u7f6e\u4efb\u52a1\u8054\u5408\u552f\u4e00\u5b57\u6bb5\u62c6\u5206-\u7c7b\u578bsplit[3]\uff1a" + split[3]);
                preTaskEntry.set("tasknumber", (Object)split[0]);
                preTaskEntry.set("ebizorg", (Object)split[1]);
                preTaskEntry.set("type", (Object)split[2]);
                preTaskEntry.set("bizbooktype", (Object)split[3]);
                preTaskEntry.set("starttime", task.get("starttime"));
                preTaskEntry.set("endtime", task.get("endtime"));
                preTaskEntry.set("startdaytime", task.get("startdaytime"));
                preTaskEntry.set("enddaytime", task.get("enddaytime"));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{copyPreTask});
        }
    }

    private void setTaskParentRelation(DynamicObject newTask, Map<String, Long> idMapping, Map<String, Long> pidMapping) {
        DynamicObjectCollection taskentry = newTask.getDynamicObjectCollection("taskentry");
        HashMap<String, String> relationMap = new HashMap<String, String>(taskentry.size());
        for (Map.Entry<String, Long> entry : idMapping.entrySet()) {
            String key = entry.getKey();
            long id = entry.getValue();
            for (Map.Entry<String, Long> pidEntry : pidMapping.entrySet()) {
                String key1 = pidEntry.getKey();
                long value = pidEntry.getValue();
                if (value != id) continue;
                relationMap.put(key1, key);
            }
        }
        HashMap<String, Long> map = new HashMap<String, Long>(taskentry.size());
        for (DynamicObject task : taskentry) {
            String key = this.getKey(task);
            long pid = task.getLong("id");
            if (pid == 0L) continue;
            map.put(key, pid);
        }
        for (DynamicObject task : taskentry) {
            String key = this.getKey(task);
            String paramStr = (String)relationMap.get(key);
            if (!StringUtils.isNotEmpty((String)paramStr)) continue;
            Long pid = (Long)map.get(paramStr);
            task.set("pid", (Object)pid);
        }
    }

    public String getKey(DynamicObject task) {
        long taskId = task.getLong("tasknumber_id");
        long ebizorgId = task.getLong("ebizorg_id");
        String type = task.getString("type");
        if (StringUtils.isEmpty((String)type)) {
            type = " ";
        }
        DynamicObject bizbooktype = task.getDynamicObject("bizbooktype");
        long bizbooktypeid = 0L;
        if (bizbooktype != null) {
            bizbooktypeid = bizbooktype.getLong("id");
        }
        String key = taskId + "-" + ebizorgId + "-" + type + "-" + bizbooktypeid;
        return key;
    }

    private void addRedOrgTipMessage(DynamicObject org, StringBuilder changeViewMessage) {
        String format = String.format(ResManager.loadKDString((String)"\u539f\u7ed3\u8d26\u8ba1\u5212\u4e2d\u7684\u6838\u7b97\u7ec4\u7ec7%1$s\u5df2\u5220\u9664\u3002", (String)"CheckoutPlanSaveOpPlugin_1", (String)"fi-fcc-opplugin", (Object[])new Object[0]), org.getString("name"));
        changeViewMessage.append("\n").append(format);
    }

    private void getNewOrg(DynamicObject plan, DynamicObject[] flows, List<Long> viewOrgIds, Map<Long, String> map, StringBuilder changeViewMessage) {
        List orgIds = Arrays.stream(flows).map(flow -> flow.getLong("org.id")).collect(Collectors.toList());
        ArrayList<Long> viewOrgIds2 = new ArrayList<Long>(viewOrgIds);
        viewOrgIds2.removeAll(orgIds);
        if (viewOrgIds2.size() > 0) {
            for (Long orgId : viewOrgIds2) {
                if (!map.containsKey(orgId)) continue;
                String name = map.get(orgId);
                String format = String.format(ResManager.loadKDString((String)"\u7ed3\u8d26\u7ec4\u7ec7\u89c6\u56fe\u4e0b\u65b0\u589e\u6838\u7b97\u7ec4\u7ec7%1$s,\u8bf7\u5728\u8ba1\u5212\u4e0b\u8bbe\u7f6e\u7ed3\u8d26\u4efb\u52a1\u3002", (String)"CheckoutPlanSaveOpPlugin_2", (String)"fi-fcc-opplugin", (Object[])new Object[0]), name);
                changeViewMessage.append("\n").append(format);
            }
            this.createFlowsForAddOrg(plan, viewOrgIds2);
        }
    }

    private void createFlowsForAddOrg(DynamicObject plan, List<Long> viewOrgIds) {
        for (Long orgId : viewOrgIds) {
            DynamicObject flow = BusinessDataServiceHelper.newDynamicObject((String)FCC_CHECKOUT_FLOW_DETAIL);
            flow.set("plan", plan.getPkValue());
            flow.set("org", (Object)orgId);
            flow.set("flowstatus", (Object)CheckoutFlowStatusEnum.unconfirm.getType());
            flow.set("creator", (Object)RequestContext.get().getCurrUserId());
            flow.set("createtime", (Object)new Date());
            flow.set("billstatus", (Object)"A");
            flow.set("tasknum", (Object)flow.getInt("tasknum"));
            String method = plan.getString("method");
            if (CheckoutCycleEnum.MONTH_END.getValue().equals(method)) {
                Date month = plan.getDate("month");
                flow.set("flowdate", (Object)month);
            } else {
                flow.set("flowdate", (Object)plan.getDate("startdate"));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{flow});
        }
    }

    private Map<Object, DynamicObject> getLeafOrgByViewIgnoreAuth(long view) {
        QFilter qFilter = new QFilter("view", "=", (Object)view);
        qFilter.and("isleaf", "=", (Object)"1");
        qFilter.and("org.enable", "=", (Object)"1");
        String selectProperties = "id,org.id,org.name,org.number,parent.id,isleaf,longnumber";
        Map orgStructures = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
        return orgStructures;
    }

    private void createFlows(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            DynamicObject plan = BusinessDataServiceHelper.loadSingleFromCache((Object)dataEntity.getPkValue(), (String)FCC_CHECKOUT_PLAN);
            String method = plan.getString("method");
            long view = CheckOutViewUtil.getView((Long)plan.getLong("id"));
            Map<Object, DynamicObject> enableLeafOrgByView = this.getLeafOrgByViewIgnoreAuth(view);
            List viewOrgIds = enableLeafOrgByView.values().stream().map(dynamicObject -> dynamicObject.getLong("org.id")).collect(Collectors.toList());
            for (Long orgId : viewOrgIds) {
                this.createFlow(plan, orgId);
            }
        }
    }

    private void createFlow(DynamicObject plan, long orgId) {
        DynamicObject flow = BusinessDataServiceHelper.newDynamicObject((String)FCC_CHECKOUT_FLOW_DETAIL);
        flow.set("plan", plan.getPkValue());
        flow.set("org", (Object)orgId);
        flow.set("flowstatus", (Object)CheckoutFlowStatusEnum.unconfirm.getType());
        flow.set("creator", (Object)RequestContext.get().getCurrUserId());
        flow.set("createtime", (Object)new Date());
        flow.set("billstatus", (Object)"A");
        flow.set("flowperson", null);
        flow.set("tasknum", (Object)0);
        if (CheckoutCycleEnum.MONTH_END.getValue().equals(plan.getString("method"))) {
            Date month = plan.getDate("month");
            flow.set("flowdate", (Object)month);
        } else {
            flow.set("flowdate", (Object)plan.getDate("startdate"));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{flow});
    }
}

