/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.opplugin;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.fcc.common.enums.CheckoutCycleEnum;
import kd.fi.fcc.common.utils.CheckOutViewUtil;
import kd.fi.fcc.common.utils.FccUtil;
import kd.fi.fcc.opplugin.validator.CheckoutPlanUnReleaseValidator;

public class CheckoutPlanUnReleaseOpPlugin
extends AbstractOperationServicePlugIn {
    private static final String FCC_CHECKOUT_PLAN = "fcc_checkout_plan";
    private static final String FLOW_DETAIL_ENTITY = "fcc_checkout_flow_detail";
    private static final String FCC_CHECKOUT_FLOW_DETAIL = "fcc_checkout_flow_detail";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(this.billEntityType.getAllFields().keySet());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new CheckoutPlanUnReleaseValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        if (!"unrelease".equals(operationKey)) {
            return;
        }
        for (DynamicObject dataEntity : dataEntities) {
            OperationResult operationResult;
            QFilter qFilter = new QFilter("plan", "=", dataEntity.getPkValue());
            qFilter.and("taskentry.taskstatus", "!=", (Object)"a");
            boolean exists = QueryServiceHelper.exists((String)"fcc_checkout_flow_detail", (QFilter[])new QFilter[]{qFilter});
            if (!exists && !(operationResult = CheckOutViewUtil.deleteFccOrgStrcuture((DynamicObject)dataEntity)).isSuccess()) {
                ValidationErrorInfo info = new ValidationErrorInfo("", dataEntity.getPkValue(), 0, 0, "errorcode_002", "", operationResult.getMessage(), ErrorLevel.Error);
                this.operationResult.addErrorInfo((OperateErrorInfo)info);
                e.setCancelOperation(true);
                return;
            }
            dataEntity.set("planstatus", (Object)"A");
            dataEntity.set("unpublisher", (Object)this.getCurrentUser());
            dataEntity.set("unreleasetime", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.endOperationTransaction(e);
        for (DynamicObject plan : dataEntities = e.getDataEntities()) {
            if (CheckoutCycleEnum.MONTH_END.getValue().equals(plan.getString("method"))) {
                this.setStartAndEndTime(plan, plan.getDate("month"), "starttime", "endtime");
                continue;
            }
            QFilter qFilter = new QFilter("plan", "=", plan.getPkValue());
            Date latestFlowDate = FccUtil.getLatestFlowDate((Long)plan.getLong("id"));
            if (latestFlowDate == null) continue;
            this.setStartAndEndTime(plan, latestFlowDate, "startdaytime", "enddaytime");
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities;
        super.afterExecuteOperationTransaction(e);
        for (DynamicObject plan : dataEntities = e.getDataEntities()) {
            long view = CheckOutViewUtil.getView((Long)plan.getLong("id"));
            List orgIdsByCurrView = CheckOutViewUtil.getAllLeaveOrgs((Long)view);
            CheckOutViewUtil.createFlows((DynamicObject)plan, (List)orgIdsByCurrView);
        }
    }

    private void setStartAndEndTime(DynamicObject plan, Date flowdate, String starttime, String endtime) {
        QFilter qFilter = new QFilter("plan", "=", plan.getPkValue());
        qFilter.and("flowdate", "=", (Object)flowdate);
        DynamicObject[] flows = BusinessDataServiceHelper.load((String)"fcc_checkout_flow_detail", (String)"id,plan,org,flowstatus,flowdate,taskentry.tasknumber,taskentry.pid,taskentry.starttime,taskentry.endtime,taskentry.startdaytime,taskentry.enddaytime", (QFilter[])new QFilter[]{qFilter});
        if (flows.length > 0) {
            for (DynamicObject flow : flows) {
                DynamicObjectCollection taskentry = flow.getDynamicObjectCollection("taskentry");
                if (taskentry.size() <= 0) continue;
                for (DynamicObject task : taskentry) {
                    long pid = task.getLong("pid");
                    if (pid != 0L) continue;
                    if ("starttime".equals(starttime) && "endtime".equals(endtime)) {
                        task.set(starttime, null);
                        task.set(endtime, null);
                        continue;
                    }
                    task.set(starttime, (Object)-1);
                    task.set(endtime, (Object)-1);
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])flows);
    }

    private DynamicObject getCurrentUser() {
        long currUserId = UserServiceHelper.getCurrentUserId();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)currUserId, (String)"bos_user");
        return dynamicObject;
    }
}

