/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.opplugin;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fcc.common.constant.FCCField;
import kd.fi.fcc.common.enums.CheckoutCycleEnum;
import kd.fi.fcc.common.enums.CheckoutFlowStatusEnum;
import kd.fi.fcc.common.enums.DelayStatusEnum;
import kd.fi.fcc.common.enums.TaskStatusEnum;
import kd.fi.fcc.common.utils.FccUtil;

public class TemplateAssignOpPlugin
extends AbstractOperationServicePlugIn {
    private Map<String, String> typeMap = new HashMap<String, String>(4);
    private Map<Object, DynamicObject> bizSystemMap = this.getBizSystem();
    Map<Long, Map<Long, Long>> orgPersionMap = new HashMap<Long, Map<Long, Long>>(16);

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] flowDatas2;
        DynamicObject[] flowDatas;
        QFilter[] filters;
        this.typeMap.put("bd_accountbookstype", "gl_accountbook");
        this.typeMap.put("fa_depreuse", "fa_assetbook");
        this.typeMap.put("ar_policytype", "ar_policy");
        this.typeMap.put("cal_bd_costaccounttype", "cal_bd_costaccount");
        String orgStr = null;
        String planStr = null;
        String templateStr = null;
        if (this.operateOption.containsVariable("org")) {
            orgStr = this.operateOption.getVariableValue("org");
        }
        if (this.operateOption.containsVariable("plan")) {
            planStr = this.operateOption.getVariableValue("plan");
        }
        if (this.operateOption.containsVariable("template")) {
            templateStr = this.operateOption.getVariableValue("template");
        }
        if (orgStr == null || planStr == null || templateStr == null) {
            e.setCancelOperation(true);
            return;
        }
        List orgList = (List)SerializationUtils.fromJsonString((String)orgStr, List.class);
        this.initPersionMap(orgList);
        long planId = Long.parseLong(planStr);
        long templateId = Long.parseLong(templateStr);
        Map templates = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{templateId}, (String)"fcc_checkout_template");
        DynamicObject templateDyn = (DynamicObject)templates.get(templateId);
        Map plans = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{planId}, (String)"fcc_checkout_plan");
        DynamicObject plan = (DynamicObject)plans.get(planId);
        ArrayList<Long> flowIds = new ArrayList<Long>(orgList.size());
        QFilter orgFilter = new QFilter("org", "in", (Object)orgList);
        QFilter planFilter = new QFilter("plan", "=", (Object)planId);
        QFilter statusFilter = new QFilter("flowstatus", "=", (Object)CheckoutFlowStatusEnum.unconfirm.getType());
        if (CheckoutCycleEnum.DAY_END.getValue().equals(templateDyn.getString("checkouttype"))) {
            QFilter dayFilter = new QFilter("flowdate", "=", (Object)FccUtil.getLatestFlowDate((Long)planId));
            filters = new QFilter[]{orgFilter, planFilter, statusFilter, dayFilter};
        } else {
            filters = new QFilter[]{orgFilter, planFilter, statusFilter};
        }
        FccUtil.getLatestFlowDate((Long)planId);
        DynamicObject[] dynamicObjectArray = null;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.fi.fcc.opplugin.TemplateAssignOpPlugin", (String)"fcc_checkout_flow_detail", (String)"id", (QFilter[])filters, null);){
            for (Row row : ds) {
                flowIds.add(row.getLong("id"));
            }
        }
        catch (Throwable object) {
            dynamicObjectArray = object;
            throw object;
        }
        for (DynamicObject flow : flowDatas = BusinessDataServiceHelper.load((Object[])flowIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fcc_checkout_flow_detail"))) {
            String key;
            int tasknum = 0;
            DynamicObject org = flow.getDynamicObject("org");
            Map<Long, Long> app2Persion = this.orgPersionMap.get(org.getLong("id"));
            HashMap pTask2allTasks = new HashMap(16);
            HashMap bizOrg2BizbookType = new HashMap(1);
            DynamicObjectCollection taskEntry = flow.getDynamicObjectCollection("taskentry");
            taskEntry.clear();
            int seq = 1;
            HashMap<String, Map<Object, Object>> configMap = new HashMap<String, Map<Object, Object>>(16);
            Long pType = null;
            Long pBizOrg = null;
            ArrayList<DynamicObject> flowRows = null;
            for (DynamicObject templateTaskRow : templateDyn.getDynamicObjectCollection("taskentry")) {
                Set typeList;
                DynamicObject book;
                Object bizBookTypes;
                long typeId;
                long bizOrgId;
                Object configRow2;
                Map<Long, Set> bizOrg2Types;
                DynamicObjectCollection configCollection;
                DynamicObject flowTaskRow = taskEntry.addNew();
                DynamicObject templateTask = templateTaskRow.getDynamicObject("task");
                flowTaskRow.set("tasknumber", (Object)templateTask);
                flowTaskRow.set("eorg", (Object)org);
                String typeBiz = this.bizSystemMap.get(templateTask.getLong(FCCField.id_((String)"bizsystem"))).getString("type");
                flowTaskRow.set("type", (Object)typeBiz);
                flowTaskRow.set("seq", (Object)seq++);
                String taskType = templateTask.getString("tasktype");
                if (!"1".equals(taskType)) {
                    if (CheckoutCycleEnum.MONTH_END.getValue().equals(plan.getString("method"))) {
                        Object startDate = templateTaskRow.get("startdate");
                        Integer endDate = templateTaskRow.getInt("enddate");
                        Date date = plan.getDate("month");
                        if (startDate != null) {
                            int startDateInt = Integer.parseInt(startDate.toString());
                            int startTime = templateTaskRow.getInt("starttime");
                            flowTaskRow.set("starttime", (Object)this.getDate(date, startDateInt, startTime));
                        }
                        if (endDate != null) {
                            int endDateInt = Integer.parseInt(((Object)endDate).toString());
                            int endTime = templateTaskRow.getInt("endtime");
                            flowTaskRow.set("endtime", (Object)this.getDate(date, endDateInt, endTime));
                        }
                    } else if (CheckoutCycleEnum.DAY_END.getValue().equals(plan.getString("method"))) {
                        flowTaskRow.set("startdaytime", (Object)templateTaskRow.getInt("starttime"));
                        flowTaskRow.set("enddaytime", (Object)templateTaskRow.getInt("endtime"));
                    }
                } else {
                    flowTaskRow.set("starttime", null);
                    flowTaskRow.set("endtime", null);
                    flowTaskRow.set("startdaytime", (Object)-1);
                    flowTaskRow.set("enddaytime", (Object)-1);
                }
                flowTaskRow.set("taskstatus", (Object)TaskStatusEnum.NOT_START.getType());
                flowTaskRow.set("isdelay", (Object)DelayStatusEnum.NORMAL.getType());
                String bizBookTypeStr = this.typeMap.get(typeBiz);
                long srcSys = templateTask.getLong(FCCField.id_((String)"group"));
                long bizApp = templateTask.getLong(FCCField.id_((String)"bizsystem"));
                if (app2Persion != null) {
                    flowTaskRow.set("executor", (Object)app2Persion.get(bizApp));
                }
                if ("bd_accountbookstype".equals(typeBiz)) {
                    if ("1".equals(taskType)) {
                        flowRows = new ArrayList<DynamicObject>(16);
                        flowRows.add(flowTaskRow);
                        pTask2allTasks.put(templateTask.getLong("id"), flowRows);
                        pType = null;
                        pBizOrg = null;
                        configCollection = this.getAccountOrgConfig(org.getLong("id"), srcSys, bizApp);
                        key = srcSys + "-" + bizApp;
                        bizOrg2Types = (Map)configMap.get(key);
                        if (bizOrg2Types == null) {
                            bizOrg2Types = new HashMap(8);
                            configMap.put(key, bizOrg2Types);
                        }
                        if (configCollection != null && configCollection.size() > 0) {
                            for (Object configRow2 : configCollection) {
                                bizOrgId = configRow2.getLong("entryentity.bizorg");
                                typeId = configRow2.getLong("entryentity.bizbooktype");
                                if (pBizOrg == null) {
                                    pBizOrg = bizOrgId;
                                    pType = typeId;
                                }
                                bizOrg2Types.compute(bizOrgId, (k, v) -> {
                                    if (v == null) {
                                        v = new HashSet<Long>(2);
                                    }
                                    v.add(typeId);
                                    return v;
                                });
                            }
                            flowTaskRow.set("ebizorg", pBizOrg);
                            flowTaskRow.set(FCCField.id_((String)"ebizorg"), (Object)pBizOrg);
                            flowTaskRow.set("bizbooktype", pType);
                            flowTaskRow.set(FCCField.id_((String)"bizbooktype"), pType);
                            continue;
                        }
                        bizBookTypes = BusinessDataServiceHelper.loadFromCache((String)bizBookTypeStr, (String)"id,bookstype.accounttype", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)org.getLong("id")), new QFilter("enable", "=", (Object)true)});
                        configRow2 = bizBookTypes.entrySet().iterator();
                        while (configRow2.hasNext()) {
                            Map.Entry bizBookTypeEntry = (Map.Entry)configRow2.next();
                            book = (DynamicObject)bizBookTypeEntry.getValue();
                            if ("1".equals(book.getDynamicObject("bookstype").getString("accounttype"))) {
                                pType = book.getLong("bookstype_id");
                            }
                            bizOrg2BizbookType.compute(org.getLong("id") + "-" + typeBiz, (k, v) -> {
                                if (v == null) {
                                    v = new HashSet<Long>(1);
                                }
                                v.add(book.getLong("bookstype_id"));
                                return v;
                            });
                        }
                        if (pType == null && !CollectionUtils.isEmpty((Collection)(typeList = (Set)bizOrg2BizbookType.get(org.getLong("id") + "-" + typeBiz)))) {
                            pType = (Long)typeList.iterator().next();
                        }
                        pBizOrg = org.getLong("id");
                        flowTaskRow.set("ebizorg", (Object)org);
                        flowTaskRow.set("bizbooktype", (Object)pType);
                        flowTaskRow.set(FCCField.id_((String)"bizbooktype"), (Object)pType);
                        continue;
                    }
                    flowTaskRow.set("ebizorg", pBizOrg);
                    flowTaskRow.set(FCCField.id_((String)"ebizorg"), pBizOrg);
                    flowTaskRow.set("bizbooktype", pType);
                    flowTaskRow.set(FCCField.id_((String)"bizbooktype"), pType);
                    flowRows.add(flowTaskRow);
                    ++tasknum;
                    continue;
                }
                if ("fa_depreuse".equals(typeBiz)) {
                    if ("1".equals(taskType)) {
                        flowRows = new ArrayList(16);
                        flowRows.add(flowTaskRow);
                        pTask2allTasks.put(templateTask.getLong("id"), flowRows);
                        pType = null;
                        pBizOrg = null;
                        configCollection = this.getAccountOrgConfig(org.getLong("id"), srcSys, bizApp);
                        key = srcSys + "-" + bizApp;
                        bizOrg2Types = (Map)configMap.get(key);
                        if (bizOrg2Types == null) {
                            bizOrg2Types = new HashMap(8);
                            configMap.put(key, bizOrg2Types);
                        }
                        if (configCollection != null && configCollection.size() > 0) {
                            for (Object configRow2 : configCollection) {
                                bizOrgId = configRow2.getLong("entryentity.bizorg");
                                typeId = configRow2.getLong("entryentity.bizbooktype");
                                if (pBizOrg == null) {
                                    pBizOrg = bizOrgId;
                                    pType = typeId;
                                }
                                bizOrg2Types.compute(bizOrgId, (k, v) -> {
                                    if (v == null) {
                                        v = new HashSet<Long>(2);
                                    }
                                    v.add(typeId);
                                    return v;
                                });
                            }
                            flowTaskRow.set("ebizorg", pBizOrg);
                            flowTaskRow.set(FCCField.id_((String)"ebizorg"), (Object)pBizOrg);
                            flowTaskRow.set("bizbooktype", pType);
                            flowTaskRow.set(FCCField.id_((String)"bizbooktype"), (Object)pType);
                            continue;
                        }
                        bizBookTypes = BusinessDataServiceHelper.loadFromCache((String)bizBookTypeStr, (String)"id,org,depreuse.default", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)org.getLong("id")), new QFilter("enable", "=", (Object)true)});
                        configRow2 = bizBookTypes.entrySet().iterator();
                        while (configRow2.hasNext()) {
                            Map.Entry bizBookTypeEntry = (Map.Entry)configRow2.next();
                            book = (DynamicObject)bizBookTypeEntry.getValue();
                            if (book.getDynamicObject("depreuse").getBoolean("default")) {
                                pType = book.getLong("depreuse_id");
                            }
                            bizOrg2BizbookType.compute(book.getLong(FCCField.id_((String)"org")) + "-" + typeBiz, (k, v) -> {
                                if (v == null) {
                                    v = new HashSet<Long>(1);
                                }
                                v.add(book.getLong("depreuse_id"));
                                return v;
                            });
                        }
                        if (pType == null && !CollectionUtils.isEmpty((Collection)(typeList = (Set)bizOrg2BizbookType.get(org.getLong("id") + "-" + typeBiz)))) {
                            pType = (Long)typeList.iterator().next();
                        }
                        pBizOrg = org.getLong("id");
                        flowTaskRow.set("ebizorg", (Object)org);
                        flowTaskRow.set("bizbooktype", (Object)pType);
                        flowTaskRow.set(FCCField.id_((String)"bizbooktype"), (Object)pType);
                        continue;
                    }
                    flowTaskRow.set("ebizorg", pBizOrg);
                    flowTaskRow.set(FCCField.id_((String)"ebizorg"), pBizOrg);
                    flowTaskRow.set("bizbooktype", pType);
                    flowTaskRow.set(FCCField.id_((String)"bizbooktype"), pType);
                    flowRows.add(flowTaskRow);
                    ++tasknum;
                    continue;
                }
                if ("ar_policytype".equals(typeBiz)) {
                    if ("1".equals(taskType)) {
                        flowRows = new ArrayList(16);
                        flowRows.add(flowTaskRow);
                        pTask2allTasks.put(templateTask.getLong("id"), flowRows);
                        pType = null;
                        pBizOrg = null;
                        configCollection = this.getAccountOrgConfig(org.getLong("id"), srcSys, bizApp);
                        key = srcSys + "-" + bizApp;
                        bizOrg2Types = (Map)configMap.get(key);
                        if (bizOrg2Types == null) {
                            bizOrg2Types = new HashMap(8);
                            configMap.put(key, bizOrg2Types);
                        }
                        if (configCollection != null && configCollection.size() > 0) {
                            for (Object configRow2 : configCollection) {
                                bizOrgId = configRow2.getLong("entryentity.bizorg");
                                typeId = configRow2.getLong("entryentity.bizbooktype");
                                if (pBizOrg == null) {
                                    pBizOrg = bizOrgId;
                                    pType = typeId;
                                }
                                bizOrg2Types.compute(bizOrgId, (k, v) -> {
                                    if (v == null) {
                                        v = new HashSet<Long>(2);
                                    }
                                    v.add(typeId);
                                    return v;
                                });
                            }
                            flowTaskRow.set("ebizorg", (Object)pBizOrg);
                            flowTaskRow.set(FCCField.id_((String)"ebizorg"), (Object)pBizOrg);
                            flowTaskRow.set("bizbooktype", (Object)pType);
                            flowTaskRow.set(FCCField.id_((String)"bizbooktype"), (Object)pType);
                            continue;
                        }
                        bizBookTypes = BusinessDataServiceHelper.loadFromCache((String)bizBookTypeStr, (String)"id,useorg,policytype.type", (QFilter[])new QFilter[]{new QFilter("useorg", "in", (Object)org.getLong("id")), new QFilter("enable", "=", (Object)true)});
                        configRow2 = bizBookTypes.entrySet().iterator();
                        while (configRow2.hasNext()) {
                            Map.Entry bizBookTypeEntry = (Map.Entry)configRow2.next();
                            book = (DynamicObject)bizBookTypeEntry.getValue();
                            if ("master".equals(book.getDynamicObject("policytype").getString("type"))) {
                                pType = book.getLong("policytype_id");
                            }
                            bizOrg2BizbookType.compute(book.getLong(FCCField.id_((String)"useorg")) + "-" + typeBiz, (k, v) -> {
                                if (v == null) {
                                    v = new HashSet<Long>(1);
                                }
                                v.add(book.getLong("policytype_id"));
                                return v;
                            });
                        }
                        if (pType == null && !CollectionUtils.isEmpty((Collection)(typeList = (Set)bizOrg2BizbookType.get(org.getLong("id") + "-" + typeBiz)))) {
                            pType = (Long)typeList.iterator().next();
                        }
                        pBizOrg = org.getLong("id");
                        flowTaskRow.set("ebizorg", (Object)org);
                        flowTaskRow.set("bizbooktype", (Object)pType);
                        flowTaskRow.set(FCCField.id_((String)"bizbooktype"), (Object)pType);
                        continue;
                    }
                    flowTaskRow.set("ebizorg", pBizOrg);
                    flowTaskRow.set(FCCField.id_((String)"ebizorg"), pBizOrg);
                    flowTaskRow.set("bizbooktype", pType);
                    flowTaskRow.set(FCCField.id_((String)"bizbooktype"), pType);
                    flowRows.add(flowTaskRow);
                    ++tasknum;
                    continue;
                }
                if ("cal_bd_costaccounttype".equals(typeBiz)) {
                    if ("1".equals(taskType)) {
                        flowRows = new ArrayList(16);
                        flowRows.add(flowTaskRow);
                        pTask2allTasks.put(templateTask.getLong("id"), flowRows);
                        pType = null;
                        pBizOrg = null;
                        configCollection = this.getAccountOrgConfig(org.getLong("id"), srcSys, bizApp);
                        key = srcSys + "-" + bizApp;
                        bizOrg2Types = (Map)configMap.get(key);
                        if (bizOrg2Types == null) {
                            bizOrg2Types = new HashMap(8);
                            configMap.put(key, bizOrg2Types);
                        }
                        if (configCollection != null && configCollection.size() > 0) {
                            for (Object configRow2 : configCollection) {
                                bizOrgId = configRow2.getLong("entryentity.bizorg");
                                typeId = configRow2.getLong("entryentity.bizbooktype");
                                if (pBizOrg == null) {
                                    pBizOrg = bizOrgId;
                                    pType = typeId;
                                }
                                bizOrg2Types.compute(bizOrgId, (k, v) -> {
                                    if (v == null) {
                                        v = new HashSet<Long>(2);
                                    }
                                    v.add(typeId);
                                    return v;
                                });
                            }
                            flowTaskRow.set("ebizorg", (Object)pBizOrg);
                            flowTaskRow.set(FCCField.id_((String)"ebizorg"), (Object)pBizOrg);
                            flowTaskRow.set("bizbooktype", (Object)pType);
                            flowTaskRow.set(FCCField.id_((String)"bizbooktype"), (Object)pType);
                            continue;
                        }
                        bizBookTypes = BusinessDataServiceHelper.loadFromCache((String)bizBookTypeStr, (String)"id,calorg,booktype,ismainaccount", (QFilter[])new QFilter[]{new QFilter("calorg", "in", (Object)org.getLong("id")), new QFilter("enable", "=", (Object)true)});
                        configRow2 = bizBookTypes.entrySet().iterator();
                        while (configRow2.hasNext()) {
                            Map.Entry bizBookTypeEntry = (Map.Entry)configRow2.next();
                            book = (DynamicObject)bizBookTypeEntry.getValue();
                            if (book.getBoolean("ismainaccount")) {
                                pType = book.getLong("booktype_id");
                            }
                            bizOrg2BizbookType.compute(book.getLong(FCCField.id_((String)"calorg")) + "-" + typeBiz, (k, v) -> {
                                if (v == null) {
                                    v = new HashSet<Long>(1);
                                }
                                v.add(book.getLong("booktype_id"));
                                return v;
                            });
                        }
                        if (pType == null && !CollectionUtils.isEmpty((Collection)(typeList = (Set)bizOrg2BizbookType.get(org.getLong("id") + "-" + typeBiz)))) {
                            pType = (Long)typeList.iterator().next();
                        }
                        pBizOrg = org.getLong("id");
                        flowTaskRow.set("ebizorg", (Object)org);
                        flowTaskRow.set("bizbooktype", (Object)pType);
                        flowTaskRow.set(FCCField.id_((String)"bizbooktype"), (Object)pType);
                        continue;
                    }
                    flowTaskRow.set("ebizorg", pBizOrg);
                    flowTaskRow.set(FCCField.id_((String)"ebizorg"), pBizOrg);
                    flowTaskRow.set("bizbooktype", pType);
                    flowTaskRow.set(FCCField.id_((String)"bizbooktype"), pType);
                    flowRows.add(flowTaskRow);
                    ++tasknum;
                    continue;
                }
                if ("1".equals(taskType)) {
                    flowRows = new ArrayList(16);
                    flowRows.add(flowTaskRow);
                    pTask2allTasks.put(templateTask.getLong("id"), flowRows);
                    pType = null;
                    pBizOrg = null;
                    configCollection = this.getAccountOrgConfig(org.getLong("id"), srcSys, bizApp);
                    key = srcSys + "-" + bizApp;
                    bizOrg2Types = (Map)configMap.get(key);
                    if (bizOrg2Types == null) {
                        bizOrg2Types = new HashMap(8);
                        configMap.put(key, bizOrg2Types);
                    }
                    if (configCollection != null && configCollection.size() > 0) {
                        for (Object configRow2 : configCollection) {
                            bizOrgId = configRow2.getLong("entryentity.bizorg");
                            typeId = configRow2.getLong("entryentity.bizbooktype");
                            if (pBizOrg == null) {
                                pBizOrg = bizOrgId;
                                pType = typeId;
                            }
                            bizOrg2Types.compute(bizOrgId, (k, v) -> {
                                if (v == null) {
                                    v = new HashSet<Long>(2);
                                }
                                v.add(typeId);
                                return v;
                            });
                        }
                        flowTaskRow.set("ebizorg", (Object)pBizOrg);
                        flowTaskRow.set(FCCField.id_((String)"ebizorg"), (Object)pBizOrg);
                        flowTaskRow.set("bizbooktype", (Object)pType);
                        flowTaskRow.set(FCCField.id_((String)"bizbooktype"), (Object)pType);
                        continue;
                    }
                    pBizOrg = org.getLong("id");
                    flowTaskRow.set("ebizorg", (Object)org);
                    continue;
                }
                flowTaskRow.set("ebizorg", pBizOrg);
                flowTaskRow.set(FCCField.id_((String)"ebizorg"), pBizOrg);
                flowRows.add(flowTaskRow);
                ++tasknum;
            }
            for (Map.Entry pTask2AllTaskEntry : pTask2allTasks.entrySet()) {
                List rows = (List)pTask2AllTaskEntry.getValue();
                DynamicObject pRow = (DynamicObject)rows.get(0);
                DynamicObject task = pRow.getDynamicObject("tasknumber");
                long srySys = task.getLong(FCCField.id_((String)"group"));
                long bizApp = task.getLong(FCCField.id_((String)"bizsystem"));
                Map bizOrg2Types = (Map)configMap.get(srySys + "-" + bizApp);
                if (!CollectionUtils.isEmpty((Map)bizOrg2Types)) {
                    for (Map.Entry entry : bizOrg2Types.entrySet()) {
                        Long bizOrgId = (Long)entry.getKey();
                        for (Long typeId : (Set)entry.getValue()) {
                            for (DynamicObject row : rows) {
                                Long rowBizOrgId = row.getLong(FCCField.id_((String)"ebizorg"));
                                Long rowBizBookTypeId = row.getLong(FCCField.id_((String)"bizbooktype"));
                                if (bizOrgId.equals(rowBizOrgId) && typeId.equals(rowBizBookTypeId)) continue;
                                DynamicObject flowTaskRow = taskEntry.addNew();
                                DynamicObject templateTask = row.getDynamicObject("tasknumber");
                                flowTaskRow.set("tasknumber", (Object)templateTask);
                                flowTaskRow.set("eorg", (Object)org);
                                flowTaskRow.set("ebizorg", (Object)bizOrgId);
                                flowTaskRow.set(FCCField.id_((String)"ebizorg"), (Object)bizOrgId);
                                flowTaskRow.set("type", (Object)row.getString("type"));
                                flowTaskRow.set("seq", (Object)seq++);
                                flowTaskRow.set("executor", row.get("executor"));
                                flowTaskRow.set("starttime", (Object)row.getDate("starttime"));
                                flowTaskRow.set("endtime", (Object)row.getDate("endtime"));
                                flowTaskRow.set("startdaytime", row.get("startdaytime"));
                                flowTaskRow.set("enddaytime", row.get("enddaytime"));
                                flowTaskRow.set("taskstatus", (Object)TaskStatusEnum.NOT_START.getType());
                                flowTaskRow.set("isdelay", (Object)DelayStatusEnum.NORMAL.getType());
                                flowTaskRow.set("bizbooktype", (Object)typeId);
                                flowTaskRow.set(FCCField.id_((String)"bizbooktype"), (Object)typeId);
                                if (templateTask.getString("tasktype").equals("1")) continue;
                                ++tasknum;
                            }
                        }
                    }
                    continue;
                }
                for (Map.Entry bizOrg2BizbookTypeEntry : bizOrg2BizbookType.entrySet()) {
                    key = (String)bizOrg2BizbookTypeEntry.getKey();
                    String[] keys = key.split("-");
                    long bizOrgId = Long.parseLong(keys[0]);
                    String bizType = keys[1];
                    Set bizBookTypes = (Set)bizOrg2BizbookTypeEntry.getValue();
                    for (Long bizBookType : bizBookTypes) {
                        for (DynamicObject row : rows) {
                            if (!row.getString("type").equals(bizType) || bizOrgId == row.getLong(FCCField.id_((String)"eorg")) && bizBookType.equals(row.getLong(FCCField.id_((String)"bizbooktype")))) continue;
                            DynamicObject flowTaskRow = taskEntry.addNew();
                            DynamicObject templateTask = row.getDynamicObject("tasknumber");
                            flowTaskRow.set("tasknumber", (Object)templateTask);
                            flowTaskRow.set("eorg", (Object)org);
                            flowTaskRow.set("ebizorg", (Object)bizOrgId);
                            flowTaskRow.set("type", (Object)row.getString("type"));
                            flowTaskRow.set("seq", (Object)seq++);
                            flowTaskRow.set("executor", row.get("executor"));
                            flowTaskRow.set("starttime", (Object)row.getDate("starttime"));
                            flowTaskRow.set("endtime", (Object)row.getDate("endtime"));
                            flowTaskRow.set("startdaytime", row.get("startdaytime"));
                            flowTaskRow.set("enddaytime", row.get("enddaytime"));
                            flowTaskRow.set("taskstatus", (Object)TaskStatusEnum.NOT_START.getType());
                            flowTaskRow.set("isdelay", (Object)DelayStatusEnum.NORMAL.getType());
                            flowTaskRow.set("bizbooktype", (Object)bizBookType);
                            flowTaskRow.set(FCCField.id_((String)"bizbooktype"), (Object)bizBookType);
                            if (templateTask.getString("tasktype").equals("1")) continue;
                            ++tasknum;
                        }
                    }
                }
            }
            flow.set("tasknum", (Object)tasknum);
        }
        SaveServiceHelper.save((DynamicObject[])flowDatas);
        for (DynamicObject flow : flowDatas2 = BusinessDataServiceHelper.load((Object[])flowIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fcc_checkout_flow_detail"))) {
            DynamicObjectCollection taskEntry = flow.getDynamicObjectCollection("taskentry");
            long pid = 0L;
            for (Object dyn : taskEntry) {
                if ("1".equals(dyn.getDynamicObject("tasknumber").getString("tasktype"))) {
                    pid = dyn.getLong("id");
                    continue;
                }
                dyn.set("pid", (Object)pid);
            }
        }
        SaveServiceHelper.save((DynamicObject[])flowDatas2);
        HashMap org2taskIds2row = new HashMap(16);
        HashMap<Long, List> taskId2PerTaskIds = new HashMap<Long, List>(16);
        for (DynamicObject taskRow : templateDyn.getDynamicObjectCollection("taskentry")) {
            long taskId = taskRow.getLong(FCCField.id_((String)"task"));
            for (DynamicObject preTask : taskRow.getDynamicObjectCollection("pretasks")) {
                taskId2PerTaskIds.compute(taskId, (k, v) -> {
                    if (v == null) {
                        v = new ArrayList<Long>(8);
                    }
                    v.add(preTask.getLong("fbasedataid_id"));
                    return v;
                });
            }
        }
        ArrayList<Long> deletePretaskFlowIds = new ArrayList<Long>(16);
        for (DynamicObject flowData : flowDatas2) {
            deletePretaskFlowIds.add(flowData.getLong("id"));
            HashMap<Long, List> taskId2Rows = new HashMap<Long, List>(8);
            org2taskIds2row.put(flowData.getLong(FCCField.id_((String)"org")), taskId2Rows);
            for (DynamicObject taskRow : flowData.getDynamicObjectCollection("taskentry")) {
                taskId2Rows.compute(taskRow.getLong(FCCField.id_((String)"tasknumber")), (k, v) -> {
                    if (v == null) {
                        v = new ArrayList<DynamicObject>(8);
                    }
                    v.add(taskRow);
                    return v;
                });
            }
        }
        ArrayList<DynamicObject> savePreTasks = new ArrayList<DynamicObject>(16);
        for (DynamicObject flowData : flowDatas2) {
            long orgId = flowData.getLong(FCCField.id_((String)"org"));
            Map task2Rows = (Map)org2taskIds2row.get(orgId);
            for (DynamicObject flowTaskRow : flowData.getDynamicObjectCollection("taskentry")) {
                long taskId = flowTaskRow.getLong(FCCField.id_((String)"tasknumber"));
                List preTaskIds = (List)taskId2PerTaskIds.get(taskId);
                if (CollectionUtils.isEmpty((Collection)preTaskIds)) continue;
                DynamicObject preTask = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fcc_checkout_pretasks"));
                preTask.set("flowid", (Object)flowData.getLong("id"));
                preTask.set("taskrowid", (Object)flowTaskRow.getLong("id"));
                DynamicObjectCollection entryentity = preTask.getDynamicObjectCollection("entryentity");
                for (Long preTaskId : preTaskIds) {
                    List rows = (List)task2Rows.get(preTaskId);
                    int seq = 1;
                    for (DynamicObject row : rows) {
                        DynamicObject entryRow = entryentity.addNew();
                        entryRow.set("seq", (Object)seq++);
                        entryRow.set("tasknumber", (Object)preTaskId);
                        entryRow.set("ebizorg", (Object)row.getLong(FCCField.id_((String)"ebizorg")));
                        entryRow.set("type", (Object)row.getString("type"));
                        entryRow.set("bizbooktype", (Object)row.getLong(FCCField.id_((String)"bizbooktype")));
                        entryRow.set("starttime", (Object)row.getDate("starttime"));
                        entryRow.set("endtime", (Object)row.getDate("endtime"));
                        entryRow.set("startdaytime", (Object)row.getDate("startdaytime"));
                        entryRow.set("enddaytime", (Object)row.getDate("enddaytime"));
                        entryRow.set("othertaskid", (Object)row.getLong("id"));
                    }
                }
                savePreTasks.add(preTask);
            }
        }
        DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"fcc_checkout_pretasks"), (Object[])deletePretaskFlowIds.toArray());
        SaveServiceHelper.save((DynamicObject[])savePreTasks.toArray(new DynamicObject[0]));
    }

    private DynamicObjectCollection getAccountOrgConfig(long accountOrgId, Long sourceSys, Long bizApp) {
        QFilter accountOrg = new QFilter("org", "=", (Object)accountOrgId);
        QFilter toType = new QFilter("sourcesys", "=", (Object)sourceSys);
        QFilter fromType = new QFilter("bizapp", "=", (Object)bizApp);
        return QueryServiceHelper.query((String)"fcc_accountorg_config", (String)"sourcesys,bizapp,org,entryentity,entryentity.bizorg,entryentity.type,entryentity.bizbooktype,entryentity.typeother", (QFilter[])new QFilter[]{accountOrg, toType, fromType});
    }

    private Map<Object, DynamicObject> getBizSystem() {
        Map dyns = BusinessDataServiceHelper.loadFromCache((String)"fcc_bizsystem", (QFilter[])new QFilter[]{new QFilter("status", "=", (Object)"C")});
        return dyns;
    }

    private String getKey(DynamicObject taskRw) {
        return taskRw.getLong(FCCField.id_((String)"tasknumber")) + "-" + taskRw.getLong(FCCField.id_((String)"eorg")) + taskRw.getLong(FCCField.id_((String)"bizbooktype"));
    }

    private Date getDate(Date date, int day, int time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        calendar.add(5, day);
        calendar.add(13, time);
        return calendar.getTime();
    }

    private void initPersionMap(List<Long> orgIds) {
        Map orgPersions = BusinessDataServiceHelper.loadFromCache((String)"fcc_checkout_user", (String)"org,fcc_checkout_members,fcc_checkout_members.businesssystem,fcc_checkout_members.member", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
        for (Map.Entry orgPersion : orgPersions.entrySet()) {
            DynamicObject orgPersionDyn = (DynamicObject)orgPersion.getValue();
            HashMap<Long, Long> app2Persion = new HashMap<Long, Long>(16);
            this.orgPersionMap.put(orgPersionDyn.getLong(FCCField.id_((String)"org")), app2Persion);
            for (DynamicObject row : orgPersionDyn.getDynamicObjectCollection("fcc_checkout_members")) {
                app2Persion.put(row.getLong("businesssystem_id"), row.getLong("member_id"));
            }
        }
    }
}

