/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.opplugin.validator;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class CheckOutMemberBatchValidator
extends AbstractValidator {
    private static final String FLOW_DETAIL_ENTITY = "fcc_checkout_flow_detail";

    public void validate() {
        StringBuilder errorMsg = new StringBuilder();
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObject org = dataEntity.getDynamicObject("org");
            long orgId = org.getLong("id");
            Map<Long, Boolean> orgInfoByViewId = this.getOrgInfoByViewId(10L);
            if (!orgInfoByViewId.get(orgId).booleanValue()) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u53f6\u5b50\u8282\u70b9\u7684\u7ec4\u7ec7\u624d\u80fd\u4fdd\u5b58\u3002", (String)"CheckOutMemberBatchValidator_2", (String)"fi-fcc-opplugin", (Object[])new Object[0]), new Object[0]));
            }
            if (errorMsg.length() <= 0) continue;
            this.addMessage(extendedDataEntity, errorMsg.toString(), ErrorLevel.Error);
        }
    }

    private Map<Long, Boolean> getOrgInfoByViewId(Long viewId) {
        DynamicObjectCollection orgDyn = QueryServiceHelper.query((String)"bos_org_structure", (String)"org,isleaf,org.enable", (QFilter[])new QFilter("view", "=", (Object)viewId).toArray());
        HashMap<Long, Boolean> orgInfos = new HashMap<Long, Boolean>(orgDyn.size());
        orgDyn.forEach(dyo -> {
            String enable = dyo.getString("org.enable");
            if ("1".equals(enable)) {
                Long orgId = dyo.getLong("org");
                Boolean isLeaf = dyo.getBoolean("isleaf");
                orgInfos.put(orgId, isLeaf);
            }
        });
        return orgInfos;
    }
}

