/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.opplugin.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.fi.fcc.common.enums.CheckoutCycleEnum;
import kd.fi.fcc.common.enums.TaskTypeEnum;
import kd.fi.fcc.common.utils.HasCycleUtils;

public class CheckOutTemplateSaveValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            StringBuilder errorMsg = new StringBuilder();
            this.checkRepeatTask(dataEntity, errorMsg);
            Map<Long, List<Long>> taskMap = this.checkPreTask(dataEntity, errorMsg);
            if (StringUtils.isBlank((CharSequence)errorMsg)) {
                this.checkIsHasCycle(dataEntity, taskMap, errorMsg);
            }
            if (errorMsg.length() <= 0) continue;
            this.addMessage(dataEntity, errorMsg.toString(), ErrorLevel.Error);
        }
    }

    private void checkRepeatTask(ExtendedDataEntity dataEntity, StringBuilder errorMsg) {
        ArrayList<Long> taskIdList = new ArrayList<Long>();
        DynamicObjectCollection taskEntries = (DynamicObjectCollection)dataEntity.getValue("taskentry");
        if (null == taskEntries || taskEntries.size() == 0) {
            return;
        }
        for (DynamicObject taskEntry : taskEntries) {
            DynamicObject task = (DynamicObject)taskEntry.get("task");
            if (null == task) continue;
            String taskName = task.getString("name");
            Long pid = taskEntry.getLong("pid");
            Long taskId = task.getLong("id");
            String taskType = task.getString("tasktype");
            if (taskIdList.contains(taskId)) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u7ed3\u8d26\u4efb\u52a1\u201d%s\u201c\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u3002\n", (String)"CheckOutTemplateSaveValidator_11", (String)"fi-fcc-opplugin", (Object[])new Object[0]), taskName));
            }
            if (pid == 0L && !StringUtils.equals((CharSequence)TaskTypeEnum.TASK_SET.getType(), (CharSequence)taskType)) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u7ed3\u8d26\u4efb\u52a1\u201d%s\u201c\u7684\u4efb\u52a1\u96c6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u3002\n", (String)"CheckOutTemplateSaveValidator_12", (String)"fi-fcc-opplugin", (Object[])new Object[0]), taskName));
            }
            taskIdList.add(taskId);
        }
    }

    private Map<Long, List<Long>> checkPreTask(ExtendedDataEntity dataEntity, StringBuilder errorMsg) {
        DynamicObject task;
        String checkoutType = (String)dataEntity.getValue("checkouttype");
        DynamicObjectCollection taskEntries = (DynamicObjectCollection)dataEntity.getValue("taskentry");
        HashMap<Long, DynamicObject> taskDetailsMap = new HashMap<Long, DynamicObject>(2);
        HashMap<Long, List<Long>> taskMap = new HashMap<Long, List<Long>>();
        if (null == taskEntries || taskEntries.size() == 0) {
            return null;
        }
        for (DynamicObject taskEntry : taskEntries) {
            task = (DynamicObject)taskEntry.get("task");
            if (null == task) continue;
            Long taskId = task.getLong("id");
            taskDetailsMap.put(taskId, taskEntry);
        }
        for (int i = 0; i < taskEntries.size(); ++i) {
            DynamicObject taskEntry;
            taskEntry = (DynamicObject)taskEntries.get(i);
            task = (DynamicObject)taskEntry.get("task");
            if (null == task) continue;
            String taskType = task.getString("tasktype");
            Long taskId = task.getLong("id");
            String taskName = task.getString("name");
            if (taskType.equals(TaskTypeEnum.TASK_SET.getType())) continue;
            Integer startDate = (Integer)taskEntry.get("startdate");
            Object startTime = taskEntry.get("starttime");
            Integer endDate = (Integer)taskEntry.get("enddate");
            Object endTime = taskEntry.get("endtime");
            if (null == startDate) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u660e\u7ec6\u7b2c%s\u884c\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u4e0d\u53ef\u4e3a\u7a7a\u3002\n", (String)"CheckOutTemplateSaveValidator_13", (String)"fi-fcc-opplugin", (Object[])new Object[]{i + 1}), new Object[0]));
            }
            if (startTime instanceof Integer && (Integer)startTime == -1) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u660e\u7ec6\u7b2c%s\u884c\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u4e0d\u53ef\u4e3a\u7a7a\u3002\n", (String)"CheckOutTemplateSaveValidator_14", (String)"fi-fcc-opplugin", (Object[])new Object[]{i + 1}), new Object[0]));
            }
            if (null == endDate) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u660e\u7ec6\u7b2c%s\u884c\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u4e0d\u53ef\u4e3a\u7a7a\u3002\n", (String)"CheckOutTemplateSaveValidator_15", (String)"fi-fcc-opplugin", (Object[])new Object[]{i + 1}), new Object[0]));
            }
            if (endTime instanceof Integer && (Integer)endTime == -1) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u660e\u7ec6\u7b2c%s\u884c\u8ba1\u5212\u7ed3\u675f\u65f6\u95f4\u4e0d\u53ef\u4e3a\u7a7a\u3002\n", (String)"CheckOutTemplateSaveValidator_16", (String)"fi-fcc-opplugin", (Object[])new Object[]{i + 1}), new Object[0]));
            }
            MulBasedataDynamicObjectCollection preTasks = (MulBasedataDynamicObjectCollection)taskEntry.get("pretasks");
            if (StringUtils.equals((CharSequence)checkoutType, (CharSequence)CheckoutCycleEnum.DAY_END.getValue())) {
                startDate = 0;
                endDate = 0;
            }
            Long dayMillis = 86400000L;
            startDate = null != startDate ? startDate : 0;
            Long startTimeMillis = dayMillis * (long)startDate.intValue();
            if (startTime instanceof Integer && (Integer)startTime != -1) {
                Integer startTimeInt = (Integer)startTime;
                startTimeMillis = startTimeMillis + (long)startTimeInt.intValue() * 1000L;
            }
            endDate = null != endDate ? endDate : 0;
            Long endTimeMillis = dayMillis * (long)endDate.intValue();
            if (endTime instanceof Integer && (Integer)endTime != -1) {
                Integer endTimeInt = (Integer)endTime;
                endTimeMillis = endTimeMillis + (long)endTimeInt.intValue() * 1000L;
            }
            if (startDate > endDate) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u7ed3\u8d26\u4efb\u52a1\u201c%s\u201d\u7684\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u5e94\u65e9\u4e8e\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u3002\n", (String)"CheckOutTemplateSaveValidator_17", (String)"fi-fcc-opplugin", (Object[])new Object[]{taskName}), new Object[0]));
            } else if (startTimeMillis > endTimeMillis) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u7ed3\u8d26\u4efb\u52a1\u201c%s\u201d\u7684\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u5e94\u65e9\u4e8e\u8ba1\u5212\u7ed3\u675f\u65f6\u95f4\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u3002\n", (String)"CheckOutTemplateSaveValidator_18", (String)"fi-fcc-opplugin", (Object[])new Object[]{taskName}), new Object[0]));
            }
            Long latestTimeMillis = 0L;
            Long latestPreTaskId = null;
            ArrayList<Long> preIdList = new ArrayList<Long>(2);
            if (null == preTasks || preTasks.size() == 0) continue;
            for (DynamicObject preTask : preTasks) {
                Long preTaskId = preTask.getLong("fbasedataid.id");
                DynamicObject preTaskEntry = (DynamicObject)taskDetailsMap.get(preTaskId);
                if (null == preTaskEntry) continue;
                Integer preEndDate = (Integer)preTaskEntry.get("enddate") != null ? (Integer)preTaskEntry.get("enddate") : 0;
                Object preEndTime = preTaskEntry.get("endtime") != null ? preTaskEntry.get("endtime") : Integer.valueOf(0);
                Long preEndTimeMillis = dayMillis * (long)preEndDate.intValue();
                if (preEndTime instanceof Integer && (Integer)preEndTime != -1) {
                    Integer preEndTimeInt = (Integer)preEndTime;
                    preEndTimeMillis = preEndTimeMillis + (long)preEndTimeInt.intValue() * 1000L;
                }
                if (preEndTimeMillis >= latestTimeMillis) {
                    latestTimeMillis = preEndTimeMillis;
                    latestPreTaskId = preTaskId;
                }
                preIdList.add(preTaskId);
            }
            if (startTimeMillis < latestTimeMillis) {
                DynamicObject preTask;
                DynamicObject preTaskEntry = (DynamicObject)taskDetailsMap.get(latestPreTaskId);
                preTask = (DynamicObject)preTaskEntry.get("task");
                String preTaskName = preTask.getString("name");
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u7ed3\u8d26\u4efb\u52a1\u201c%1$s\u201d\u7684\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u5e94\u4e0d\u65e9\u4e8e\u524d\u7f6e\u4efb\u52a1\u201c%2$s\u201d\u7684\u8ba1\u5212\u7ed3\u675f\u65f6\u95f4\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u3002\n", (String)"CheckOutTemplateSaveValidator_19", (String)"fi-fcc-opplugin", (Object[])new Object[0]), taskName, preTaskName));
            }
            taskMap.put(taskId, preIdList);
        }
        return taskMap;
    }

    private void checkIsHasCycle(ExtendedDataEntity dataEntity, Map<Long, List<Long>> taskMap, StringBuilder errorMsg) {
        if (null == taskMap) {
            return;
        }
        DynamicObjectCollection taskEntries = (DynamicObjectCollection)dataEntity.getValue("taskentry");
        for (DynamicObject taskEntry : taskEntries) {
            DynamicObject task = (DynamicObject)taskEntry.get("task");
            if (null == task) continue;
            Long taskId = task.getLong("id");
            String taskName = task.getString("name");
            Boolean hasCycle = HasCycleUtils.hasCycle((Long)taskId, taskMap);
            if (!hasCycle.booleanValue()) continue;
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u7ed3\u8d26\u4efb\u52a1\u201c%s\u201d\u4e0e\u524d\u7f6e\u4efb\u52a1\u5b58\u5728\u5faa\u73af\u4f9d\u8d56\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u3002\n", (String)"CheckOutTemplateSaveValidator_20", (String)"fi-fcc-opplugin", (Object[])new Object[0]), taskName));
        }
    }
}

