/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.opplugin.validator;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fcc.common.constant.FCCField;
import kd.fi.fcc.common.enums.CheckoutCycleEnum;
import kd.fi.fcc.common.utils.HasCycleUtils;

public class CheckoutFlowDetailSaveValidator
extends AbstractValidator {
    private static final String FCC_CHECKOUT_FLOW_DETAIL = "fcc_checkout_flow_detail";
    private static final String FCC_CHECKOUT_TASK = "fcc_checkout_task";
    private static final String FCC_CHECKOUT_PRETASKS = "fcc_checkout_pretasks";
    private static final String FCC_BIZSYSTEM = "fcc_bizsystem";
    private static final String BOS_ORG_STRUCTURE = "bos_org_structure";
    private static final String TASK_NUMBER = "tasknumber";
    private static final String EORG = "eorg";
    private static final String EBIZORG = "ebizorg";
    private static final String BIZBOOKTYPE = "bizbooktype";
    private static final String BIZ_SYS = "bizsystem";
    private static final String EXECUTOR = "executor";
    private static final String START_DATE = "starttime";
    private static final String END_DATE = "endtime";
    private static final String START_DAYTIME = "startdaytime";
    private static final String END_DAYTIME = "enddaytime";
    private static final String PRE_TASKS = "pretasks";
    private static final String TYPE = "type";

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            long pid;
            long id;
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            DynamicObjectCollection taskentry = dynamicObject.getDynamicObjectCollection("taskentry");
            if (taskentry.isEmpty()) continue;
            String method = dynamicObject.getDynamicObject("plan").getString("method");
            HashMap<Long, Comparable<Date>> endDateMap = new HashMap<Long, Comparable<Date>>(taskentry.size());
            HashMap<Long, DynamicObject> taskIdMap = new HashMap<Long, DynamicObject>(taskentry.size());
            HashMap serviceMap = new HashMap(taskentry.size());
            for (DynamicObject task2 : taskentry) {
                long pid2 = task2.getLong("pid");
                if (pid2 == 0L) continue;
                id = task2.getLong("id");
                if (CheckoutCycleEnum.MONTH_END.getValue().equals(method)) {
                    endDateMap.put(id, task2.getDate(END_DATE));
                } else {
                    endDateMap.put(id, Integer.valueOf(task2.getInt(END_DAYTIME)));
                }
                taskIdMap.put(id, task2);
            }
            Map<Long, List<DynamicObject>> groupPidMap = taskentry.stream().collect(Collectors.groupingBy(task -> task.getLong("pid")));
            for (DynamicObject task3 : taskentry) {
                String format;
                List<DynamicObject> subTasks;
                id = task3.getLong("id");
                if (!this.validateRequired(dataEntity, task3)) {
                    return;
                }
                pid = task3.getLong("pid");
                if (pid == 0L && ((subTasks = groupPidMap.get(task3.getLong("id"))) == null || subTasks.size() == 0)) {
                    String format2 = String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u96c6\u201c%1$s\u201d\u6ca1\u6709\u5b50\u4efb\u52a1\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u3002", (String)"CheckoutFlowDetailSaveValidator_7", (String)"fi-fcc-opplugin", (Object[])new Object[0]), task3.getDynamicObject(TASK_NUMBER).getString("name"));
                    this.addErrorMessage(dataEntity, format2);
                }
                if (CheckoutCycleEnum.MONTH_END.getValue().equals(method)) {
                    Date starttime = task3.getDate(START_DATE);
                    Date endtime = task3.getDate(END_DATE);
                    if (task3.getLong("pid") != 0L) {
                        if (starttime == null) {
                            format = String.format(ResManager.loadKDString((String)"\u7ed3\u8d26\u4efb\u52a1\u201c%1$s\u201d\u7684\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"CheckoutFlowDetailSaveValidator_5", (String)"fi-fcc-opplugin", (Object[])new Object[0]), task3.getDynamicObject(TASK_NUMBER).getString("name"));
                            this.addErrorMessage(dataEntity, format);
                            continue;
                        }
                        if (endtime == null) {
                            format = String.format(ResManager.loadKDString((String)"\u7ed3\u8d26\u4efb\u52a1\u201c%1$s\u201d\u7684\u8ba1\u5212\u7ed3\u675f\u65f6\u95f4\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"CheckoutFlowDetailSaveValidator_6", (String)"fi-fcc-opplugin", (Object[])new Object[0]), task3.getDynamicObject(TASK_NUMBER).getString("name"));
                            this.addErrorMessage(dataEntity, format);
                            continue;
                        }
                    }
                    this.validateTime(dataEntity, starttime, endtime, pid, task3);
                } else {
                    int starttime = task3.getInt(START_DAYTIME);
                    int endtime = task3.getInt(END_DAYTIME);
                    if (task3.getLong("pid") != 0L) {
                        if (starttime < 0) {
                            format = String.format(ResManager.loadKDString((String)"\u7ed3\u8d26\u4efb\u52a1\u201c%1$s\u201d\u7684\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"CheckoutFlowDetailSaveValidator_5", (String)"fi-fcc-opplugin", (Object[])new Object[0]), task3.getDynamicObject(TASK_NUMBER).getString("name"));
                            this.addErrorMessage(dataEntity, format);
                            continue;
                        }
                        if (endtime < 0) {
                            format = String.format(ResManager.loadKDString((String)"\u7ed3\u8d26\u4efb\u52a1\u201c%1$s\u201d\u7684\u8ba1\u5212\u7ed3\u675f\u65f6\u95f4\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"CheckoutFlowDetailSaveValidator_6", (String)"fi-fcc-opplugin", (Object[])new Object[0]), task3.getDynamicObject(TASK_NUMBER).getString("name"));
                            this.addErrorMessage(dataEntity, format);
                            continue;
                        }
                    }
                    this.validateSecond(dataEntity, starttime, endtime, pid, task3);
                }
                QFilter qFilter = new QFilter("flowid", "=", dynamicObject.getPkValue());
                qFilter.and("taskrowid", "=", task3.getPkValue());
                DynamicObject[] load = BusinessDataServiceHelper.load((String)FCC_CHECKOUT_PRETASKS, (String)"flowid,taskrowid,entryentity.tasknumber,entryentity.othertaskid", (QFilter[])new QFilter[]{qFilter});
                if (load.length <= 0) continue;
                ArrayList<Long> preTaskIds = new ArrayList<Long>(load.length);
                DynamicObject preTask = load[0];
                DynamicObjectCollection pretasks = preTask.getDynamicObjectCollection("entryentity");
                if (pretasks == null || pretasks.size() == 0) continue;
                Iterator iterator = pretasks.iterator();
                while (iterator.hasNext()) {
                    DynamicObject preTaskEntry = (DynamicObject)iterator.next();
                    long preTaskId = preTaskEntry.getLong("othertaskid");
                    Object o = taskIdMap.get(preTaskId);
                    if (o == null) {
                        iterator.remove();
                        continue;
                    }
                    String name = preTaskEntry.getDynamicObject(TASK_NUMBER).getString("name");
                    if (CheckoutCycleEnum.MONTH_END.getValue().equals(method)) {
                        Date starttime = task3.getDate(START_DATE);
                        Date preTaskEndDate = (Date)endDateMap.get(preTaskId);
                        if (starttime.getTime() < preTaskEndDate.getTime()) {
                            this.validatePreTaskEndTime(dataEntity, task3, name);
                        }
                    } else {
                        int preTaskEndDate;
                        int starttime = task3.getInt(START_DAYTIME);
                        if (starttime < (preTaskEndDate = ((Integer)endDateMap.get(preTaskId)).intValue())) {
                            this.validatePreTaskEndTime(dataEntity, task3, name);
                        }
                    }
                    preTaskIds.add(preTaskId);
                }
                if (preTaskIds.size() > 0) {
                    serviceMap.put(id, preTaskIds);
                }
                SaveServiceHelper.save((DynamicObject[])load);
            }
            if (serviceMap.size() > 0) {
                for (DynamicObject task3 : taskentry) {
                    id = task3.getLong("id");
                    pid = task3.getLong("pid");
                    if (pid == 0L || !HasCycleUtils.hasCycle((Long)id, serviceMap).booleanValue()) continue;
                    String format = String.format(ResManager.loadKDString((String)"\u7ed3\u8d26\u4efb\u52a1\u201c%1$s\u201d\u4efb\u52a1\u5b58\u5728\u5faa\u73af\u4f9d\u8d56\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u3002", (String)"CheckoutFlowDetailSaveValidator_4", (String)"fi-fcc-opplugin", (Object[])new Object[0]), task3.getDynamicObject(TASK_NUMBER).getString("name"));
                    this.addErrorMessage(dataEntity, format);
                }
            }
            HashMap<String, Long> map = new HashMap<String, Long>();
            for (DynamicObject task4 : taskentry) {
                String key;
                long taskId = task4.getLong(FCCField.id_((String)TASK_NUMBER));
                long eOrgId = task4.getLong(FCCField.id_((String)EBIZORG));
                String type = task4.getString(TYPE);
                DynamicObject bizBookType = task4.getDynamicObject(BIZBOOKTYPE);
                if (StringUtils.isEmpty((String)type)) {
                    type = " ";
                }
                long bizBookTypeId = 0L;
                if (bizBookType != null) {
                    bizBookTypeId = bizBookType.getLong("id");
                }
                if (map.containsKey(key = taskId + "-" + eOrgId + "-" + bizBookTypeId + "-" + type)) {
                    map.put(key, (Long)map.get(key) + 1L);
                    continue;
                }
                map.put(key, 1L);
            }
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                Long value = (Long)entry.getValue();
                if (value <= 1L) continue;
                String[] split = key.split("-");
                DynamicObject task5 = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(split[0]), (String)FCC_CHECKOUT_TASK);
                DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(split[1]), (String)"bos_org");
                String type = split[3];
                String bizTypeId = split[2];
                String bizTypeName = "";
                if (StringUtils.isNotEmpty((String)type) && StringUtils.isNotEmpty((String)bizTypeId) && Long.parseLong(bizTypeId) != 0L) {
                    DynamicObject bizType = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(bizTypeId), (String)type);
                    bizTypeName = bizType.getString("name");
                }
                String format = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7\u201c%1$s\u201d\u7c7b\u578b\u201c%2$s\u201d\u7684\u201c%3$s\u201d\u4efb\u52a1\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u3002", (String)"CheckoutFlowDetailSaveValidator_1", (String)"fi-fcc-opplugin", (Object[])new Object[0]), org.getString("name"), bizTypeName, task5.getString("name"));
                this.addMessage(dataEntity, format);
            }
        }
    }

    private boolean validateRequired(ExtendedDataEntity dataEntity, DynamicObject task) {
        boolean b = true;
        DynamicObject taskNumber = task.getDynamicObject(TASK_NUMBER);
        DynamicObject eorg = task.getDynamicObject(EORG);
        DynamicObject eBizOrg = task.getDynamicObject(EBIZORG);
        DynamicObject executor = task.getDynamicObject(EXECUTOR);
        if (taskNumber == null) {
            b = false;
        }
        if (eorg == null) {
            b = false;
        }
        if (eBizOrg == null) {
            b = false;
        }
        if (executor == null) {
            b = false;
        }
        return b;
    }

    public void checkCycle(List<DynamicObject> taskEntry, long pid, long id, DynamicObject curDyna, Set<Long> dependTaskIds) {
        if (dependTaskIds.size() > 0) {
            return;
        }
        DynamicObjectCollection preTasks = curDyna.getDynamicObjectCollection(PRE_TASKS);
        List selectedTaskIds = preTasks.stream().map(dynamic -> dynamic.getLong("fbasedataid_id")).collect(Collectors.toList());
        if (selectedTaskIds.isEmpty()) {
            return;
        }
        for (DynamicObject dynamicObject : taskEntry) {
            DynamicObjectCollection dynamicObjectCollection;
            if (dynamicObject.getLong("pid") != pid) continue;
            long currId = dynamicObject.getLong("id");
            if (!selectedTaskIds.contains(dynamicObject.getLong("id")) || (dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(PRE_TASKS)).size() <= 0) continue;
            List selectedPreTaskIds = dynamicObjectCollection.stream().map(dynamic -> dynamic.getLong("fbasedataid_id")).collect(Collectors.toList());
            if (selectedPreTaskIds.contains(id)) {
                dependTaskIds.add(currId);
                return;
            }
            this.checkCycle(taskEntry, pid, id, dynamicObject, dependTaskIds);
        }
    }

    private void getSubDependTask(Set<Long> dependTaskIds, Set<Long> currId, List<DynamicObject> taskEntry, long pid) {
        for (DynamicObject dynamicObject : taskEntry) {
            DynamicObjectCollection preTasksCollection;
            if (dynamicObject.getLong("pid") != pid || dependTaskIds.contains(dynamicObject.getLong(FCCField.id_((String)TASK_NUMBER))) || (preTasksCollection = dynamicObject.getDynamicObjectCollection(PRE_TASKS)).isEmpty()) continue;
            List selectedTaskIds = preTasksCollection.stream().map(dynamic -> dynamic.getLong("fbasedataid_id")).collect(Collectors.toList());
            boolean b = selectedTaskIds.stream().anyMatch(currId::contains);
            if (!b) continue;
            long id = dynamicObject.getLong(FCCField.id_((String)TASK_NUMBER));
            HashSet<Long> set = new HashSet<Long>(1);
            set.add(id);
            this.getSubDependTask(dependTaskIds, set, taskEntry, pid);
            dependTaskIds.add(id);
        }
    }

    private void validatePreTaskEndTime(ExtendedDataEntity dataEntity, DynamicObject task, String name) {
        String format = String.format(ResManager.loadKDString((String)"\u7ed3\u8d26\u4efb\u52a1\u201c%1$s\u201d\u7684\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u5e94\u4e0d\u65e9\u4e8e\u524d\u7f6e\u4efb\u52a1\u201c%2$s\u201d\u7684\u8ba1\u5212\u7ed3\u675f\u65f6\u95f4\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u3002", (String)"CheckoutFlowDetailSaveValidator_3", (String)"fi-fcc-opplugin", (Object[])new Object[0]), task.getDynamicObject(TASK_NUMBER).getString("name"), name);
        this.addErrorMessage(dataEntity, format);
    }

    private void validateSecond(ExtendedDataEntity dataEntity, int starttime, int endtime, long pid, DynamicObject task) {
        if (pid == 0L) {
            return;
        }
        if (starttime > endtime) {
            String format = String.format(ResManager.loadKDString((String)"\u7ed3\u8d26\u4efb\u52a1\u201c%1$s\u201d\u7684\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u5e94\u65e9\u4e8e\u8ba1\u5212\u7ed3\u675f\u65f6\u95f4\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u3002", (String)"CheckoutFlowDetailSaveValidator_2", (String)"fi-fcc-opplugin", (Object[])new Object[0]), task.getDynamicObject(TASK_NUMBER).getString("name"));
            this.addErrorMessage(dataEntity, format);
        }
    }

    public void validateTime(ExtendedDataEntity dataEntity, Date startTime, Date endTime, long pid, DynamicObject task) {
        if (pid == 0L) {
            return;
        }
        if (startTime.getTime() > endTime.getTime()) {
            String format = String.format(ResManager.loadKDString((String)"\u7ed3\u8d26\u4efb\u52a1\u201c%1$s\u201d\u7684\u8ba1\u5212\u7ed3\u675f\u65f6\u95f4\u5e94\u4e0d\u65e9\u4e8e\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u3002", (String)"CheckoutFlowDetailSaveValidator_8", (String)"fi-fcc-opplugin", (Object[])new Object[0]), task.getDynamicObject(TASK_NUMBER).getString("name"));
            this.addErrorMessage(dataEntity, format);
        }
    }
}

