/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.opplugin.validator;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.ext.fi.util.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fcc.common.enums.CheckoutCycleEnum;
import kd.fi.fcc.common.enums.CheckoutPlanStatusEnum;
import kd.fi.fcc.common.utils.CheckOutViewUtil;

public class CheckoutPlanCloseValidator
extends AbstractValidator {
    private static final String FCC_CHECKOUT_PLAN = "fcc_checkout_plan";
    private static final String FCC_CHECKOUT_FLOW_DETAIL = "fcc_checkout_flow_detail";
    private static final String FCC_CHECKOUT_FLOW = "fcc_checkout_flow";

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.dataEntities) {
            DynamicObject plan = dataEntity.getDataEntity();
            if (!plan.getString("planstatus").equals(CheckoutPlanStatusEnum.RELEASE.getType())) {
                String format = ResManager.loadKDString((String)"\u7ed3\u8d26\u8ba1\u5212\u72b6\u6001\u662f\u201c\u5df2\u53d1\u5e03\u201d\u624d\u80fd\u5173\u95ed\u3002", (String)"CheckoutPlanCloseValidator_3", (String)"fi-fcc-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, format);
                continue;
            }
            QFilter qFilter = new QFilter("plan", "=", plan.getPkValue());
            qFilter.and("taskentry.taskstatus", "!=", (Object)"c");
            String method = plan.getString("method");
            long viewId = CheckOutViewUtil.getView((Long)plan.getLong("id"));
            Map orgByView = CheckOutViewUtil.getEnableLeafOrgByView((long)viewId);
            if (orgByView != null && orgByView.size() > 0) {
                List viewOrgIds = orgByView.values().stream().map(dynamicObject -> dynamicObject.getLong("org.id")).collect(Collectors.toList());
                qFilter.and("org", "in", viewOrgIds);
            }
            if (CheckoutCycleEnum.MONTH_END.getValue().equals(method)) {
                qFilter.and("flowdate", "=", (Object)plan.getDate("month"));
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)FCC_CHECKOUT_FLOW_DETAIL, (String)"org,flowstatus", (QFilter[])new QFilter[]{qFilter});
                if (dynamicObjects.length <= 0) continue;
                for (DynamicObject dynamicObject2 : dynamicObjects) {
                    String format = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u6709\u672a\u5b8c\u6210\u7684\u4efb\u52a1\uff0c\u8bf7\u5230\u7ed3\u8d26\u5de5\u4f5c\u53f0\u5b8c\u6210\u7ed3\u8d26\u4efb\u52a1\u3002", (String)"CheckoutPlanCloseValidator_1", (String)"fi-fcc-opplugin", (Object[])new Object[0]), dynamicObject2.getDynamicObject("org").getString("name"));
                    this.addErrorMessage(dataEntity, format);
                }
                continue;
            }
            Date enddate = plan.getDate("enddate");
            if (!DateUtils.getCurrentDate().before(enddate)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6ca1\u6709\u5230\u8fbe\u65e5\u7ed3\u8ba1\u5212\u7684\u201c\u7ed3\u675f\u65e5\u671f\u201d\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed\u7ed3\u8d26\u8ba1\u5212\u3002", (String)"CheckoutPlanCloseValidator_2", (String)"fi-fcc-opplugin", (Object[])new Object[0]));
        }
    }
}

