/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.opplugin.validator;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fcc.common.enums.CheckoutCycleEnum;
import kd.fi.fcc.common.utils.CheckOutViewUtil;
import kd.fi.fcc.common.utils.FccUtil;

public class CheckoutPlanReleaseValidator
extends AbstractValidator {
    private static final String FCC_CHECKOUT_FLOW_DETAIL = "fcc_checkout_flow_detail";

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        String operateKey = this.getOperateKey();
        for (ExtendedDataEntity dataEntity : dataEntities = this.dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            if (!"release".equals(operateKey) || !this.getUnconfirmedNum(dynamicObject)) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6240\u6709\u6838\u7b97\u7ec4\u7ec7\u662f\u201c\u5df2\u786e\u8ba4\u201d\u72b6\u6001\uff0c\u624d\u53ef\u4ee5\u53d1\u5e03\u7ed3\u8d26\u8ba1\u5212\u3002", (String)"CheckoutPlanReleaseValidator_0", (String)"fi-fcc-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }

    private boolean getUnconfirmedNum(DynamicObject plan) {
        QFilter qFilter = new QFilter("plan", "=", plan.getPkValue());
        if (CheckoutCycleEnum.MONTH_END.getValue().equals(plan.getString("method"))) {
            qFilter.and("flowdate", "=", (Object)plan.getDate("month"));
        } else {
            Date latestFlowDate = FccUtil.getLatestFlowDate((Long)plan.getLong("id"));
            if (latestFlowDate != null) {
                qFilter.and("flowdate", "=", (Object)latestFlowDate);
            }
        }
        qFilter.and("flowstatus", "=", (Object)"1");
        long viewId = CheckOutViewUtil.getView((Long)plan.getLong("id"));
        Map orgByView = CheckOutViewUtil.getEnableLeafOrgByView((long)viewId);
        if (orgByView != null && orgByView.size() > 0) {
            List viewOrgIds = orgByView.values().stream().map(dynamicObject -> dynamicObject.getLong("org.id")).collect(Collectors.toList());
            qFilter.and("org", "in", viewOrgIds);
        }
        boolean exists = QueryServiceHelper.exists((String)FCC_CHECKOUT_FLOW_DETAIL, (QFilter[])new QFilter[]{qFilter});
        return exists;
    }
}

