/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.opplugin.validator;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fcc.common.enums.CheckoutCycleEnum;

public class CheckoutPlanSaveValidator
extends AbstractValidator {
    private static final String FCC_CHECKOUT_PLAN = "fcc_checkout_plan";

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities.length > 1) {
            this.uniqueValidate();
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String method = (String)dataEntity.getValue("method");
            if (CheckoutCycleEnum.MONTH_END.getValue().equals(method)) {
                Object month = dataEntity.getValue("month");
                QFilter qFilter = new QFilter("month", "=", month);
                qFilter.and("planstatus", "!=", (Object)"C");
                qFilter.and("method", "=", (Object)CheckoutCycleEnum.MONTH_END.getValue());
                qFilter.and("number", "!=", (Object)dataEntity.getBillNo());
                boolean exists = QueryServiceHelper.exists((String)FCC_CHECKOUT_PLAN, (QFilter[])new QFilter[]{qFilter});
                if (!exists) continue;
                SimpleDateFormat dateFormat = new SimpleDateFormat(ResManager.loadKDString((String)"yyyy\u5e74MM\u6708", (String)"CheckoutPlanSaveValidator_3", (String)"fi-fcc-opplugin", (Object[])new Object[0]));
                String format = dateFormat.format(month);
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u5df2\u5b58\u5728\u7ed3\u8d26\u8ba1\u5212\u3002", (String)"CheckoutPlanSaveValidator_1", (String)"fi-fcc-opplugin", (Object[])new Object[0]), format), ErrorLevel.Error);
                continue;
            }
            if (!CheckoutCycleEnum.DAY_END.getValue().equals(method)) continue;
            Object startdate = dataEntity.getValue("startdate");
            Object enddate = dataEntity.getValue("enddate");
            QFilter qFilter1 = new QFilter("startdate", "<=", startdate);
            qFilter1.and("enddate", ">=", startdate);
            QFilter qFilter2 = new QFilter("startdate", "<=", enddate);
            qFilter2.and("enddate", ">=", enddate);
            QFilter qFilter3 = new QFilter("startdate", ">=", startdate);
            qFilter3.and("enddate", "<=", enddate);
            QFilter qFilter4 = new QFilter("method", "=", (Object)CheckoutCycleEnum.DAY_END.getValue());
            qFilter4.and("number", "!=", (Object)dataEntity.getBillNo());
            qFilter4.and("planstatus", "!=", (Object)"C");
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)FCC_CHECKOUT_PLAN, (String)"number,name", (QFilter[])new QFilter[]{qFilter4.and(qFilter1.or(qFilter2).or(qFilter3))});
            if (dynamicObject == null) continue;
            String format = dynamicObject.getString("number") + "-" + dynamicObject.getString("name");
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4\u4e0e\u7ed3\u8d26\u8ba1\u5212\u201c%1$s\u201d\u65e5\u671f\u91cd\u53e0\uff0c\u8bf7\u8c03\u6574\u65e5\u671f\u8303\u56f4\u3002", (String)"CheckoutPlanSaveValidator_4", (String)"fi-fcc-opplugin", (Object[])new Object[0]), format), ErrorLevel.Error);
        }
    }

    public String dateFormat(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        return df.format(date);
    }

    public void uniqueValidate() {
        String format;
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>();
        HashMap<String, ExtendedDataEntity> monthMap = new HashMap<String, ExtendedDataEntity>();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String method = (String)dataEntity.getValue("method");
            if (CheckoutCycleEnum.MONTH_END.getValue().equals(method)) {
                String month = (String)dataEntity.getValue("month");
                if (monthMap.containsKey(month)) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(ResManager.loadKDString((String)"yyyy\u5e74MM\u6708", (String)"CheckoutPlanSaveValidator_3", (String)"fi-fcc-opplugin", (Object[])new Object[0]));
                    format = dateFormat.format(month);
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u5df2\u5b58\u5728\u7ed3\u8d26\u8ba1\u5212\u3002", (String)"CheckoutPlanSaveValidator_1", (String)"fi-fcc-opplugin", (Object[])new Object[0]), format), ErrorLevel.Error);
                    continue;
                }
                monthMap.put(month, dataEntity);
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        if (dataEntityList.size() > 1) {
            List collect = dataEntityList.stream().sorted(new Comparator<ExtendedDataEntity>(){

                @Override
                public int compare(ExtendedDataEntity o1, ExtendedDataEntity o2) {
                    Date startdate1 = o1.getDataEntity().getDate("startdate");
                    Date startdate2 = o2.getDataEntity().getDate("startdate");
                    return (int)(startdate2.getTime() - startdate1.getTime()) / 86400000;
                }
            }).collect(Collectors.toList());
            for (int i = 1; i <= collect.size(); ++i) {
                Date previousEndDate;
                ExtendedDataEntity current = (ExtendedDataEntity)collect.get(i);
                ExtendedDataEntity previous = (ExtendedDataEntity)collect.get(i - 1);
                Date currentStartDate = (Date)current.getValue("startdate");
                if (!currentStartDate.before(previousEndDate = (Date)previous.getValue("enddate"))) continue;
                DynamicObject dynamicObject = previous.getDataEntity();
                format = dynamicObject.getString("number") + "-" + dynamicObject.getString("name");
                this.addMessage(current, String.format(ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4\u4e0e\u7684%1$s\u65e5\u671f\u91cd\u53e0\uff0c\u8bf7\u8c03\u6574\u65e5\u671f\u8303\u56f4\u3002", (String)"CheckoutPlanSaveValidator_2", (String)"fi-fcc-opplugin", (Object[])new Object[0]), format), ErrorLevel.Error);
            }
        }
    }
}

