/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.opplugin.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.fi.fcc.common.enums.TaskTypeEnum;
import kd.fi.fcc.common.utils.HasCycleUtils;

public class CheckoutTaskSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            StringBuilder errorMsg = new StringBuilder();
            this.checkStartTime(dataEntity, errorMsg);
            this.checkRepeatService(dataEntity, errorMsg);
            if (StringUtils.isBlank((CharSequence)errorMsg)) {
                Map<Long, List<Long>> serviceMap = this.getServiceMap(dataEntity);
                this.checkIsHasCycle(dataEntity, serviceMap, errorMsg);
                this.checkChildTaskColumns(dataEntity, errorMsg);
            }
            if (errorMsg.length() <= 0) continue;
            this.addMessage(dataEntity, errorMsg.toString(), ErrorLevel.Error);
        }
    }

    private void checkStartTime(ExtendedDataEntity dataEntity, StringBuilder errorMsg) {
        Integer startDate = (Integer)dataEntity.getValue("startdate");
        Object startTime = dataEntity.getValue("starttime");
        Integer endDate = (Integer)dataEntity.getValue("enddate");
        Object endTime = dataEntity.getValue("endtime");
        Long dayMillis = 86400000L;
        startDate = null != startDate ? startDate : 0;
        Long startTimeMillis = dayMillis * (long)startDate.intValue();
        if (startTime instanceof Integer && (Integer)startTime != -1) {
            Integer startTimeInt = (Integer)startTime;
            startTimeMillis = startTimeMillis + (long)startTimeInt.intValue() * 1000L;
        }
        endDate = null != endDate ? endDate : 0;
        Long endTimeMillis = dayMillis * (long)endDate.intValue();
        if (endTime instanceof Integer && (Integer)endTime != -1) {
            Integer endTimeInt = (Integer)endTime;
            endTimeMillis = endTimeMillis + (long)endTimeInt.intValue() * 1000L;
        }
        if (startDate > endDate) {
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u5e94\u65e9\u4e8e\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u3002\n", (String)"CheckoutTaskSaveValidator_8", (String)"fi-fcc-opplugin", (Object[])new Object[0]), new Object[0]));
        } else if (startTimeMillis > endTimeMillis) {
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u5e94\u65e9\u4e8e\u8ba1\u5212\u7ed3\u675f\u65f6\u95f4\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u3002\n", (String)"CheckoutTaskSaveValidator_9", (String)"fi-fcc-opplugin", (Object[])new Object[0]), new Object[0]));
        }
    }

    private void checkRepeatService(ExtendedDataEntity dataEntity, StringBuilder errorMsg) {
        ArrayList<Long> serviceIdList = new ArrayList<Long>();
        DynamicObjectCollection serviceEntries = (DynamicObjectCollection)dataEntity.getValue("entryentity");
        if (null == serviceEntries || serviceEntries.size() == 0) {
            return;
        }
        for (DynamicObject serviceEntry : serviceEntries) {
            DynamicObject service = (DynamicObject)serviceEntry.get("service");
            if (null == service) continue;
            Long serviceId = service.getLong("id");
            String serviceName = service.getString("name");
            if (serviceIdList.contains(serviceId)) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u7ed3\u8d26\u96c6\u6210\u670d\u52a1\u201d%s\u201c\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u3002\n", (String)"CheckoutTaskSaveValidator_10", (String)"fi-fcc-opplugin", (Object[])new Object[0]), serviceName));
            }
            serviceIdList.add(serviceId);
        }
    }

    private Map<Long, List<Long>> getServiceMap(ExtendedDataEntity dataEntity) {
        HashMap<Long, List<Long>> servicesMap = new HashMap<Long, List<Long>>(2);
        DynamicObjectCollection serviceEntries = (DynamicObjectCollection)dataEntity.getValue("entryentity");
        if (null == serviceEntries || serviceEntries.size() == 0) {
            return null;
        }
        for (DynamicObject serviceEntry : serviceEntries) {
            ArrayList<Long> preIdList = new ArrayList<Long>(2);
            MulBasedataDynamicObjectCollection preServices = (MulBasedataDynamicObjectCollection)serviceEntry.get("preservice");
            DynamicObject service = (DynamicObject)serviceEntry.get("service");
            if (null == service || null == preServices) continue;
            Long serviceId = service.getLong("id");
            for (DynamicObject preService : preServices) {
                preIdList.add(preService.getLong("fbasedataid_id"));
            }
            servicesMap.put(serviceId, preIdList);
        }
        return servicesMap;
    }

    private void checkIsHasCycle(ExtendedDataEntity dataEntity, Map<Long, List<Long>> serviceMap, StringBuilder errorMsg) {
        if (null == serviceMap) {
            return;
        }
        DynamicObjectCollection serviceEntries = (DynamicObjectCollection)dataEntity.getValue("entryentity");
        for (DynamicObject serviceEntry : serviceEntries) {
            DynamicObject service = (DynamicObject)serviceEntry.get("service");
            if (null == service) continue;
            Long id = service.getLong("id");
            String name = service.getString("name");
            Boolean hasCycle = HasCycleUtils.hasCycle((Long)id, serviceMap);
            if (!hasCycle.booleanValue()) continue;
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u7ed3\u8d26\u96c6\u6210\u670d\u52a1\u201d%s\u201c\u4e0e\u524d\u7f6e\u96c6\u6210\u670d\u52a1\u5b58\u5728\u5faa\u73af\u4f9d\u8d56\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u3002\n", (String)"CheckoutTaskSaveValidator_11", (String)"fi-fcc-opplugin", (Object[])new Object[0]), name));
        }
    }

    private void checkChildTaskColumns(ExtendedDataEntity dataEntity, StringBuilder errorMsg) {
        boolean isEqualsBizSystem;
        boolean isEqualsGroup;
        Long bizSystemId;
        String taskType = (String)dataEntity.getValue("tasktype");
        if (StringUtils.equals((CharSequence)taskType, (CharSequence)TaskTypeEnum.TASK_SET.getType())) {
            return;
        }
        DynamicObject virtualTask = (DynamicObject)dataEntity.getValue("virtualtask");
        if (null == virtualTask) {
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u5b50\u4efb\u52a1\u7684\u4efb\u52a1\u96c6\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u3002\n", (String)"CheckoutTaskSaveValidator_12", (String)"fi-fcc-opplugin", (Object[])new Object[0]), new Object[0]));
            return;
        }
        Long pGroupId = virtualTask.getLong("group.id");
        Long pBizSystemId = virtualTask.getLong("bizsystem.id");
        DynamicObject group = (DynamicObject)dataEntity.getValue("group");
        DynamicObject bizSystem = (DynamicObject)dataEntity.getValue("bizsystem");
        Long groupId = group == null ? null : Long.valueOf(group.getLong("id"));
        Long l = bizSystemId = bizSystem == null ? null : Long.valueOf(bizSystem.getLong("id"));
        boolean bl = pGroupId == null ? groupId == null : (isEqualsGroup = pGroupId.equals(groupId));
        boolean bl2 = pBizSystemId == null ? bizSystemId == null : (isEqualsBizSystem = pBizSystemId.equals(bizSystemId));
        if (!isEqualsGroup) {
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u7684\u6765\u6e90\u7cfb\u7edf\u4e0e\u6240\u5c5e\u4efb\u52a1\u96c6\u7684\u6765\u6e90\u7cfb\u7edf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u3002\n", (String)"CheckoutTaskSaveValidator_13", (String)"fi-fcc-opplugin", (Object[])new Object[0]), new Object[0]));
        }
        if (!isEqualsBizSystem) {
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u7684\u4e1a\u52a1\u5e94\u7528\u4e0e\u6240\u5c5e\u4efb\u52a1\u96c6\u7684\u4e1a\u52a1\u5e94\u7528\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u3002\n", (String)"CheckoutTaskSaveValidator_14", (String)"fi-fcc-opplugin", (Object[])new Object[0]), new Object[0]));
        }
    }
}

