/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bd.util.ContextUtil;
import kd.fi.fcc.common.constant.FCCField;
import kd.fi.fcc.common.enums.CheckoutCycleEnum;
import kd.fi.fcc.common.enums.CheckoutFlowStatusEnum;
import kd.fi.fcc.common.utils.FccUtil;

public class CheckOutViewUtil {
    private static final String FCC_CHECKOUT_FLOW_DETAIL = "fcc_checkout_flow_detail";
    private static final String FCC_ORG_STRUCTURE = "fcc_org_structure";
    private static final String FCC_CHECKOUT_PLAN = "fcc_checkout_plan";

    public static long getView(Long planId) {
        DynamicObject view;
        DynamicObject fccOrgStr;
        if (planId != null && planId != 0L && null != (fccOrgStr = BusinessDataServiceHelper.loadSingleFromCache((String)FCC_ORG_STRUCTURE, (QFilter[])new QFilter[]{new QFilter("plan", "=", (Object)planId)})) && null != (view = fccOrgStr.getDynamicObject("view"))) {
            return view.getLong("id");
        }
        return CheckOutViewUtil.getDefaultView();
    }

    private static long getDefaultView() {
        long viewId = 0L;
        DynamicObject fccView = BusinessDataServiceHelper.loadSingleFromCache((String)"fcc_checkout_view", (String)"id", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)true)});
        if (fccView != null) {
            viewId = fccView.getLong("id");
        }
        return viewId;
    }

    public static OperationResult copyOrgStrcutureToFcc(DynamicObject plan) {
        long viewId = CheckOutViewUtil.getDefaultView();
        List<String> fields = CheckOutViewUtil.getFields();
        Map bosOrgStructures = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)String.join((CharSequence)",", fields), (QFilter[])new QFilter[]{new QFilter("view.id", "=", (Object)viewId)});
        ArrayList<DynamicObject> fccOrgStructures = new ArrayList<DynamicObject>(bosOrgStructures.size());
        for (Map.Entry bosOrgStructure : bosOrgStructures.entrySet()) {
            DynamicObject orgStructure;
            String longnumber = (orgStructure = (DynamicObject)bosOrgStructure.getValue()).getString("longnumber");
            orgStructure.set("number", (Object)(longnumber.contains("!") ? longnumber.substring(longnumber.lastIndexOf(33) + 1) : longnumber));
            String longname = orgStructure.getString("fullname");
            LocaleString name = new LocaleString();
            name.setLocaleValue_zh_CN(longname.contains("!") ? longname.substring(longname.lastIndexOf(33) + 1) : longname);
            orgStructure.set("name", (Object)name);
            DynamicObject fccOrgStructure = BusinessDataServiceHelper.newDynamicObject((String)FCC_ORG_STRUCTURE);
            fccOrgStructure.set("plan", (Object)plan);
            for (String field : fields) {
                fccOrgStructure.set(field, orgStructure.get(field));
            }
            fccOrgStructures.add(fccOrgStructure);
        }
        OperationResult saveResult = SaveServiceHelper.saveOperate((String)FCC_ORG_STRUCTURE, (DynamicObject[])fccOrgStructures.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        return saveResult;
    }

    public static OperationResult deleteFccOrgStrcuture(DynamicObject plan) {
        Map bosOrgStructures = BusinessDataServiceHelper.loadFromCache((String)FCC_ORG_STRUCTURE, (String)"id", (QFilter[])new QFilter[]{new QFilter("plan.id", "=", plan.getPkValue())});
        List delPkIds = bosOrgStructures.values().stream().map(r -> r.getLong("id")).collect(Collectors.toList());
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignorewarn", String.valueOf(true));
        OperationResult delResult = OperationServiceHelper.executeOperate((String)"delete", (String)FCC_ORG_STRUCTURE, (Object[])delPkIds.toArray(), (OperateOption)option);
        return delResult;
    }

    public static Map<String, Map<String, String>> getAllOrgByViewId(Long planId, QFilter qFilter, boolean isIncludeDisable) {
        QFilter orgViewIdFilter = new QFilter("plan", "=", (Object)planId);
        if (qFilter != null) {
            orgViewIdFilter.and(qFilter);
        }
        if (!isIncludeDisable) {
            orgViewIdFilter.and(new QFilter("org.enable", "=", (Object)"1"));
        }
        HashMap<String, Map<String, String>> orgTreeMap = new HashMap<String, Map<String, String>>();
        try (DataSet data = QueryServiceHelper.queryDataSet((String)"CheckOutViewUtil.getAllOrgByViewId", (String)FCC_ORG_STRUCTURE, (String)"id,org.id,org.name,org.number,parent.id,isleaf,longnumber", (QFilter[])orgViewIdFilter.toArray(), (String)"longnumber");){
            while (data.hasNext()) {
                HashMap<String, String> mtree = new HashMap<String, String>();
                Row row = data.next();
                String id = String.valueOf(row.getLong("org.id"));
                mtree.put("id", id);
                mtree.put("name", row.getString("org.name"));
                mtree.put("number", row.getString("org.number"));
                mtree.put("parentid", String.valueOf(row.getLong("parent.id")));
                mtree.put("isleaf", row.getBoolean("isleaf") != false ? "1" : "0");
                mtree.put("longnumber", row.getString("longnumber"));
                orgTreeMap.put(id, mtree);
            }
        }
        if (orgTreeMap.isEmpty()) {
            CheckOutViewUtil.getBosOrgTreeMap(orgTreeMap, qFilter, isIncludeDisable);
        }
        return orgTreeMap;
    }

    private static void getBosOrgTreeMap(Map<String, Map<String, String>> orgTreeMap, QFilter qFilter, boolean isIncludeDisable) {
        QFilter orgViewIdFilter = new QFilter("view", "=", (Object)CheckOutViewUtil.getDefaultView());
        if (qFilter != null) {
            orgViewIdFilter.and(qFilter);
        }
        if (!isIncludeDisable) {
            orgViewIdFilter.and(new QFilter("org.enable", "=", (Object)"1"));
        }
        try (DataSet data = QueryServiceHelper.queryDataSet((String)"CheckOutViewUtil.getBosOrgTreeMap", (String)"bos_org_structure", (String)"id,org.id,org.name,org.number,parent.id,isleaf,longnumber", (QFilter[])orgViewIdFilter.toArray(), (String)"longnumber");){
            while (data.hasNext()) {
                HashMap<String, String> mtree = new HashMap<String, String>();
                Row row = data.next();
                String id = String.valueOf(row.getLong("org.id"));
                mtree.put("id", id);
                mtree.put("name", row.getString("org.name"));
                mtree.put("number", row.getString("org.number"));
                mtree.put("parentid", String.valueOf(row.getLong("parent.id")));
                mtree.put("isleaf", row.getBoolean("isleaf") != false ? "1" : "0");
                mtree.put("longnumber", row.getString("longnumber"));
                orgTreeMap.put(id, mtree);
            }
        }
    }

    public static Map<Object, DynamicObject> getEnableLeafOrgByView(long view) {
        QFilter qFilter = new QFilter("view", "=", (Object)view);
        qFilter.and("isleaf", "=", (Object)"1");
        qFilter.and("org.enable", "=", (Object)"1");
        String selectProperties = "id,org.id,org.name,org.number,parent.id,isleaf,longnumber";
        Map orgStructures = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
        return orgStructures;
    }

    private static List<String> getFields() {
        ArrayList<String> fields = new ArrayList<String>(17);
        fields.add("modifier");
        fields.add("createtime");
        fields.add("modifytime");
        fields.add("number");
        fields.add("name");
        fields.add("status");
        fields.add("creator");
        fields.add("enable");
        fields.add("masterid");
        fields.add("level");
        fields.add("view");
        fields.add("longnumber");
        fields.add("fullname");
        fields.add("isleaf");
        fields.add("org");
        fields.add("yzjorgid");
        fields.add("parent");
        fields.add("yzjparentorgid");
        fields.add("isstatsum");
        fields.add("isbizunit");
        fields.add("isctrlunit");
        fields.add("startdate");
        fields.add("enddate");
        fields.add("isfreeze");
        fields.add("sealuptime");
        fields.add("sortcode");
        fields.add("ishr");
        fields.add("orgpattern");
        fields.add("comment");
        return fields;
    }

    public static Map<Object, DynamicObject> getHasPermOrgByView(long view) {
        HasPermOrgResult fcc = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)"fcc", (String)FCC_CHECKOUT_FLOW_DETAIL, (String)"47150e89000000ac");
        QFilter qFilter = new QFilter("view", "=", (Object)view);
        qFilter.and("isleaf", "=", (Object)"1");
        qFilter.and("org.enable", "=", (Object)"1");
        if (!fcc.hasAllOrgPerm()) {
            qFilter.and("org", "in", (Object)fcc.getHasPermOrgs());
        }
        String selectProperties = "id,org.id,org.name,org.number,parent.id,isleaf,longnumber";
        Map orgStructures = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
        return orgStructures;
    }

    public static List<Long> getAllLeaveOrgs(Long viewId) {
        QFilter qFilter = new QFilter("view", "=", (Object)viewId);
        qFilter.and("isleaf", "=", (Object)true);
        qFilter.and("org.enable", "=", (Object)true);
        String selectProperties = "org.id";
        Map orgStructures = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
        ArrayList<Long> orgIds = new ArrayList<Long>(orgStructures.size());
        for (Map.Entry entry : orgStructures.entrySet()) {
            orgIds.add(((DynamicObject)entry.getValue()).getLong("org.id"));
        }
        return orgIds;
    }

    public static void createFlows(List<Long> newLeafOrgIds) {
        QFilter qFilter = new QFilter("planstatus", "=", (Object)"A");
        Map plans = BusinessDataServiceHelper.loadFromCache((String)FCC_CHECKOUT_PLAN, (String)"id,method,month", (QFilter[])new QFilter[]{qFilter});
        if (plans.size() == 0) {
            return;
        }
        for (Map.Entry entry : plans.entrySet()) {
            DynamicObject plan = (DynamicObject)entry.getValue();
            long planId = plan.getLong("id");
            DynamicObject fccOrgStr = BusinessDataServiceHelper.loadSingleFromCache((String)FCC_ORG_STRUCTURE, (QFilter[])new QFilter[]{new QFilter("plan", "=", (Object)planId)});
            if (fccOrgStr != null) continue;
            Date flowDate = new Date();
            QFilter flowFilter = new QFilter("plan", "=", (Object)planId);
            if (CheckoutCycleEnum.MONTH_END.getValue().equals(plan.getString("method"))) {
                flowDate = plan.getDate("month");
            } else if (CheckoutCycleEnum.DAY_END.getValue().equals(plan.getString("method"))) {
                flowDate = FccUtil.getLatestFlowDate(plan.getLong("id"));
            }
            if (flowDate == null) {
                return;
            }
            flowFilter.and("flowdate", "=", (Object)flowDate);
            DynamicObject[] load = BusinessDataServiceHelper.load((String)FCC_CHECKOUT_FLOW_DETAIL, (String)FCCField.id("org"), (QFilter[])new QFilter[]{flowFilter});
            List<Long> orgIds = Arrays.stream(load).map(flow -> flow.getLong(FCCField.id("org"))).collect(Collectors.toList());
            CheckOutViewUtil.createFlows(plan, newLeafOrgIds, orgIds, flowDate);
        }
    }

    public static void createFlows(DynamicObject plan, List<Long> newLeafOrgIds) {
        long planId = plan.getLong("id");
        DynamicObject fccOrgStr = BusinessDataServiceHelper.loadSingleFromCache((String)FCC_ORG_STRUCTURE, (QFilter[])new QFilter[]{new QFilter("plan", "=", (Object)planId)});
        if (fccOrgStr != null) {
            return;
        }
        Date flowDate = new Date();
        QFilter flowFilter = new QFilter("plan", "=", (Object)planId);
        if (CheckoutCycleEnum.MONTH_END.getValue().equals(plan.getString("method"))) {
            flowDate = plan.getDate("month");
        } else if (CheckoutCycleEnum.DAY_END.getValue().equals(plan.getString("method"))) {
            flowDate = FccUtil.getLatestFlowDate(plan.getLong("id"));
        }
        if (flowDate == null) {
            return;
        }
        flowFilter.and("flowdate", "=", (Object)flowDate);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)FCC_CHECKOUT_FLOW_DETAIL, (String)FCCField.id("org"), (QFilter[])new QFilter[]{flowFilter});
        List<Long> orgIds = Arrays.stream(load).map(flow -> flow.getLong(FCCField.id("org"))).collect(Collectors.toList());
        CheckOutViewUtil.createFlows(plan, newLeafOrgIds, orgIds, flowDate);
    }

    private static void createFlows(DynamicObject plan, List<Long> newLeafOrgIds, List<Long> orgIds, Date flowDate) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(newLeafOrgIds.size());
        for (Long newLeafOrgId : newLeafOrgIds) {
            if (orgIds.contains(newLeafOrgId)) continue;
            DynamicObject flow = BusinessDataServiceHelper.newDynamicObject((String)FCC_CHECKOUT_FLOW_DETAIL);
            flow.set("plan", plan.getPkValue());
            flow.set("org", (Object)newLeafOrgId);
            flow.set("flowstatus", (Object)CheckoutFlowStatusEnum.unconfirm.getType());
            flow.set("flowdate", (Object)flowDate);
            flow.set("creator", (Object)RequestContext.get().getCurrUserId());
            flow.set("createtime", (Object)new Date());
            flow.set("billstatus", (Object)"A");
            list.add(flow);
        }
        if (list.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
        }
    }
}

