/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.common.utils;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HasCycleUtils {
    public static Boolean hasCycle(Long id, Map<Long, List<Long>> servicesMap) {
        HashSet<Long> stack = new HashSet<Long>(2);
        return HasCycleUtils.hasCycleHelper(id, servicesMap, stack);
    }

    public static boolean hasCycleHelper(Long id, Map<Long, List<Long>> servicesMap, Set<Long> stack) {
        if (stack.contains(id)) {
            return true;
        }
        stack.add(id);
        List<Long> preServiceId = servicesMap.get(id);
        if (preServiceId != null) {
            for (Long preId : preServiceId) {
                if (!HasCycleUtils.hasCycleHelper(preId, servicesMap, stack)) continue;
                return true;
            }
        }
        stack.remove(id);
        return false;
    }

    public static void dfs(Long serviceId, Set<Long> visited, Map<Long, List<Long>> servicesMap, List<Long> sortedTasks) {
        visited.add(serviceId);
        List<Long> preServiceIds = servicesMap.get(serviceId);
        if (null != preServiceIds && preServiceIds.size() > 0) {
            for (Long preServiceId : preServiceIds) {
                if (visited.contains(preServiceId)) continue;
                HasCycleUtils.dfs(preServiceId, visited, servicesMap, sortedTasks);
            }
        }
        sortedTasks.add(serviceId);
    }
}

