/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.business.helper;

import java.util.Date;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang.exception.ExceptionUtils;

public class CheckOutTaskHelper {
    private static final Log log = LogFactory.getLog(CheckOutTaskHelper.class);
    private static final Long DLOCK_EXPIRED_TIME = 30000L;

    private static String genTaskIdLockKey(Long taskId) {
        StringBuilder key = new StringBuilder("kd.fi.fcc.CheckOutFLowTask");
        key.append(".writeTaskFlowStatus.").append(taskId);
        return key.toString();
    }

    public static void writeTaskFlowStatus(Long taskId, String status, Date startTime, Date endTime) {
        block12: {
            String lockKey = CheckOutTaskHelper.genTaskIdLockKey(taskId);
            DLock dLock = null;
            try {
                dLock = DLock.create((String)lockKey, (String)("writeTaskFlowStatus lock, taskId:" + taskId));
                boolean hasLock = dLock.tryLock(DLOCK_EXPIRED_TIME.longValue());
                if (hasLock) {
                    CheckOutTaskHelper.udpateTaskDetailStatus(taskId, status, startTime, endTime);
                    break block12;
                }
                throw new KDBizException("writeTaskFlowStatus get lock failed, taskId:" + taskId);
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error("CheckOutTaskHelper writeTaskFlowStatus occur exception, e:" + ExceptionUtils.getFullStackTrace((Throwable)e) + "------lock info:" + DLock.getLockInfo((String)lockKey));
                }
                throw e;
            }
            finally {
                block13: {
                    try {
                        if (dLock != null) {
                            dLock.unlock();
                        }
                    }
                    catch (Exception e) {
                        if (!log.isErrorEnabled()) break block13;
                        log.error("CheckOutTaskHelper writeTaskFlowStatus unlock occur exception, e:" + ExceptionUtils.getFullStackTrace((Throwable)e) + "------lock info:" + DLock.getLockInfo((String)lockKey));
                    }
                }
            }
        }
    }

    public static void writeTaskFlowStatusAndTwoDate(Long taskId, String status, Date startTime, Date endTime) {
        block12: {
            String lockKey = CheckOutTaskHelper.genTaskIdLockKey(taskId);
            DLock dLock = null;
            try {
                dLock = DLock.create((String)lockKey, (String)("writeTaskFlowStatus lock, taskId:" + taskId));
                boolean hasLock = dLock.tryLock(DLOCK_EXPIRED_TIME.longValue());
                if (hasLock) {
                    String sql = "UPDATE t_fcc_checkflow_det_entry SET ftaskstatus = ?, ftruestarttime = ?, ftrueendtime = ? WHERE fentryid=?;";
                    DB.update((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])new Object[]{status, startTime, endTime, taskId});
                    break block12;
                }
                throw new KDBizException("writeTaskFlowStatus get lock failed, taskId:" + taskId);
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error("CheckOutTaskHelper writeTaskFlowStatus occur exception, e:" + ExceptionUtils.getFullStackTrace((Throwable)e) + "------lock info:" + DLock.getLockInfo((String)lockKey));
                }
                throw e;
            }
            finally {
                block13: {
                    try {
                        if (dLock != null) {
                            dLock.unlock();
                        }
                    }
                    catch (Exception e) {
                        if (!log.isErrorEnabled()) break block13;
                        log.error("CheckOutTaskHelper writeTaskFlowStatus unlock occur exception, e:" + ExceptionUtils.getFullStackTrace((Throwable)e) + "------lock info:" + DLock.getLockInfo((String)lockKey));
                    }
                }
            }
        }
    }

    private static void udpateTaskDetailStatus(Long detailId, String taskstatus, Date startTime, Date endTime) {
        if (startTime == null && endTime != null) {
            String sql = "UPDATE t_fcc_checkflow_det_entry SET ftaskstatus=?,ftrueendtime = ? WHERE fentryid=?;";
            DB.update((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])new Object[]{taskstatus, endTime, detailId});
        } else if (endTime == null && startTime != null) {
            String sql = "UPDATE t_fcc_checkflow_det_entry SET ftaskstatus=?,ftruestarttime = ? WHERE fentryid=?;";
            DB.update((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])new Object[]{taskstatus, startTime, detailId});
        } else if (startTime == null && endTime == null) {
            String sql = "UPDATE t_fcc_checkflow_det_entry SET ftaskstatus=? WHERE fentryid=?;";
            DB.update((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])new Object[]{taskstatus, detailId});
        }
    }
}

