/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.business.helper;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fcc.common.enums.FccExecuteStatusEnum;
import kd.fi.fcc.common.enums.TaskStatusEnum;

public class FccExecuteTaskLogHelper {
    private static final Log log = LogFactory.getLog(FccExecuteTaskLogHelper.class);
    private static final String PLAN_CHECKFLOWDETAIL_ID = "checkflowdetail";
    private static final String TASK_MESSAGE = "taskmessage";
    private static final String TASK_STATUS = "taskstatus";
    private static final String SERVICE_ID = "service";
    private static final String SERVICE_TRACE_ID = "traceid";
    private static final String SERVICE_STATUS = "servicestatus";
    private static final String SERVICE_ASYNC_STATUS = "asynchronousstatus";
    private static final String SERVICE_MESSAGE = "servicemessage";
    private static final String SERVICE_STARTDATE = "servicestartdate";
    private static final String SERVICE_ENDDATE = "serviceenddate";
    private static final String TASK_EXECUTE__LOG = "fcc_execute_task_log";
    private static final String SERVICE_ENTRY = "entryentity";

    public static void writeTaskLogEntry(Long checkflowdetail, Long serviceId, String nonce, String taskStatus, String serviceStatus, Date startDate, Date endDate, String serviceMessage) {
        QFilter[] qFilters = new QFilter[]{new QFilter(PLAN_CHECKFLOWDETAIL_ID, "=", (Object)checkflowdetail)};
        StringBuilder selectProperties = new StringBuilder();
        selectProperties.append("id").append(",");
        selectProperties.append(TASK_MESSAGE).append(",");
        selectProperties.append(TASK_STATUS).append(",");
        selectProperties.append("entryentity.service").append(",");
        selectProperties.append("entryentity.traceid").append(",");
        selectProperties.append("entryentity.servicestatus").append(",");
        selectProperties.append("entryentity.servicemessage").append(",");
        selectProperties.append("entryentity.servicestartdate").append(",");
        selectProperties.append("entryentity.serviceenddate").append(",");
        selectProperties.append("entryentity.asynchronousstatus");
        DynamicObject[] taskLogLoad = BusinessDataServiceHelper.load((String)TASK_EXECUTE__LOG, (String)selectProperties.toString(), (QFilter[])qFilters, (String)"id desc");
        boolean saveFlag = false;
        for (DynamicObject taskLog : taskLogLoad) {
            DynamicObjectCollection entryEntity = taskLog.getDynamicObjectCollection(SERVICE_ENTRY);
            for (DynamicObject tasklogEntry : entryEntity) {
                log.info("tasklogEntry:" + tasklogEntry.toString());
                String executeNonce = tasklogEntry.getString(SERVICE_TRACE_ID);
                startDate = tasklogEntry.getDate(SERVICE_STARTDATE);
                if (!nonce.equals(executeNonce)) continue;
                saveFlag = true;
                DynamicObject dynamicObject = entryEntity.addNew();
                dynamicObject.set("id", dynamicObject.getPkValue());
                dynamicObject.set(SERVICE_TRACE_ID, (Object)nonce);
                dynamicObject.set(SERVICE_ID, (Object)serviceId);
                dynamicObject.set(SERVICE_STATUS, (Object)serviceStatus);
                dynamicObject.set(SERVICE_ASYNC_STATUS, (Object)"R");
                dynamicObject.set(SERVICE_STARTDATE, (Object)startDate);
                dynamicObject.set(SERVICE_ENDDATE, (Object)endDate);
                dynamicObject.set(SERVICE_MESSAGE, (Object)serviceMessage);
                break;
            }
            if (!saveFlag) continue;
            FccExecuteStatusEnum fccExecuteStatusEnum = FccExecuteStatusEnum.getCallType((String)taskStatus);
            switch (fccExecuteStatusEnum) {
                case WARN: {
                    taskLog.set(TASK_STATUS, (Object)TaskStatusEnum.FAILED);
                    taskLog.set(TASK_MESSAGE, (Object)serviceMessage);
                    break;
                }
                case ERROR: {
                    taskLog.set(TASK_STATUS, (Object)TaskStatusEnum.FAILED);
                    taskLog.set(TASK_MESSAGE, (Object)serviceMessage);
                    break;
                }
                case PASS: {
                    taskLog.set(TASK_STATUS, (Object)TaskStatusEnum.DONE);
                    taskLog.set(TASK_MESSAGE, (Object)TaskStatusEnum.DONE.getName());
                }
            }
            log.info("updatedata start:" + taskLog);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskLog});
            log.info("updatedata end:" + taskLog);
            saveFlag = false;
        }
    }
}

