/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.business.message;

import com.alibaba.fastjson.JSON;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.earlywarn.EarlyWarnContext;
import kd.bos.entity.earlywarn.warn.plugin.IEarlyWarnCustomReceiver;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class CustomReceiver
implements IEarlyWarnCustomReceiver {
    private static final Log log = LogFactory.getLog(CustomReceiver.class);
    private static final String FLOW_DETAIL_ENTITY = "fcc_checkout_flow_detail";

    public List<Long> getReceiverIds(EarlyWarnContext earlyWarnContext, DynamicObject[] dynamicObjects) {
        try {
            HashSet<Long> ids = new HashSet<Long>(dynamicObjects.length);
            for (DynamicObject object : dynamicObjects) {
                long id = object.getLong("id");
                ids.add(id);
            }
            QFilter qFilter = new QFilter("id", "in", ids);
            DynamicObjectCollection query = QueryServiceHelper.query((String)FLOW_DETAIL_ENTITY, (String)"id,taskentry.executor.id", (QFilter[])new QFilter[]{qFilter});
            List<Long> receiverIds = query.stream().map(r -> (Long)r.get("taskentry.executor.id")).collect(Collectors.toList());
            log.info("CustomReceiver getReceiverIds ids={},receiverId={}", (Object)JSON.toJSONString(ids), (Object)JSON.toJSONString(receiverIds));
            return receiverIds;
        }
        catch (Exception e) {
            log.info("CustomReceiver getReceiverIds e={}", (Object)e);
            return null;
        }
    }
}

