/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.business.message;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.earlywarn.EarlyWarnContext;
import kd.bos.entity.earlywarn.warn.EarlyWarnMessageInfo;
import kd.bos.entity.earlywarn.warn.plugin.IEarlyWarnMessageHandler;
import kd.bos.ext.fi.util.DateUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.earlywarn.impl.DefaultWarnMessageHandler;
import kd.bos.url.UrlService;
import kd.fi.fcc.common.enums.CheckoutCycleEnum;

public class DelayedWarnMessageHandler
implements IEarlyWarnMessageHandler {
    private final Log logger = LogFactory.getLog(DefaultWarnMessageHandler.class);
    private String clientPath = "";
    private String formId = "";
    private String mobFormId = "";

    public DelayedWarnMessageHandler() {
        RequestContext ctx = RequestContext.get();
        this.clientPath = UrlService.getDomainContextUrlByTenantCode((String)ctx.getTenantCode());
    }

    public EarlyWarnMessageInfo singleMessageBuilder(DynamicObject data, EarlyWarnContext context) {
        this.formId = "fcc_workbench_person";
        if (StringUtils.isNotEmpty((CharSequence)this.clientPath) && StringUtils.isNotEmpty((CharSequence)this.formId) && data != null) {
            EarlyWarnMessageInfo messageInfo = new EarlyWarnMessageInfo();
            String pkId = data.get("id").toString();
            StringBuilder contentUrl = new StringBuilder(this.clientPath);
            contentUrl = contentUrl.append("?formId=").append(this.formId).append("&pkId=").append(pkId);
            if (StringUtils.isNotEmpty((CharSequence)this.mobFormId)) {
                StringBuilder mobContentUrl = new StringBuilder(this.clientPath);
                if (!this.clientPath.endsWith("/")) {
                    mobContentUrl = mobContentUrl.append("/");
                }
                mobContentUrl = mobContentUrl.append("mobile.html?form=").append(this.mobFormId).append("&pkId=").append(pkId);
                messageInfo.setMobContentUrl(mobContentUrl.toString());
            }
            DynamicObject dataEntity = data.getDynamicObject("plan");
            String method = dataEntity.getString("method");
            if (CheckoutCycleEnum.MONTH_END.getValue().equals(method)) {
                String checkmethod = "month_check";
                Date month = dataEntity.getDate("month");
                String monthString = DateUtils.formatString((Date)month, (String)"yyyy-MM-dd HH:mm:ss");
                contentUrl.append("&month=").append(monthString);
                contentUrl.append("&checkmethod=").append(checkmethod);
            } else if (CheckoutCycleEnum.DAY_END.getValue().equals(method)) {
                String checkmethod = "day_check";
                Date startdate = dataEntity.getDate("startdate");
                Date enddate = dataEntity.getDate("enddate");
                Date date = this.getLastestDate(startdate, enddate);
                String dateString = DateUtils.formatString((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
                contentUrl.append("&date=").append(dateString);
                contentUrl.append("&checkmethod=").append(checkmethod);
            }
            messageInfo.setContentUrl(contentUrl.toString());
            return messageInfo;
        }
        return null;
    }

    private Date getLastestDate(Date startdate, Date enddate) {
        Date now = new Date();
        if (startdate == null || enddate == null) {
            return now;
        }
        if (now.before(startdate)) {
            return startdate;
        }
        if (now.after(enddate)) {
            return enddate;
        }
        return now;
    }

    public EarlyWarnMessageInfo mergeMessageBuilder(EarlyWarnContext context) {
        return null;
    }
}

