/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.business.message;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.earlywarn.EarlyWarnContext;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.earlywarn.warn.plugin.IEarlyWarnDataSource;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.fi.util.DateUtils;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fcc.common.enums.CheckoutCycleEnum;
import org.apache.commons.lang3.math.NumberUtils;

public class WarnDataSource
implements IEarlyWarnDataSource {
    public List<QFilter> buildFilter(String dataSource, FilterCondition filterCondition, EarlyWarnContext context) {
        ArrayList<QFilter> statusFilters = new ArrayList<QFilter>();
        String number = context.getWarnSchedule().getNumber();
        if (number.equals("FCC-YJ-01")) {
            statusFilters.add(new QFilter("plan.method", "=", (Object)CheckoutCycleEnum.MONTH_END.getValue()));
            statusFilters.add(new QFilter("taskentry.endtime", "<", (Object)new Date()));
        } else if (number.equals("FCC-YJ-03")) {
            statusFilters.add(new QFilter("plan.method", "=", (Object)CheckoutCycleEnum.DAY_END.getValue()));
            statusFilters.add(new QFilter("taskentry.enddaytime", "<", (Object)this.getNowInteger()));
        }
        statusFilters.add(new QFilter("plan.planstatus", "=", (Object)"B"));
        statusFilters.add(new QFilter("taskentry.taskstatus", "!=", (Object)"c"));
        return statusFilters;
    }

    private Integer getNowInteger() {
        String time = DateUtils.formatString((Date)new Date(), (String)"HH:mm:ss");
        String[] split = StringUtil.split((String)time, (String)":");
        int hour = NumberUtils.toInt((String)split[0]);
        int minute = NumberUtils.toInt((String)split[1]);
        int second = NumberUtils.toInt((String)split[2]);
        return hour * 3600 + minute * 60 + second;
    }

    public DynamicObjectCollection getData(String dataSource, List<QFilter> filters, EarlyWarnContext context) {
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        DynamicObject[] load = BusinessDataServiceHelper.load((String)dataSource, (String)String.join((CharSequence)",", this.getFields()), (QFilter[])filters.toArray(new QFilter[filters.size()]));
        if (load != null && load.length > 0) {
            HashSet<Long> set = new HashSet<Long>(20);
            for (DynamicObject dynamicObject : load) {
                DynamicObjectCollection taskentry = dynamicObject.getDynamicObjectCollection("taskentry");
                if (taskentry == null || taskentry.size() <= 0) continue;
                for (DynamicObject entry : taskentry) {
                    long aLong = entry.getLong("executor.id");
                    if (!set.contains(aLong)) {
                        dynamicObjects.add((Object)dynamicObject);
                    }
                    set.add(aLong);
                }
            }
        }
        return dynamicObjects;
    }

    private List<String> getFields() {
        ArrayList<String> fields = new ArrayList<String>(20);
        fields.add("id");
        fields.add("plan");
        fields.add("plan.method");
        fields.add("plan.month");
        fields.add("plan.startdate");
        fields.add("plan.enddate");
        fields.add("taskentry");
        fields.add("taskentry.id");
        fields.add("taskentry.pid");
        fields.add("taskentry.isdelay");
        fields.add("taskentry.tasknumber");
        fields.add("taskentry.tasknumber.name");
        fields.add("taskentry.eorg");
        fields.add("taskentry.eorg.name");
        fields.add("taskentry.taskstatus");
        fields.add("taskentry.starttime");
        fields.add("taskentry.endtime");
        fields.add("taskentry.startdaytime");
        fields.add("taskentry.enddaytime");
        fields.add("taskentry.trueendtime");
        fields.add("taskentry.executor");
        return fields;
    }

    public List<Map<String, Object>> getCommonFilterColumns(String dataSource) {
        return null;
    }

    public TreeNode getSingleMessageFieldTree(String dataSource) {
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setIncludeEntryEntityAsKeyPrefix(true);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)dataSource);
        TreeNode root = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainEntityType, (PropTreeBuildOption)option);
        root.setIsOpened(true);
        return root;
    }

    public TreeNode getMergeMessageFieldTree(String dataSource) {
        return new TreeNode();
    }
}

