/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.business.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.util.DateUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fcc.common.constant.FCCField;
import kd.fi.fcc.common.enums.CheckoutCycleEnum;
import kd.fi.fcc.common.enums.TaskStatusEnum;

public class CreateFlowTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(CreateFlowTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Date currentDate = DateUtils.getCurrentDate();
        Date lastDay = DateUtils.getLastDay((Date)currentDate, (int)1);
        QFilter qFilter = new QFilter("planstatus", "=", (Object)"B");
        qFilter.and("method", "=", (Object)CheckoutCycleEnum.DAY_END.getValue());
        qFilter.and("startdate", "<", (Object)currentDate);
        qFilter.and("enddate", ">=", (Object)currentDate);
        DynamicObject[] plans = BusinessDataServiceHelper.load((String)"fcc_checkout_plan", (String)"id,number,name,startdate,enddate", (QFilter[])new QFilter[]{qFilter});
        if (plans.length == 0) {
            return;
        }
        for (DynamicObject plan : plans) {
            long planId = plan.getLong("id");
            QFilter flowFilter = new QFilter("plan", "=", (Object)planId);
            QFilter todayFilter = new QFilter("flowdate", "=", (Object)currentDate);
            DynamicObject[] todayFlows = BusinessDataServiceHelper.load((String)"fcc_checkout_flow_detail", (String)"id", (QFilter[])new QFilter[]{flowFilter, todayFilter});
            if (todayFlows.length > 0) continue;
            flowFilter.and("flowdate", "=", (Object)lastDay);
            DynamicObject[] flows = BusinessDataServiceHelper.load((String)"fcc_checkout_flow_detail", (String)"id,plan,org,flowstatus,flowperson,creator,createtime,tasknum,flowdate,billstatus,confirmuser,confirmtime,canconfirmuser,canconfirmtime,taskentry.tasknumber,taskentry.pid,taskentry.eorg,taskentry.ebizorg,taskentry.type,taskentry.executor,taskentry.seq,taskentry.starttime,taskentry.endtime,taskentry.startdaytime,taskentry.enddaytime,taskentry.pretasks,taskentry.bizbooktype,taskentry.taskstatus", (QFilter[])new QFilter[]{flowFilter});
            if (flows.length == 0) continue;
            for (DynamicObject flow : flows) {
                DynamicObject org = flow.getDynamicObject("org");
                DynamicObjectType dynamicObjectType = flow.getDynamicObjectType();
                DynamicObject copyFlow = new DynamicObject(dynamicObjectType);
                copyFlow.set("plan", (Object)planId);
                copyFlow.set("org", (Object)org);
                copyFlow.set("flowstatus", (Object)flow.getString("flowstatus"));
                copyFlow.set("creator", (Object)flow.getDynamicObject("creator"));
                copyFlow.set("createtime", (Object)new Date());
                copyFlow.set("billstatus", (Object)"A");
                copyFlow.set("tasknum", (Object)flow.getInt("tasknum"));
                copyFlow.set("flowdate", (Object)currentDate);
                copyFlow.set("confirmuser", (Object)flow.getDynamicObject("confirmuser"));
                copyFlow.set("confirmtime", flow.get("confirmtime"));
                copyFlow.set("canconfirmuser", (Object)flow.getDynamicObject("canconfirmuser"));
                copyFlow.set("canconfirmtime", flow.get("canconfirmtime"));
                DynamicObjectCollection taskEntry = flow.getDynamicObjectCollection("taskentry");
                if (taskEntry.size() == 0) {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{copyFlow});
                    continue;
                }
                HashMap<String, Long> idMapping = new HashMap<String, Long>(taskEntry.size());
                HashMap<String, Long> pidMapping = new HashMap<String, Long>(taskEntry.size());
                HashMap<String, List<String>> preTaskMapping = new HashMap<String, List<String>>(taskEntry.size());
                DynamicObjectCollection copyTaskEntry = copyFlow.getDynamicObjectCollection("taskentry");
                for (DynamicObject task : taskEntry) {
                    DynamicObject tasknumber = task.getDynamicObject("tasknumber");
                    DynamicObject copyTask = copyTaskEntry.addNew();
                    copyTask.set("tasknumber", (Object)tasknumber);
                    copyTask.set("eorg", task.get("eorg"));
                    copyTask.set("ebizorg", task.get("ebizorg"));
                    String type = task.getString("type");
                    if (StringUtils.isNotEmpty((String)type)) {
                        copyTask.set("type", task.get("type"));
                        copyTask.set("bizbooktype", task.get("bizbooktype"));
                    }
                    copyTask.set("taskstatus", (Object)TaskStatusEnum.NOT_START.getType());
                    copyTask.set("seq", task.get("seq"));
                    copyTask.set("executor", (Object)task.getDynamicObject("executor"));
                    if (task.getLong("pid") != 0L) {
                        copyTask.set("startdaytime", task.get("startdaytime"));
                        copyTask.set("enddaytime", task.get("enddaytime"));
                    } else {
                        copyTask.set("startdaytime", (Object)-1);
                        copyTask.set("enddaytime", (Object)-1);
                    }
                    this.getPreTaskMapping(flow, task, preTaskMapping);
                    String key = this.getKey(task);
                    if (task.getLong("pid") == 0L) {
                        idMapping.put(key, task.getLong("id"));
                        continue;
                    }
                    pidMapping.put(key, task.getLong("pid"));
                }
                DynamicObject[] newTasks = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{copyFlow});
                if (!pidMapping.isEmpty()) {
                    DynamicObject newTask = BusinessDataServiceHelper.loadSingle((Object)newTasks[0].getPkValue(), (String)"fcc_checkout_flow_detail");
                    this.setTaskParentRelation(newTask, idMapping, pidMapping);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newTask});
                }
                if (preTaskMapping.isEmpty()) continue;
                this.copyPreTasks(preTaskMapping, newTasks[0].getPkValue());
            }
        }
    }

    private void getPreTaskMapping(DynamicObject flow, DynamicObject task, Map<String, List<String>> preTaskMapping) {
        DynamicObject preTask;
        DynamicObjectCollection entryentity;
        QFilter preTaskFilter = new QFilter("flowid", "=", (Object)flow.getLong("id"));
        preTaskFilter.and("taskrowid", "=", (Object)task.getLong("id"));
        DynamicObject[] preTasks = BusinessDataServiceHelper.load((String)"fcc_checkout_pretasks", (String)"flowid,taskrowid,entryentity.tasknumber,entryentity.ebizorg,entryentity.type,entryentity.bizbooktype", (QFilter[])new QFilter[]{preTaskFilter});
        if (preTasks.length > 0 && (entryentity = (preTask = preTasks[0]).getDynamicObjectCollection("entryentity")) != null && entryentity.size() > 0) {
            String key = this.getKey(task);
            ArrayList<String> preTaskList = new ArrayList<String>(entryentity.size());
            for (DynamicObject preTaskEntry : entryentity) {
                String value = this.getKey(preTaskEntry);
                preTaskList.add(value);
            }
            preTaskMapping.put(key, preTaskList);
        }
    }

    public String getKey(DynamicObject task) {
        long taskId = task.getLong(FCCField.id_((String)"tasknumber"));
        long ebizorgId = task.getLong(FCCField.id_((String)"ebizorg"));
        String type = task.getString("type");
        if (StringUtils.isEmpty((String)type)) {
            type = " ";
        }
        DynamicObject bizbooktype = task.getDynamicObject("bizbooktype");
        long bizbooktypeid = 0L;
        if (bizbooktype != null) {
            bizbooktypeid = bizbooktype.getLong("id");
        }
        String key = taskId + "-" + ebizorgId + "-" + type + "-" + bizbooktypeid;
        return key;
    }

    private void setTaskParentRelation(DynamicObject newTask, Map<String, Long> idMapping, Map<String, Long> pidMapping) {
        DynamicObjectCollection taskentry = newTask.getDynamicObjectCollection("taskentry");
        HashMap<String, String> relationMap = new HashMap<String, String>(taskentry.size());
        for (Map.Entry<String, Long> entry : idMapping.entrySet()) {
            String key = entry.getKey();
            long id = entry.getValue();
            for (Map.Entry<String, Long> pidEntry : pidMapping.entrySet()) {
                String key1 = pidEntry.getKey();
                long value = pidEntry.getValue();
                if (value != id) continue;
                relationMap.put(key1, key);
            }
        }
        HashMap<String, Long> map = new HashMap<String, Long>(taskentry.size());
        for (DynamicObject task : taskentry) {
            String key = this.getKey(task);
            long pid = task.getLong("id");
            if (pid == 0L) continue;
            map.put(key, pid);
        }
        for (DynamicObject task : taskentry) {
            String key = this.getKey(task);
            String paramStr = (String)relationMap.get(key);
            if (!StringUtils.isNotEmpty((String)paramStr)) continue;
            Long pid = (Long)map.get(paramStr);
            task.set("pid", (Object)pid);
        }
    }

    private void copyPreTasks(Map<String, List<String>> preTaskMapping, Object newTaskId) {
        String key;
        DynamicObject newTask = BusinessDataServiceHelper.loadSingle((Object)newTaskId, (String)"fcc_checkout_flow_detail");
        DynamicObjectCollection taskentry = newTask.getDynamicObjectCollection("taskentry");
        HashMap<String, Long> taskIdMapping = new HashMap<String, Long>(taskentry.size());
        for (DynamicObject task : taskentry) {
            if (task.getLong("pid") == 0L) continue;
            key = this.getKey(task);
            taskIdMapping.put(key, task.getLong("id"));
        }
        for (DynamicObject task : taskentry) {
            key = this.getKey(task);
            List<String> list = preTaskMapping.get(key);
            if (list == null || list.size() <= 0) continue;
            DynamicObject copyPreTask = BusinessDataServiceHelper.newDynamicObject((String)"fcc_checkout_pretasks");
            copyPreTask.set("flowid", (Object)newTask.getLong("id"));
            copyPreTask.set("taskrowid", (Object)task.getLong("id"));
            DynamicObjectCollection entryentity = copyPreTask.getDynamicObjectCollection("entryentity");
            for (String keyString : list) {
                log.info(((Object)((Object)this)).getClass().getName() + "-\u524d\u7f6e\u4efb\u52a1\u8054\u5408\u552f\u4e00\u5b57\u6bb5\uff1a" + keyString);
                DynamicObject preTaskEntry = entryentity.addNew();
                Long preTaskId = (Long)taskIdMapping.get(keyString);
                preTaskEntry.set("othertaskid", (Object)preTaskId);
                String[] split = keyString.split("-");
                log.info(((Object)((Object)this)).getClass().getName() + "-\u524d\u7f6e\u4efb\u52a1\u8054\u5408\u552f\u4e00\u5b57\u6bb5\u62c6\u5206-\u4efb\u52a1split[0]\uff1a" + split[0]);
                log.info(((Object)((Object)this)).getClass().getName() + "-\u524d\u7f6e\u4efb\u52a1\u8054\u5408\u552f\u4e00\u5b57\u6bb5\u62c6\u5206-\u4e1a\u52a1\u7ec4\u7ec7split[1]\uff1a" + split[1]);
                log.info(((Object)((Object)this)).getClass().getName() + "-\u524d\u7f6e\u4efb\u52a1\u8054\u5408\u552f\u4e00\u5b57\u6bb5\u62c6\u5206-\u7c7b\u578b(\u4e1a\u52a1\u5e94\u7528)split[2]\uff1a" + split[2]);
                log.info(((Object)((Object)this)).getClass().getName() + "-\u524d\u7f6e\u4efb\u52a1\u8054\u5408\u552f\u4e00\u5b57\u6bb5\u62c6\u5206-\u7c7b\u578bsplit[3]\uff1a" + split[3]);
                preTaskEntry.set("tasknumber", (Object)split[0]);
                preTaskEntry.set("ebizorg", (Object)split[1]);
                String type = split[2];
                if (StringUtils.isNotEmpty((String)type)) {
                    preTaskEntry.set("type", (Object)split[2]);
                    preTaskEntry.set("bizbooktype", (Object)split[3]);
                }
                preTaskEntry.set("starttime", task.get("starttime"));
                preTaskEntry.set("endtime", task.get("endtime"));
                preTaskEntry.set("startdaytime", task.get("startdaytime"));
                preTaskEntry.set("enddaytime", task.get("enddaytime"));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{copyPreTask});
        }
    }
}

