/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.business.task;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.JSONUtils;
import kd.fi.fcc.business.dto.FccServiceBizData;
import kd.fi.fcc.business.dto.FccServiceContext;
import kd.fi.fcc.business.dto.FccServiceResult;
import kd.fi.fcc.business.helper.CheckOutTaskHelper;
import kd.fi.fcc.business.helper.FccConvertHelper;
import kd.fi.fcc.common.enums.AsynchronousStatusEnum;
import kd.fi.fcc.common.enums.FccExecuteStatusEnum;
import kd.fi.fcc.common.enums.TaskStatusEnum;
import kd.fi.fcc.common.utils.HasCycleUtils;
import org.apache.commons.lang.exception.ExceptionUtils;

public class ProgramTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(ProgramTask.class);
    private static final String PARAM_INTEGRATION_CLOUD = "integrationcloud";
    private static final String PARAM_MULTI_TENANCY = "multitenancy";
    private static final String FCC_CHECKOUT_PRETASKS = "fcc_checkout_pretasks";

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u7a0b\u5e8f\u4efb\u52a1", (String)"ProgramTask_3", (String)"fi-fcc-business", (Object[])new Object[0]), null);
        int totalCount = 0;
        int successCount = 0;
        ArrayList<Integer> successRows = new ArrayList<Integer>();
        ArrayList<Integer> failedRows = new ArrayList<Integer>();
        HashMap<Integer, Map<String, Object>> dateMap = new HashMap<Integer, Map<String, Object>>(16);
        String errorMessage = "";
        try {
            List taskentryList = (List)params.get("dynamicObjects");
            List<Map> sortedTaskEntryList = this.sortTaskEntry(taskentryList);
            this.logInfo("taskentry:" + JSONUtils.toString(sortedTaskEntryList));
            int rowNum = -1;
            totalCount = sortedTaskEntryList.size();
            if (CollectionUtils.isNotEmpty(sortedTaskEntryList)) {
                int progress = 0;
                int time = totalCount;
                for (int i = 0; i < time; ++i) {
                    Map map;
                    Map<String, Object> businessMap;
                    ++successCount;
                    long nextTime = i + 1;
                    String desc = String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u8fdb\u884c\u7b2c%1$s / %2$s\u6b21\u540c\u6b65", (String)"ProgramTask_4", (String)"fi-fcc-business", (Object[])new Object[0]), nextTime, time);
                    progress = 100 * i / time;
                    this.feedbackProgress(progress, desc, null);
                    if (this.isStop()) {
                        this.stop();
                    }
                    if (null == (businessMap = this.doExecuteBusiness(map = sortedTaskEntryList.get(i)))) continue;
                    String result = (String)businessMap.getOrDefault("returnResult", "success");
                    rowNum = (Integer)map.get("rowNum");
                    dateMap.put(rowNum, businessMap);
                    if (result.equals("success")) {
                        successRows.add(rowNum);
                        continue;
                    }
                    if (!result.equals("failed")) continue;
                    failedRows.add(rowNum);
                }
            }
        }
        catch (KDBizException kdBizException) {
            this.logError("ProgramTask execute occur kdBizException, error info:" + ExceptionUtils.getFullStackTrace((Throwable)kdBizException));
            errorMessage = kdBizException.getMessage();
        }
        catch (Exception e) {
            this.logError("ProgramTask execute occur exception, error info:" + ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        this.feedbackResult(totalCount, successCount, successRows, failedRows, errorMessage, dateMap);
    }

    private void feedbackResult(int totalCount, int successCount, List<Integer> successRows, List<Integer> failedRows, String errorMessage, Map<Integer, Map<String, Object>> dateMap) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("successCount", successCount);
        result.put("failureCount", totalCount - successCount);
        result.put("successRows", successRows);
        result.put("failedRows", failedRows);
        result.put("errorMessage", errorMessage);
        result.put("dateMap", dateMap);
        this.feedbackCustomdata(result);
    }

    private void logInfo(String infoLog) {
        if (log.isInfoEnabled()) {
            log.info(infoLog);
        }
    }

    private void logError(String errorLog) {
        if (log.isErrorEnabled()) {
            log.error(errorLog);
        }
    }

    private void logDebug(String debugLog) {
        if (log.isDebugEnabled()) {
            log.debug(debugLog);
        }
    }

    private Map<String, Object> doExecuteBusiness(Map taskentry) throws IOException {
        HashMap<String, Object> returnMap = new HashMap<String, Object>(16);
        Boolean isAsynchronous = false;
        String returnResult = "success";
        Long entryId = (Long)taskentry.get("entryId");
        Date currentDate = new Date(System.currentTimeMillis());
        ArrayList<Map<String, Object>> logsList = new ArrayList<Map<String, Object>>(2);
        try {
            DynamicObjectCollection preTaskCollection;
            Date startTime = new Date();
            returnMap.put("startTime", startTime);
            Object trueStartTime = taskentry.get("truestarttime");
            if (null == trueStartTime) {
                CheckOutTaskHelper.writeTaskFlowStatus(entryId, TaskStatusEnum.DOING.getType(), startTime, null);
            } else {
                CheckOutTaskHelper.writeTaskFlowStatus(entryId, TaskStatusEnum.DOING.getType(), null, null);
            }
            Long taskId = (Long)taskentry.get("taskId");
            String eorg = (String)taskentry.get("eorg");
            Long eBizOrgId = Long.valueOf(taskentry.get("ebizorgid").toString());
            String ebizorg = (String)taskentry.get("ebizorg");
            String group = (String)taskentry.get("group");
            String bizid = StringUtils.equals((CharSequence)"KDIERP", (CharSequence)group) ? (String)taskentry.get("kdbizid") : (String)taskentry.get("bizid");
            String bizbooktype = (String)taskentry.get("bizbooktype");
            String startDate = (String)taskentry.get("startdate");
            String endDate = (String)taskentry.get("enddate");
            String periodName = (String)taskentry.get("periodname");
            Long checkFlowId = (Long)taskentry.get("checkoutflowid");
            QFilter qFilter1 = new QFilter("taskrowid", "=", (Object)entryId);
            QFilter qFilter2 = new QFilter("flowid", "=", (Object)checkFlowId);
            DynamicObject preTask = BusinessDataServiceHelper.loadSingle((String)FCC_CHECKOUT_PRETASKS, (String)"taskrowid, entryentity, entryentity.othertaskid", (QFilter[])new QFilter[]{qFilter1, qFilter2});
            Boolean exitsPreTaskNotDone = false;
            if (null != preTask && null != (preTaskCollection = preTask.getDynamicObjectCollection("entryentity")) && preTaskCollection.size() > 0) {
                ArrayList<Long> preIdList = new ArrayList<Long>(1);
                for (Object task : preTaskCollection) {
                    Long preId = task.getLong("othertaskid");
                    preIdList.add(preId);
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("(");
                for (Long id : preIdList) {
                    stringBuilder.append(id).append(",");
                }
                stringBuilder.deleteCharAt(stringBuilder.length() - 1).append(")");
                String sqlInStr = stringBuilder.toString();
                String sql = "SELECT ftaskstatus FROM t_fcc_checkflow_det_entry WHERE fentryid in " + sqlInStr;
                try (DataSet status = DB.queryDataSet((String)"ProgramTask.doExecuteBusiness", (DBRoute)DBRoute.of((String)"fi"), (String)sql);){
                    for (Row data : status) {
                        String ftaskstatus = (String)data.get("ftaskstatus");
                        if (StringUtils.equals((CharSequence)TaskStatusEnum.DONE.getType(), (CharSequence)ftaskstatus)) continue;
                        exitsPreTaskNotDone = true;
                        break;
                    }
                }
            }
            if (exitsPreTaskNotDone.booleanValue()) {
                return null;
            }
            QFilter qFilter = new QFilter("id", "=", (Object)taskId);
            DynamicObject fcc_checkout_task = BusinessDataServiceHelper.loadSingleFromCache((String)"fcc_checkout_task", (String)"id,entryentity,entryentity.service,entryentity.preservice,entryentity.service.serviceinterface,entryentity.service.servicemethod,entryentity.service.paramentry,entryentity.service.paramentry.datatype,entryentity.service.paramentry.paramnumber,entryentity.service.paramentry.bizapp,entryentity.service.paramentry.bizcloud,entryentity.service.enable,entryentity.service.paramentry.datatype,entryentity.service.paramentry.paramnumber,entryentity.service.number,entryentity.service.servicetype,entryentity.service.srcsys,entryentity.service.isasynchronous,entryentity.service.isvid", (QFilter[])new QFilter[]{qFilter});
            DynamicObjectCollection entryentity = fcc_checkout_task.getDynamicObjectCollection("entryentity");
            List<DynamicObject> sortedServices = this.sortServices(entryentity);
            for (DynamicObject row : sortedServices) {
                DynamicObject service = row.getDynamicObject("service");
                String enable = row.getString("service.enable");
                Long serviceId = service.getLong("id");
                String serviceinterface = service.getString("serviceinterface");
                String servicemethod = service.getString("servicemethod");
                String appId = service.getString("bizapp.number");
                String cloudId = service.getString("bizcloud.number");
                String number = service.getString("number");
                String serviceType = service.getString("servicetype");
                String srcSys = service.getString("srcsys.number");
                Boolean asynchronous = service.getBoolean("isasynchronous");
                String isvId = service.getString("isvid");
                if (asynchronous.booleanValue()) {
                    isAsynchronous = asynchronous;
                }
                FccServiceBizData fccServiceBizData = new FccServiceBizData();
                fccServiceBizData.setBizOrg(ebizorg);
                fccServiceBizData.setAppId(bizid.toLowerCase());
                fccServiceBizData.setEndDate(endDate);
                fccServiceBizData.setStartDate(startDate);
                fccServiceBizData.setFinOrg(eorg);
                fccServiceBizData.setPeriodName(periodName);
                fccServiceBizData.setSubAppId(bizbooktype);
                FccServiceContext fccServiceContext = new FccServiceContext();
                String UUIDStr = UUID.randomUUID().toString();
                fccServiceContext.setNonce(UUIDStr);
                fccServiceContext.setServicesId(service.getLong("id"));
                fccServiceContext.setPlanExecuteTaskId(taskId);
                HashMap<String, Object> paramMaps = new HashMap<String, Object>();
                paramMaps.put("fccServiceContext", fccServiceContext);
                paramMaps.put("bizData", fccServiceBizData);
                DynamicObjectCollection paramentry = service.getDynamicObjectCollection("paramentry");
                for (DynamicObject subRow : paramentry) {
                    String datatype = subRow.getString("datatype");
                    String paramnumber = subRow.getString("paramnumber");
                    String paramdefault = subRow.getString("paramdefault");
                    Object paramdefaultObj = null;
                    switch (datatype) {
                        case "string": {
                            paramdefaultObj = paramdefault;
                            break;
                        }
                        case "int": {
                            paramdefaultObj = Integer.valueOf(paramdefault);
                            break;
                        }
                        case "long": {
                            paramdefaultObj = Long.valueOf(paramdefault);
                            break;
                        }
                        case "datetime": {
                            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                            Date date = format.parse(paramdefault);
                            paramdefaultObj = date;
                            break;
                        }
                        case "stringArr": {
                            String[] strArr;
                            if (StringUtils.isNotBlank((CharSequence)paramdefault)) {
                                strArr = paramdefault.split(",");
                                List paramList = Arrays.stream(strArr).collect(Collectors.toList());
                                paramdefaultObj = paramList;
                                break;
                            }
                            paramdefaultObj = strArr = new String[0];
                            break;
                        }
                        default: {
                            paramdefaultObj = paramdefault;
                        }
                    }
                    paramMaps.put(paramnumber, paramdefaultObj);
                }
                Date serviceStartDate = new Date(System.currentTimeMillis());
                FccServiceResult result = new FccServiceResult();
                if (enable.equals("0")) {
                    String localeValue = ((OrmLocaleValue)row.get("service.name")).getLocaleValue();
                    String taskMessage = String.format(ResManager.loadKDString((String)"\u96c6\u6210\u670d\u52a1\u2018%1$s\u2019\u5df2\u7981\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u7a0b\u5e8f\u96c6\u6210\u670d\u52a1\u914d\u7f6e\u3002", (String)"ProgramTask_2", (String)"fi-fcc-business", (Object[])new Object[0]), localeValue);
                    result.setMessage(taskMessage);
                    result.setStatus(FccExecuteStatusEnum.ERROR.getType());
                } else {
                    try {
                        result = this.executeServiceItem(cloudId.toLowerCase(), appId.toLowerCase(), serviceinterface, servicemethod, srcSys, serviceType, number, eBizOrgId, isvId, paramMaps);
                        log.info("executeItemResult:" + result.toString());
                    }
                    catch (KDBizException KDe) {
                        result.setMessage(KDe.getMessage());
                        result.setStatus(FccExecuteStatusEnum.ERROR.getType());
                        this.logError("executeItemResult: exist Exception" + KDe.getMessage());
                    }
                    catch (Exception e) {
                        result.setMessage(ExceptionUtils.getFullStackTrace((Throwable)e));
                        result.setStatus(FccExecuteStatusEnum.ERROR.getType());
                        this.logError("executeItemResult: exist Exception" + ExceptionUtils.getFullStackTrace((Throwable)e));
                    }
                }
                Date serviceEndDate = new Date(System.currentTimeMillis());
                HashMap<String, Object> logsMap = new HashMap<String, Object>();
                logsMap.put("serviceId", serviceId);
                logsMap.put("startDate", serviceStartDate);
                logsMap.put("asynchronous", asynchronous);
                logsMap.put("endDate", serviceEndDate);
                logsMap.put("result", result);
                logsMap.put("UUID", UUIDStr);
                logsList.add(logsMap);
                if (result.getStatus().equals(FccExecuteStatusEnum.PASS.getType())) continue;
                Date endTime = new Date();
                returnMap.put("endTime", endTime);
                CheckOutTaskHelper.writeTaskFlowStatus(entryId, TaskStatusEnum.FAILED.getType(), null, null);
                returnResult = "failed";
                returnMap.put("returnResult", returnResult);
                this.writeTaskLog(taskentry, logsList, returnResult, currentDate, null);
                return returnMap;
            }
            this.writeTaskLog(taskentry, logsList, returnResult, currentDate, null);
            Date endTime = new Date();
            returnMap.put("endTime", endTime);
            if (!isAsynchronous.booleanValue()) {
                CheckOutTaskHelper.writeTaskFlowStatus(entryId, TaskStatusEnum.DONE.getType(), null, endTime);
            }
        }
        catch (Exception e) {
            Date endTime = new Date();
            returnMap.put("endTime", endTime);
            CheckOutTaskHelper.writeTaskFlowStatus(entryId, TaskStatusEnum.FAILED.getType(), null, null);
            returnResult = "failed";
            returnMap.put("returnResult", returnResult);
            this.writeTaskLog(taskentry, logsList, returnResult, currentDate, ExceptionUtils.getFullStackTrace((Throwable)e).substring(0, 255));
            this.logError("ProgramTask execute occur exception, error info:" + ExceptionUtils.getFullStackTrace((Throwable)e));
            return returnMap;
        }
        returnMap.put("returnResult", returnResult);
        return returnMap;
    }

    private FccServiceResult executeServiceItem(String cloudId, String applid, String serviceName, String methodName, String srcSys, String serviceType, String number, Long eBizOrgId, String isvId, Map<String, Object> paramMaps) throws IOException {
        log.info("ProgramTask executeServiceItem cloudId={},applid={},serviceName={},methodName={}, paramMapsJson={}", new Object[]{cloudId, applid, serviceName, methodName, SerializationUtils.toJsonString(paramMaps)});
        AppParam param = new AppParam("44W6RTUA4SKG", eBizOrgId);
        Object integrationCloud = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)PARAM_INTEGRATION_CLOUD);
        FccServiceResult fccServiceResult = new FccServiceResult();
        HashMap<String, Object> resultMap = new HashMap(1);
        if (StringUtils.equalsIgnoreCase((CharSequence)"KDIERP", (CharSequence)srcSys) && StringUtils.equalsIgnoreCase((CharSequence)"2", (CharSequence)serviceType)) {
            String factoryQualifiedPrefix = isvId + "." + cloudId + "." + applid;
            resultMap = (Map)DispatchServiceHelper.invokeService((String)factoryQualifiedPrefix, (String)applid, (String)serviceName, (String)methodName, (Object[])new Object[]{paramMaps});
            fccServiceResult = FccConvertHelper.mapConvertToResult(resultMap);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"KDIERP", (CharSequence)srcSys) && StringUtils.equalsIgnoreCase((CharSequence)"1", (CharSequence)serviceType)) {
            resultMap = (Map)DispatchServiceHelper.invokeBizService((String)cloudId, (String)applid, (String)serviceName, (String)methodName, (Object[])new Object[]{paramMaps});
            fccServiceResult = FccConvertHelper.mapConvertToResult(resultMap);
        } else if (!StringUtils.equalsIgnoreCase((CharSequence)"KDIERP", (CharSequence)srcSys) && null != integrationCloud && ((Boolean)integrationCloud).booleanValue() && StringUtils.equalsIgnoreCase((CharSequence)"EIP", (CharSequence)cloudId) && StringUtils.equalsIgnoreCase((CharSequence)"iscb", (CharSequence)applid)) {
            cloudId = "isc";
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(1);
            list.add(paramMaps);
            JSONObject apiResult = (JSONObject)DispatchServiceHelper.invokeBizService((String)cloudId, (String)applid, (String)serviceName, (String)methodName, (Object[])new Object[]{number, list.toArray(), ""});
            fccServiceResult = FccConvertHelper.jsonConvertToResult(apiResult);
            log.info("fccServiceResult is:" + fccServiceResult);
        } else {
            fccServiceResult.setStatus(FccExecuteStatusEnum.ERROR.getType());
            fccServiceResult.setMessage(ResManager.loadKDString((String)"\u5f53\u524d\u670d\u52a1\u4e0d\u53ef\u6267\u884c\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u7ed3\u8d26\u96c6\u6210\u914d\u7f6e\u3002", (String)"ProgramTask_5", (String)"fi-fcc-business", (Object[])new Object[0]));
        }
        return fccServiceResult;
    }

    private void writeTaskLog(Map taskentry, List<Map<String, Object>> logsList, String result, Date currentDate, String exceptionStr) {
        ArrayList<Long> serviceIdList = new ArrayList<Long>(2);
        DynamicObject taskLog = BusinessDataServiceHelper.newDynamicObject((String)"fcc_execute_task_log");
        Long entryId = (Long)taskentry.get("entryId");
        taskLog.set("checkflowdetail", (Object)entryId);
        Long checkFlowId = (Long)taskentry.get("checkoutflowid");
        DynamicObject checkFlow = BusinessDataServiceHelper.loadSingle((String)"fcc_checkout_flow_detail", (String)"plan.id,org.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)checkFlowId)});
        Long checkPlanId = checkFlow.getLong("plan.id");
        taskLog.set("checkoutplan", (Object)checkPlanId);
        Long eOrgId = Long.valueOf(taskentry.get("eorgid").toString());
        taskLog.set("eorg", (Object)eOrgId);
        Long checkTaskId = (Long)taskentry.get("taskId");
        taskLog.set("checkouttask", (Object)checkTaskId);
        Long eBizOrgId = Long.valueOf(taskentry.get("ebizorgid").toString());
        taskLog.set("ebizorg", (Object)eBizOrgId);
        String type = (String)taskentry.get("type");
        taskLog.set("type", (Object)type);
        String bizBookType = (String)taskentry.get("bizbooktype");
        if (null != bizBookType) {
            taskLog.set("bizbooktype", (Object)Long.valueOf(bizBookType));
        }
        String taskMessage = "";
        if (result.equals("success")) {
            taskLog.set("taskstatus", (Object)FccExecuteStatusEnum.PASS.getType());
            taskLog.set("taskmessage", (Object)taskMessage);
        }
        taskLog.set("startdate", (Object)currentDate);
        Date endDate = new Date(System.currentTimeMillis());
        taskLog.set("enddate", (Object)endDate);
        DynamicObjectCollection logEntity = taskLog.getDynamicObjectCollection("entryentity");
        if (null != logsList && logsList.size() > 0) {
            for (Map<String, Object> logMap : logsList) {
                serviceIdList.add((Long)logMap.get("serviceId"));
            }
            Map services = BusinessDataServiceHelper.loadFromCache((String)"fcc_checkout_integration", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", serviceIdList)});
            for (Map<String, Object> logMap : logsList) {
                String serviceName;
                String message;
                DynamicObject newLog = logEntity.addNew();
                Object serviceId = logMap.get("serviceId");
                newLog.set("service", logMap.get("serviceId"));
                FccServiceResult serviceResult = (FccServiceResult)logMap.get("result");
                String status = serviceResult.getStatus();
                String string = message = serviceResult.getMessage() != null ? serviceResult.getMessage() : "";
                if (StringUtils.equals((CharSequence)status, (CharSequence)FccExecuteStatusEnum.PASS.getType())) {
                    newLog.set("servicestatus", (Object)TaskStatusEnum.DONE.getType());
                    newLog.set("servicemessage", (Object)ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u5b8c\u6210", (String)"ProgramTask_6", (String)"fi-fcc-business", (Object[])new Object[0]));
                } else if (StringUtils.equals((CharSequence)status, (CharSequence)FccExecuteStatusEnum.WARN.getType())) {
                    newLog.set("servicestatus", (Object)TaskStatusEnum.WARN.getType());
                    serviceName = services.get(serviceId) != null ? ((DynamicObject)services.get(serviceId)).getString("name") + "\uff1a" : "";
                    taskMessage = serviceName + message;
                } else {
                    newLog.set("servicestatus", (Object)TaskStatusEnum.FAILED.getType());
                    serviceName = services.get(serviceId) != null ? ((DynamicObject)services.get(serviceId)).getString("name") + "\uff1a" : "";
                    taskMessage = serviceName + message;
                }
                Boolean asynchronous = (Boolean)logMap.get("asynchronous");
                if (null != asynchronous && asynchronous.booleanValue()) {
                    newLog.set("asynchronousstatus", (Object)AsynchronousStatusEnum.SEND.getType());
                }
                if (message.length() > 255) {
                    newLog.set("servicemessage", (Object)ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u5931\u8d25", (String)"ProgramTask_7", (String)"fi-fcc-business", (Object[])new Object[0]));
                } else {
                    newLog.set("servicemessage", (Object)message);
                }
                newLog.set("servicemessage_tag", (Object)message);
                newLog.set("traceid", (Object)((String)logMap.get("UUID")));
                newLog.set("servicestartdate", (Object)((Date)logMap.get("startDate")));
                newLog.set("serviceenddate", (Object)((Date)logMap.get("endDate")));
            }
        }
        if (StringUtils.isBlank((CharSequence)taskLog.getString("taskstatus"))) {
            taskLog.set("taskstatus", (Object)FccExecuteStatusEnum.ERROR.getType());
            taskLog.set("taskmessage", (Object)(taskMessage.length() > 255 ? ResManager.loadKDString((String)"\u7a0b\u5e8f\u6267\u884c\u9519\u8bef\uff01", (String)"ProgramTask_8", (String)"fi-fcc-business", (Object[])new Object[0]) : taskMessage));
        }
        if (null != exceptionStr && StringUtils.isBlank((CharSequence)taskMessage)) {
            taskLog.set("taskmessage", (Object)exceptionStr);
        }
        taskLog.set("entryentity", (Object)logEntity);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskLog});
    }

    private List<DynamicObject> sortServices(DynamicObjectCollection entryentity) {
        HashMap serviceMap = new HashMap(1);
        HashMap<Long, DynamicObject> serviceObjMap = new HashMap<Long, DynamicObject>(1);
        ArrayList<DynamicObject> sortedList = new ArrayList<DynamicObject>(1);
        for (DynamicObject serviceEn : entryentity) {
            DynamicObject service = serviceEn.getDynamicObject("service");
            if (null == service) continue;
            Long serviceId = service.getLong("id");
            serviceObjMap.put(serviceId, serviceEn);
            MulBasedataDynamicObjectCollection preServices = (MulBasedataDynamicObjectCollection)serviceEn.get("preservice");
            ArrayList<Long> preServiceList = new ArrayList<Long>(1);
            if (null != preServices && preServices.size() > 0) {
                for (DynamicObject preService : preServices) {
                    Long preServiceId = preService.getLong("fbasedataid_id");
                    preServiceList.add(preServiceId);
                }
            }
            serviceMap.put(serviceId, preServiceList);
        }
        ArrayList sortedService = new ArrayList(1);
        HashSet visited = new HashSet();
        for (Long serviceId : serviceMap.keySet()) {
            if (visited.contains(serviceId)) continue;
            HasCycleUtils.dfs((Long)serviceId, visited, serviceMap, sortedService);
        }
        for (Long sortId : sortedService) {
            sortedList.add((DynamicObject)serviceObjMap.get(sortId));
        }
        return sortedList;
    }

    private List<Map> sortTaskEntry(List<Map> taskEntryList) {
        HashMap preTaskMap = new HashMap(1);
        ArrayList<Map> sortedTask = new ArrayList<Map>(1);
        ArrayList sortedTaskId = new ArrayList(1);
        HashSet visited = new HashSet();
        HashMap<Long, Map> taskIdMap = new HashMap<Long, Map>(1);
        HashSet<Long> flowIdSet = new HashSet<Long>(1);
        ArrayList<Long> taskIdList = new ArrayList<Long>(1);
        for (Map taskEntry : taskEntryList) {
            Long taskEnId = (Long)taskEntry.get("entryId");
            taskIdList.add(taskEnId);
            taskIdMap.put(taskEnId, taskEntry);
            Long checkFlowId = (Long)taskEntry.get("checkoutflowid");
            flowIdSet.add(checkFlowId);
        }
        QFilter qFilter = new QFilter("flowid", "in", flowIdSet);
        DynamicObject[] preTasks = BusinessDataServiceHelper.load((String)FCC_CHECKOUT_PRETASKS, (String)"taskrowid, entryentity, entryentity.othertaskid", (QFilter[])new QFilter[]{qFilter});
        if (null != preTasks && preTasks.length > 0) {
            for (DynamicObject preTaskObj : preTasks) {
                Long taskRowId = preTaskObj.getLong("taskrowid");
                if (!taskIdList.contains(taskRowId)) continue;
                DynamicObjectCollection preTaskCollection = preTaskObj.getDynamicObjectCollection("entryentity");
                ArrayList<Long> preTaskList = new ArrayList<Long>(1);
                for (DynamicObject preTask : preTaskCollection) {
                    Long preTaskId = preTask.getLong("othertaskid");
                    preTaskList.add(preTaskId);
                }
                if (null == preTaskList || preTaskList.size() <= 0) continue;
                preTaskMap.put(taskRowId, preTaskList);
            }
        }
        if (null != preTaskMap && preTaskMap.size() > 0) {
            for (Long serviceId : preTaskMap.keySet()) {
                if (visited.contains(serviceId)) continue;
                HasCycleUtils.dfs((Long)serviceId, visited, preTaskMap, sortedTaskId);
            }
            for (Long sortId : sortedTaskId) {
                if (!taskIdList.contains(sortId)) continue;
                sortedTask.add((Map)taskIdMap.get(sortId));
            }
            for (Long sortId : taskIdList) {
                if (sortedTaskId.contains(sortId)) continue;
                sortedTask.add((Map)taskIdMap.get(sortId));
            }
            return sortedTask;
        }
        return taskEntryList;
    }
}

