/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.business.task;

import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.AbstractTaskClick;
import kd.bos.schedule.form.event.ClickEventArgs;
import kd.bos.schedule.form.event.ItemClickEventArgs;

public class ProgramTaskClick
extends AbstractTaskClick {
    public void click(ClickEventArgs e) {
        super.click(e);
        TaskInfo taskInfo = this.queryTask();
        IFormView mainView = this.getMainView();
        IFormView parentView = this.getParentView();
        if (taskInfo.isTaskEnd()) {
            e.setClearTask(true);
            String data = taskInfo.getData();
            if (StringUtils.isNotEmpty((CharSequence)data)) {
                JSONObject dataObj = (JSONObject)SerializationUtils.fromJsonString((String)data, JSONObject.class);
                int successCount = dataObj.getIntValue("successCount");
                int failureCount = dataObj.getIntValue("failureCount");
                String message = String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u5904\u7406\u5355\u636e\u53f7\u540c\u6b65\u5b8c\u6210\uff0c%1$s\u6761\u6210\u529f\uff0c%2$s\u6761\u5931\u8d25", (String)"ProgramTaskClick_0", (String)"fi-fcc-business", (Object[])new Object[0]), successCount, failureCount);
                mainView.showMessage(message);
            }
        } else if (parentView == null) {
            mainView.showMessage(ResManager.loadKDString((String)"\u542f\u52a8\u4efb\u52a1\u7684\u9875\u9762\u5df2\u7ecf\u5173\u95ed\uff0c\u4e0d\u80fd\u518d\u6253\u5f00\u8fdb\u5ea6\u754c\u9762", (String)"ProgramTaskClick_1", (String)"fi-fcc-business", (Object[])new Object[0]));
        } else {
            this.showProgressForm(parentView);
        }
    }

    public void itemClick(ItemClickEventArgs e) {
    }

    private void showProgressForm(IFormView view) {
        if (this.isExistProgressForm()) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("sch_taskprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (StringUtils.isBlank((CharSequence)this.getJobFormInfo().getCaption())) {
            showParameter.setCaption(this.getJobFormInfo().getCaption());
        }
        showParameter.getCustomParams().put("ServiceAppId", this.getJobFormInfo().getJobInfo().getAppId());
        String jobInfoStr = SerializationUtils.toJsonString((Object)this.getJobFormInfo());
        showParameter.getCustomParams().put("sch_clientjobinfo", jobInfoStr);
        showParameter.getCustomParams().put("sch_taskid", this.getTaskId());
        showParameter.setCloseCallBack(this.getJobFormInfo().getCloseCallBack());
        view.showForm(showParameter);
        this.getMainView().sendFormAction(view);
        this.setProgressPageId(showParameter.getPageId());
    }

    public boolean release() {
        return true;
    }
}

