/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.business.task;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.util.DateUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.fcc.common.enums.CheckoutCycleEnum;
import kd.fi.fcc.common.enums.CheckoutPlanStatusEnum;
import kd.fi.fcc.common.enums.TaskStatusEnum;
import kd.fi.fcc.common.enums.TaskTypeEnum;
import kd.fi.fcc.common.utils.CheckOutViewUtil;
import kd.fi.fcc.common.utils.FccUtil;

public class TaskDoingTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(TaskDoingTask.class);
    private static final String MANUAL_TASK = "manualtask";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        long orgId = OrgUnitServiceHelper.getRootOrgId();
        AppParam param = new AppParam("44W6RTUA4SKG", Long.valueOf(orgId));
        Boolean manualTask = (Boolean)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)MANUAL_TASK);
        if (manualTask == null || !manualTask.booleanValue()) {
            return;
        }
        Date currentDate = DateUtils.getCurrentDate();
        QFilter planFilter = new QFilter("planstatus", "=", (Object)CheckoutPlanStatusEnum.RELEASE.getType());
        planFilter.and("method", "=", (Object)CheckoutCycleEnum.MONTH_END.getValue());
        Date currentMonth = this.getCurrentMonth(currentDate);
        Date lastMonth = this.getLastMonth(currentMonth);
        planFilter.and("month", "in", (Object)new Date[]{currentMonth, lastMonth});
        Map plans = BusinessDataServiceHelper.loadFromCache((String)"fcc_checkout_plan", (String)"id, planstatus, startdate,enddate", (QFilter[])new QFilter[]{planFilter});
        if (plans == null || plans.size() == 0) {
            return;
        }
        Set planIds = plans.keySet();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        for (Object planId : planIds) {
            long view = CheckOutViewUtil.getView((Long)((Long)planId));
            List allLeafOrgIds = CheckOutViewUtil.getAllLeaveOrgs((Long)view);
            QFilter flowFilter = new QFilter("plan", "=", planId);
            flowFilter.and("org", "in", (Object)allLeafOrgIds);
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"fcc_checkout_flow_detail", (String)"id,plan,taskentry.tasknumber,taskentry.taskstatus,taskentry.starttime,taskentry.endtime", (QFilter[])new QFilter[]{flowFilter});
            if (load == null || load.length == 0) continue;
            for (DynamicObject flow : load) {
                DynamicObjectCollection tasks = flow.getDynamicObjectCollection("taskentry");
                if (tasks == null || tasks.size() == 0) continue;
                for (DynamicObject task : tasks) {
                    String taskStatus = task.getString("taskstatus");
                    Date startDate = task.getDate("starttime");
                    DynamicObject taskDynamicObject = task.getDynamicObject("tasknumber");
                    if (!taskDynamicObject.getString("tasktype").equals(TaskTypeEnum.MANUAL_TASKS.getType()) || !TaskStatusEnum.NOT_START.getType().equals(taskStatus) || !FccUtil.isSameDay((DateFormat)dateFormat, (Date)currentDate, (Date)startDate).booleanValue()) continue;
                    task.set("taskstatus", (Object)TaskStatusEnum.DOING.getType());
                }
            }
            SaveServiceHelper.save((DynamicObject[])load);
        }
    }

    private Date getCurrentMonth(Date currentDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(currentDate);
        cal.set(5, 1);
        return cal.getTime();
    }

    private Date getLastMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, -1);
        return cal.getTime();
    }
}

