/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.mservice.helper;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.util.PeriodUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class FccFinancialQueryServiceHelper {
    private static final Log log = LogFactory.getLog(FccFinancialQueryServiceHelper.class);

    public static Long getBizOrg(String orgNum) {
        Long bizOrgId = 0L;
        QFilter[] qFilters = new QFilter[]{new QFilter("number", "=", (Object)orgNum)};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])qFilters);
        if (null == dynamicObject) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a", (String)"FccFinancialQueryServiceHelper_3", (String)"fi-fcc-mservice", (Object[])new Object[0]));
        }
        bizOrgId = dynamicObject.getLong("id");
        return bizOrgId;
    }

    public static Long getPeriodId(Long periodTypeId, String periodName) throws KDBizException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        int year = 0;
        int periodNum = 0;
        Long periodId = 0L;
        try {
            Date date = sdf.parse(periodName);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            year = calendar.get(1);
            periodNum = calendar.get(2) + 1;
            if (null == periodTypeId) {
                throw new KDBizException(ResManager.loadKDString((String)"\u671f\u95f4\u67e5\u8be2\u8f6c\u6362\u9519\u8bef\uff0c\u671f\u95f4\u201c%s\u201d\u7c7b\u578bId\u4e3a\u7a7a\u3002", (String)"FccFinancialQueryServiceHelper_2", (String)periodName, (Object[])new Object[]{"fi-fcc-mservice"}));
            }
            periodId = PeriodUtil.getPkId((int)periodTypeId.intValue(), (int)year, (int)periodNum, (boolean)false);
        }
        catch (ParseException | KDBizException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u671f\u95f4\u67e5\u8be2\u8f6c\u6362\u9519\u8bef %s ", (String)"FccFinancialQueryServiceHelper_1", (String)periodName, (Object[])new Object[]{"fi-fcc-mservice"}));
        }
        return periodId;
    }
}

