/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.mservice.impl;

import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.fcc.business.dto.FccServiceCallBackParam;
import kd.fi.fcc.business.dto.FccServiceContext;
import kd.fi.fcc.business.dto.FccServiceResult;
import kd.fi.fcc.business.helper.CheckOutTaskHelper;
import kd.fi.fcc.business.helper.FccExecuteTaskLogHelper;
import kd.fi.fcc.common.enums.FccExecuteStatusEnum;
import kd.fi.fcc.common.enums.TaskStatusEnum;
import kd.fi.fcc.mservice.api.FccCallBackService;
import kd.fi.fcc.mservice.impl.FccCheckItemServiceImpl;

public class FccCallBackServiceImpl
implements FccCallBackService {
    private static final Log LOG = LogFactory.getLog(FccCheckItemServiceImpl.class);

    public String executeServiceCallBack(FccServiceCallBackParam fccServiceCallBackParam) {
        FccServiceResult fccServiceResult = fccServiceCallBackParam.getFccServiceResult();
        FccServiceContext fccServiceContext = fccServiceCallBackParam.getFccServiceContext();
        Date resDate = new Date();
        String serviceStatus = fccServiceResult.getStatus();
        FccExecuteStatusEnum fccExecuteStatusEnum = FccExecuteStatusEnum.getCallType((String)serviceStatus);
        Long checkflowdetail = fccServiceContext.getPlanExecuteTaskId();
        Long serviceId = fccServiceContext.getServicesId();
        String nonce = fccServiceContext.getNonce();
        String serviceMessage = fccServiceResult.getMessage();
        try {
            switch (fccExecuteStatusEnum) {
                case ERROR: {
                    CheckOutTaskHelper.writeTaskFlowStatus((Long)checkflowdetail, (String)TaskStatusEnum.FAILED.getType(), null, (Date)resDate);
                    FccExecuteTaskLogHelper.writeTaskLogEntry((Long)checkflowdetail, (Long)serviceId, (String)nonce, (String)fccExecuteStatusEnum.getType(), (String)fccExecuteStatusEnum.getType(), null, (Date)resDate, (String)serviceMessage);
                    break;
                }
                case WARN: {
                    CheckOutTaskHelper.writeTaskFlowStatus((Long)checkflowdetail, (String)TaskStatusEnum.FAILED.getType(), null, (Date)resDate);
                    FccExecuteTaskLogHelper.writeTaskLogEntry((Long)checkflowdetail, (Long)serviceId, (String)nonce, (String)fccExecuteStatusEnum.getType(), (String)fccExecuteStatusEnum.getType(), null, (Date)resDate, (String)serviceMessage);
                    break;
                }
                case PASS: {
                    CheckOutTaskHelper.writeTaskFlowStatus((Long)checkflowdetail, (String)TaskStatusEnum.DONE.getType(), null, (Date)resDate);
                    FccExecuteTaskLogHelper.writeTaskLogEntry((Long)checkflowdetail, (Long)serviceId, (String)nonce, (String)fccExecuteStatusEnum.getType(), (String)fccExecuteStatusEnum.getType(), null, (Date)resDate, (String)serviceMessage);
                }
            }
            return FccExecuteStatusEnum.PASS.getName();
        }
        catch (KDBizException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u670d\u52a1\u56de\u5199\u9519\u8bef\uff01 ", (String)"FccCallBackServiceImpl_0", (String)"fi-fcc-mservice", (Object[])new Object[0]));
        }
    }
}

