/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.mservice.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.fcc.business.dto.FccServiceBizData;
import kd.fi.fcc.common.enums.FccExecuteStatusEnum;
import kd.fi.fcc.mservice.api.FccCheckItemService;
import kd.fi.fcc.mservice.api.FccFinancialQueryService;
import kd.fi.fcc.mservice.dto.ext.CheckExecutionResult;
import kd.fi.fcc.mservice.dto.ext.CheckItemExecutionParam;
import kd.fi.fcc.mservice.helper.FccFinancialQueryServiceHelper;
import kd.fi.fcc.mservice.impl.FccFinancialQueryServiceImpl;
import kd.fi.fcc.mservice.tools.BizTransferUtil;

public class FccCheckItemServiceImpl
implements FccCheckItemService {
    private static final Log log = LogFactory.getLog(FccCheckItemServiceImpl.class);
    private static final FccFinancialQueryService fccFinancialQueryService = new FccFinancialQueryServiceImpl();
    public static final String SERVICE_NAME = "CheckItemExecuteCallBackService";
    public static final String SERVICE_METHOD = "executeCheckItems";
    private static final String APP_ID = "gl";
    private static final String CLOUD_ID = "fi";

    public Map<String, Object> executeCheck(Map<String, Object> fccServiceParam) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(1);
        String msg = "";
        String status = "";
        try {
            FccServiceBizData fccServiceBizData = (FccServiceBizData)fccServiceParam.get("bizData");
            String checkItem = (String)fccServiceParam.get("checkItem");
            String bizApplCode = BizTransferUtil.trsAppNumToAppld(fccServiceBizData.getAppId());
            String subBizAppCode = fccServiceBizData.getSubAppId();
            Long bizOrgId = FccFinancialQueryServiceHelper.getBizOrg(fccServiceBizData.getBizOrg());
            Long periodId = fccFinancialQueryService.getPeriodId(fccServiceBizData);
            CheckExecutionResult result = this.checkItemExecute(bizApplCode, subBizAppCode, checkItem, bizOrgId, periodId);
            Optional<CheckExecutionResult> optionalResult = Optional.ofNullable(result);
            if (optionalResult.isPresent()) {
                msg = result.getItemCheckResultList().get(0).getErrMsg();
                int checkItemstatus = result.getItemCheckResultList().get(0).getExecuteStatus().getCode();
                switch (checkItemstatus) {
                    case 0: {
                        status = FccExecuteStatusEnum.ERROR.getType();
                        break;
                    }
                    case 1: {
                        status = FccExecuteStatusEnum.PASS.getType();
                        break;
                    }
                    case 2: {
                        status = FccExecuteStatusEnum.ERROR.getType();
                    }
                }
                resultMap.put("status", status);
                resultMap.put("message", msg);
            }
        }
        catch (KDException e) {
            log.error("FccCheckItemServiceError: \u9519\u8bef:" + e.getMessage());
            resultMap.put("status", FccExecuteStatusEnum.ERROR.getType());
            resultMap.put("message", String.format(ResManager.loadKDString((String)"\u9519\u8bef:%s", (String)"FccCheckItemServiceImpl_0", (String)"fi-fcc-mservice", (Object[])new Object[0]), e.getMessage()));
            throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u8d26\u9879\u68c0\u67e5\u7a0b\u5e8f\u6267\u884c\u9519\u8bef\u3002", (String)"FccCheckItemServiceImpl_1", (String)"fi-fcc-mservice", (Object[])new Object[0]));
        }
        return resultMap;
    }

    private CheckExecutionResult checkItemExecute(String bizApplCode, String subBizAppCode, String checkItem, Long bizOrgId, Long periodId) {
        CheckExecutionResult result = new CheckExecutionResult();
        CheckItemExecutionParam executionParam = new CheckItemExecutionParam();
        QFilter checkItemFilter = new QFilter("number", "=", (Object)checkItem);
        QFilter[] filters = new QFilter[]{checkItemFilter};
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)"fcm_checkitem", (String)"id", (QFilter[])filters);
        if (null == object) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u8d26\u68c0\u67e5\u9879\u672a\u627e\u5230\u3002", (String)"FccCheckItemServiceImpl_2", (String)"fi-fcc-mservice", (Object[])new Object[0]));
        }
        Long checkItemId = object.getLong("id");
        ArrayList<Long> checkItemIds = new ArrayList<Long>(1);
        checkItemIds.add(checkItemId);
        executionParam.setCheckItemIds(checkItemIds);
        executionParam.setBizAppId(bizApplCode);
        executionParam.setSubBizAppCode(subBizAppCode);
        executionParam.setOrgId(bizOrgId);
        executionParam.setPeriodId(periodId);
        try {
            String executionParamJson = JSONUtils.toString((Object)executionParam);
            String resultStr = this.checkExecute(executionParamJson);
            result = (CheckExecutionResult)JSONUtils.cast((String)resultStr, CheckExecutionResult.class);
        }
        catch (IOException e) {
            log.error("checkItemExecute: \u5fae\u670d\u52a1\u8c03\u7528\u9519\u8bef:" + e.getMessage());
        }
        return result;
    }

    private String checkExecute(String executionParamJson) {
        return (String)DispatchServiceHelper.invokeBizService((String)CLOUD_ID, (String)APP_ID, (String)SERVICE_NAME, (String)SERVICE_METHOD, (Object[])new Object[]{executionParamJson});
    }
}

