/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcc.mservice.impl;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.fcc.business.dto.FccAccountBooksRes;
import kd.fi.fcc.business.dto.FccServiceBizData;
import kd.fi.fcc.mservice.api.FccFinancialQueryService;
import kd.fi.fcc.mservice.helper.FccFinancialQueryServiceHelper;
import kd.fi.fcc.mservice.tools.BizTransferUtil;

public class FccFinancialQueryServiceImpl
implements FccFinancialQueryService {
    private static final Log log = LogFactory.getLog(FccFinancialQueryServiceImpl.class);
    private static final String CLOUD_ID = "fi";
    private static final String APP_ID = "gl";
    private static final String SERVICE_NAME = "FinancialBooksService";
    private static final String SERVICE_METHOD = "queryAccountBooks";

    public List<FccAccountBooksRes> queryAccountBooks(FccServiceBizData fccServiceBizData) {
        List<Object> list = new ArrayList<FccAccountBooksRes>(1);
        HashMap<String, Object> paramMaps = new HashMap<String, Object>(1);
        String appNum = fccServiceBizData.getAppId();
        String appld = BizTransferUtil.trsAppNumToAppld(appNum);
        String cloudNum = BizTransferUtil.trsAppIdToCloud(appld);
        log.info("\u67e5\u8be2\u4f1a\u8ba1\u671f\u95f4\uff1a" + fccServiceBizData + appNum + appld + cloudNum);
        if ("FI".equalsIgnoreCase(cloudNum)) {
            paramMaps.put("appNum", appNum);
            ArrayList<Long> orgIds = new ArrayList<Long>(1);
            Long orgId = FccFinancialQueryServiceHelper.getBizOrg(fccServiceBizData.getBizOrg());
            orgIds.add(orgId);
            paramMaps.put("orgIds", orgIds);
            if (!StringUtils.isEmpty((String)fccServiceBizData.getSubAppId())) {
                paramMaps.put("bookTypeId", Long.valueOf(fccServiceBizData.getSubAppId()));
            }
            String result = (String)DispatchServiceHelper.invokeBizService((String)CLOUD_ID, (String)APP_ID, (String)SERVICE_NAME, (String)SERVICE_METHOD, (Object[])new Object[]{paramMaps});
            list = JSON.parseArray((String)result, FccAccountBooksRes.class);
        }
        return list;
    }

    public Long getPeriodId(FccServiceBizData fccServiceBizData) {
        String periodName = fccServiceBizData.getPeriodName();
        FccAccountBooksRes fccAccountBooksRes = new FccAccountBooksRes();
        Long periodId = 0L;
        try {
            List<FccAccountBooksRes> list = this.queryAccountBooks(fccServiceBizData);
            if (!CollectionUtils.isNotEmpty(list)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u8d26\u7c3f\u5bf9\u5e94\u671f\u95f4\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8d26\u7c3f\u914d\u7f6e\u3002 ", (String)"FccFinancialQueryServiceImpl_0", (String)"fi-fcc-mservice", (Object[])new Object[0]));
            }
            fccAccountBooksRes = list.get(0);
            periodId = FccFinancialQueryServiceHelper.getPeriodId(fccAccountBooksRes.getPeriodTypeId(), periodName);
        }
        catch (KDBizException e) {
            log.error("FccFinancialQueryService-getPeriodIdError\uff1a" + e.getMessage());
        }
        return periodId;
    }
}

