/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcm.mservice;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.CRCondition;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.fcm.mservice.CheckItemDetail;
import kd.bos.ext.fi.fcm.mservice.CheckItemQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.JSONUtils;
import kd.fi.fcm.business.service.FcmServiceFactory;
import kd.fi.fcm.business.service.ServiceRefer;
import kd.fi.fcm.business.service.fcm.IAppAcountSettingService;
import kd.fi.fcm.business.service.fcm.IClosePeriodCheckItemService;
import kd.fi.fcm.common.domain.BaseDO;
import kd.fi.fcm.common.domain.fcm.AppAcountSettingDO;
import kd.fi.fcm.common.domain.fcm.CheckItemDO;
import kd.fi.fcm.common.domain.fcm.CheckingBillDO;
import kd.fi.fcm.common.domain.fcm.CheckingPluginDO;
import kd.fi.fcm.common.utils.CRCondtionUtils;
import kd.fi.fcm.mservice.api.CheckItemMService;

public class CheckItemMServiceImpl
implements CheckItemMService {
    private static final Log LOG = LogFactory.getLog(CheckItemMServiceImpl.class);
    private static Pattern FORMULA_FIELD_IS_EMPTY = Pattern.compile("trim\\(EMPTY_TO_TEXT\\((.*?)\\, ''\\)\\) ");
    private ServiceRefer<IClosePeriodCheckItemService> closePeriodCheckItemServiceService = ServiceRefer.of(IClosePeriodCheckItemService.class);
    private ServiceRefer<IAppAcountSettingService> appAcountSettingService = ServiceRefer.of(IAppAcountSettingService.class);

    public String queryCheckItems(String param) {
        try {
            LOG.info("query check items with param:" + param);
            if (StringUtils.isEmpty((CharSequence)param)) {
                return null;
            }
            CheckItemQueryParam queryParam = (CheckItemQueryParam)JSONUtils.cast((String)param, CheckItemQueryParam.class);
            List items = ((IClosePeriodCheckItemService)FcmServiceFactory.getService(IClosePeriodCheckItemService.class)).query(queryParam.getOrgId(), queryParam.getBizAppId(), queryParam.getSubbizAppCode(), queryParam.getEffective());
            return JSONUtils.toString(items.stream().map(x -> this.convert((CheckItemDO)x)).collect(Collectors.toList()));
        }
        catch (Exception e) {
            String msg = String.format(ResManager.loadKDString((String)"\u7ed3\u8d26\u68c0\u67e5\u9879\u67e5\u8be2\u68c0\u67e5\u9879\u5fae\u670d\u52a1\u5f02\u5e38[%1$s]: %2$s", (String)"CheckItemMServiceImpl_0", (String)"fi-fcm-mservice", (Object[])new Object[0]), TraceIdUtil.getCurrentTraceIdString(), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            LOG.error(msg, (Throwable)e);
            throw new KDBizException(msg);
        }
    }

    public String listCheckItemsByIdList(String param) {
        try {
            LOG.info("query check items with param:" + param);
            if (StringUtils.isEmpty((CharSequence)param)) {
                return null;
            }
            List queryParam = (List)JSONUtils.cast((String)param, List.class, (Class[])new Class[]{Long.class});
            List checkItems = ((IClosePeriodCheckItemService)this.closePeriodCheckItemServiceService.get()).listByIds(queryParam);
            return JSONUtils.toString(checkItems.stream().map(x -> this.convert((CheckItemDO)x)).collect(Collectors.toList()));
        }
        catch (Exception e) {
            String msg = String.format(ResManager.loadKDString((String)"\u7ed3\u8d26\u68c0\u67e5\u9879\u6839\u636eID\u67e5\u8be2\u68c0\u67e5\u9879\u5fae\u670d\u52a1\u5f02\u5e38[%1$s]: %2$s", (String)"CheckItemMServiceImpl_1", (String)"fi-fcm-mservice", (Object[])new Object[0]), TraceIdUtil.getCurrentTraceIdString(), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            LOG.error(msg, (Throwable)e);
            throw new KDBizException(msg);
        }
    }

    public String queryAppAccountSettingByAppId(Long appId) {
        try {
            AppAcountSettingDO appAcountSettingDO = ((IAppAcountSettingService)this.appAcountSettingService.get()).queryByAppId(appId);
            if (Objects.isNull(appAcountSettingDO)) {
                return "";
            }
            return JSONUtils.toString((Object)appAcountSettingDO);
        }
        catch (Exception e) {
            String msg = String.format(ResManager.loadKDString((String)"\u7ed3\u8d26\u68c0\u67e5\u9879\u67e5\u8be2\u8d26\u7c3f\u7c7b\u578b\u5fae\u670d\u52a1\u5f02\u5e38[%1$s]: %2$s", (String)"CheckItemMServiceImpl_2", (String)"fi-fcm-mservice", (Object[])new Object[0]), TraceIdUtil.getCurrentTraceIdString(), e.getMessage());
            LOG.error(msg, (Throwable)e);
            throw new KDBizException(msg);
        }
    }

    private CheckItemDetail convert(CheckItemDO checkItemDO) {
        CheckItemDetail checkItemDetail = new CheckItemDetail();
        try {
            CheckingBillDO checkingBillDO;
            checkItemDetail.setId(checkItemDO.getId());
            checkItemDetail.setNumber(checkItemDO.getNumber());
            checkItemDetail.setName(checkItemDO.getName().getLocaleValue());
            checkItemDetail.setBizAppId(checkItemDO.getBizAppId());
            checkItemDetail.setSubBizAppId(checkItemDO.getSubBizAppId());
            checkItemDetail.setMethod(checkItemDO.getCheckMethod());
            checkItemDetail.setSuggestType(Integer.valueOf(checkItemDO.getSuggestType()));
            checkItemDetail.setIsSysPreset(checkItemDO.getIsSysPreset().booleanValue());
            checkItemDetail.setIsEffective(checkItemDO.getIsEffective().booleanValue());
            CheckingBillDO checkingBillDO2 = checkingBillDO = null != checkItemDO.getCheckingBillId() && checkItemDO.getCheckingBillId() > 0L ? (CheckingBillDO)BaseDO.loadOne((Object)checkItemDO.getCheckingBillId(), CheckingBillDO.class).get() : null;
            if (null != checkingBillDO) {
                checkItemDetail.setCheckBillId(checkingBillDO.getBillNumber());
                checkItemDetail.setOnlineViewId(checkItemDetail.getCheckBillId());
                checkItemDetail.setOrgPropValue(checkingBillDO.getOrgPropValue());
                checkItemDetail.setPeriodPropName(checkingBillDO.getPeriodPropValue());
            }
            if (null != checkItemDO.getCheckingPluginId() && checkItemDO.getCheckingPluginId() > 0L) {
                CheckingPluginDO checkPluginDO = (CheckingPluginDO)BaseDO.loadOne((Object)checkItemDO.getCheckingPluginId(), CheckingPluginDO.class).get();
                checkItemDetail.setPluginAlias(checkPluginDO.getName().getLocaleValue());
                checkItemDetail.setPluginQualifiedName(checkPluginDO.getQualifierName());
            }
            if (StringUtils.isNotEmpty((CharSequence)checkItemDO.getCheckConditionExpr()) && null != checkingBillDO) {
                CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)checkItemDO.getCheckConditionExpr(), CRCondition.class);
                checkItemDetail.setCheckCondition(CRCondtionUtils.buildFullFormulaForSql((String)checkingBillDO.getBillNumber(), (CRCondition)condition).toSerializedString());
            }
            checkItemDetail.setPluginDefineParams((Map)SerializationUtils.fromJsonString((String)checkItemDO.getPluginParam(), Map.class));
        }
        catch (Exception e) {
            LOG.error(String.format("failed_to_convert_checkitem: %s for %s", SerializationUtils.toJsonString((Object)checkItemDO), e.getMessage()), (Throwable)e);
            throw e;
        }
        return checkItemDetail;
    }

    public static String replaceIllegalStatement(String rawFormula) {
        if (StringUtils.isEmpty((CharSequence)rawFormula)) {
            return rawFormula;
        }
        Matcher matcher = FORMULA_FIELD_IS_EMPTY.matcher(rawFormula);
        while (matcher.find()) {
            rawFormula = rawFormula.replace(matcher.group(), matcher.group(1));
        }
        rawFormula = rawFormula.replaceAll("!= NULL", "is not null");
        rawFormula = rawFormula.replaceAll("= true ", "= 1");
        rawFormula = rawFormula.replaceAll("= false ", "= 0");
        return rawFormula;
    }
}

