/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcm.formplugin.checkingbillplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterService;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fcm.business.service.FcmServiceFactory;
import kd.fi.fcm.business.service.ServiceRefer;
import kd.fi.fcm.business.service.bos.IDevportalBizAppService;
import kd.fi.fcm.business.service.checkingbillplugin.ICheckingBillService;
import kd.fi.fcm.common.domain.fcm.CheckingBillDO;
import org.apache.commons.lang3.StringUtils;

public class CheckingBillPlugin
extends AbstractFormPlugin {
    public static final String EDIT = "EDIT";
    public static final String VIEW = "VIEW";
    public static final String SELECTFIELDS = "id,periodpropvalue,orgpropvalue,checkingbill";
    public static final String FI_CLOUD_ID = "83bfebc8000002ac";
    public static final String BIZAPPID = "bizappid";
    public static final String ZERO = "0";
    public static final String TYPE = "type";
    public static final String ID = "id";
    public static final String KEY_SAVE = "save";
    private static ServiceRefer<IDevportalBizAppService> bizAppServiceService = ServiceRefer.of(IDevportalBizAppService.class);
    private Predicate<IDataEntityProperty> isPossiblePeriodField = x -> Date.class == x.getPropertyType() || x instanceof BasedataProp && "bd_period".equals(((BasedataProp)x).getBaseEntityId());
    private Predicate<IDataEntityProperty> isPossibleOrgField = x -> x instanceof OrgProp || OrgProp.class == x.getPropertyType() || x instanceof BasedataProp && "bos_org".equals(((BasedataProp)x).getBaseEntityId()) || x instanceof BasedataProp && "bos_org_structure".equals(((BasedataProp)x).getBaseEntityId());

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setEnable(Boolean.FALSE, new String[]{"periodpropvalue", "orgpropvalue"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit checkingbills = (BasedataEdit)this.getControl("checkingbill");
        checkingbills.addBeforeF7SelectListener(bill -> {
            Map formCustParams = bill.getFormShowParameter().getCustomParams();
            List acctBookCloudnums = BookRegisterService.queryAllCloudNum();
            if (null != acctBookCloudnums && !acctBookCloudnums.isEmpty()) {
                acctBookCloudnums = acctBookCloudnums.stream().map(num -> num.toUpperCase()).collect(Collectors.toList());
                QFilter qFilter = new QFilter("number", "in", acctBookCloudnums);
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"bizcloud.id", (QFilter[])qFilter.toArray());
                String cloudids = collection.stream().map(dyn -> dyn.getString("bizcloud.id")).collect(Collectors.joining(","));
                formCustParams.put("treeRootNodeId", cloudids);
                formCustParams.put("modeltype", "BillFormModel,BaseFormModel");
            }
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData[] changeData = e.getChangeSet();
        String propertyName = e.getProperty().getName();
        if (propertyName.equals("checkingbill")) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"periodpropvalue", "orgpropvalue"});
            DynamicObject appObj = (DynamicObject)changeData[0].getNewValue();
            if (null != appObj) {
                ICheckingBillService ibs = (ICheckingBillService)FcmServiceFactory.getService(ICheckingBillService.class);
                if (null != ibs.getCheckBillObjByNumber((Object)appObj.get(ID).toString())) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u80fd\u6709\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CheckingBillPlugin_0", (String)"fi-fcm-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("checkingbill", null);
                    this.getView().setEnable(Boolean.FALSE, new String[]{"periodpropvalue", "orgpropvalue"});
                } else {
                    String id = appObj.get(ID).toString();
                    MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)id);
                    this.setComboEdit("periodpropvalue", mainEntityType.getProperties(), null);
                    this.setComboEdit("orgpropvalue", mainEntityType.getProperties(), null);
                }
            }
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        super.beforePropertyChanged(e);
        ChangeData[] changeData = e.getChangeSet();
        String propertyName = e.getProperty().getName();
        if ("checkingbill".equals(propertyName) && changeData[0].getOldValue() != null && changeData[0].getNewValue() != null) {
            this.showForm(ResManager.loadKDString((String)"\u5207\u6362\u4e1a\u52a1\u5bf9\u8c61\u4f1a\u6e05\u7a7a\u6570\u636e", (String)"CheckingBillPlugin_1", (String)"fi-fcm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("periodpropvalue", null);
            this.getModel().setValue("orgpropvalue", null);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult operationResult;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)KEY_SAVE, (CharSequence)formOperate.getOperateKey()) && !(operationResult = args.getOperationResult()).isSuccess()) {
            this.getModel().setValue("checkingbill", null);
            this.getModel().setValue("periodpropvalue", null);
            this.getModel().setValue("orgpropvalue", null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"periodpropvalue", "orgpropvalue"});
        }
    }

    private void showForm(String ... words) {
        String word = "";
        if (words.length == 1) {
            word = words[0];
        } else {
            StringBuilder sb = new StringBuilder();
            for (String w : words) {
                sb.append(w).append(',');
            }
            word = sb.delete(sb.length() - 1, sb.length()).toString();
        }
        this.getView().showConfirm(ResManager.loadKDString((String)word, (String)"checkingbill_1", (String)"fi-fcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("checkingbill", (IFormPlugin)this));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (EDIT.equals(this.getView().getFormShowParameter().getStatus().name()) || VIEW.equals(this.getView().getFormShowParameter().getStatus().name())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"checkingbill"});
            IDataModel model = this.getModel();
            ICheckingBillService ibs = (ICheckingBillService)FcmServiceFactory.getService(ICheckingBillService.class);
            CheckingBillDO id = ibs.getCheckBillObj(model.getValue(ID));
            DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)id.getSourceDynamicObject().get("billnumber").toString()).getProperties();
            this.setComboEdit("periodpropvalue", properties, id.getSourceDynamicObject().get("periodpropvalue").toString());
            this.setComboEdit("orgpropvalue", properties, id.getSourceDynamicObject().get("orgpropvalue").toString());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        IDataModel model;
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)KEY_SAVE, (CharSequence)formOperate.getOperateKey()) && (null == (model = this.getModel()).getValue("periodpropvalue") || null == model.getValue("orgpropvalue"))) {
            this.showForm(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u5f55\u9879\u3002", (String)"CheckingBillPlugin_3", (String)"fi-fcm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void setComboEdit(String control, DataEntityPropertyCollection properties, String selectedItemValue) {
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        ComboEdit comboEdit = (ComboEdit)this.getControl(control);
        for (IDataEntityProperty dob : properties) {
            if (null == dob.getDisplayName() || "periodpropvalue".equals(control) && this.isPossiblePeriodField.negate().test(dob) || "orgpropvalue".equals(control) && this.isPossibleOrgField.negate().test(dob)) continue;
            if (StringUtils.isNotEmpty((CharSequence)selectedItemValue) && selectedItemValue.equals(dob.getName())) {
                comboEdit.selectedStore(new ComboItem(new LocaleString(dob.getDisplayName().getLocaleValue()), dob.getName()));
            }
            data.add(new ComboItem(new LocaleString(String.format("%s(%s)", dob.getDisplayName().getLocaleValue(), dob.getName())), dob.getName()));
        }
        comboEdit.setComboItems(data);
    }
}

