/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcm.formplugin.checkitem;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.IntegerEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.BigIntField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.fcm.business.dto.PluginParamEntryDTO;
import kd.fi.fcm.formplugin.util.FcmFormMsgs;
import org.apache.commons.collections4.CollectionUtils;

public class CheckItemParamSetFormPlugin
extends AbstractFormPlugin {
    public static final String FORM_FIELD_CONTAINER = "paramap";
    public static final String FORM_CUST_PARAM_PLUGINID = "pluginid";
    public static final String FORM_CUST_PARAM_INFO = "paraminfo";
    public static final String BTN_OK = "btnok";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormParamParser formParamParser = new FormParamParser((FormShowParameter)e.getSource());
        FlexPanelAp headAp = this.createDynamicPanel(formParamParser.getCheckItemPluginId(), formParamParser.getParamEntryInfos());
        HashMap<String, String> mapHead = new HashMap<String, String>();
        mapHead.put("id", FORM_FIELD_CONTAINER);
        mapHead.put("items", (String)headAp.createControl().get("items"));
        e.getItems().add(mapHead);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("CheckItemParamSetFormPlugin", exp.getMessage()), new Object[0]);
        }
        this.registDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    public void createNewData(BizDataEventArgs e) {
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        FormParamParser formParamParser = new FormParamParser(this.getView().getFormShowParameter());
        if (CollectionUtils.isNotEmpty(formParamParser.getParamEntryInfos())) {
            for (PluginParamEntryDTO each : formParamParser.getParamEntryInfos()) {
                Object value = each.getSetterValue();
                String fieldType = each.getDataType();
                String fieldKey = CheckItemParamSetFormPlugin.buildFieldNumber(formParamParser.getCheckItemPluginId(), each.getCode());
                switch (fieldType) {
                    case "int": {
                        if (value != null) {
                            try {
                                value = Long.parseLong(value.toString());
                            }
                            catch (Throwable e1) {
                                value = 0;
                            }
                        } else {
                            value = 0;
                        }
                        dataEntity.set(fieldKey, value);
                        break;
                    }
                    case "boolean": {
                        value = value == null || !"true".equalsIgnoreCase(value.toString()) && !"1".equals(value.toString()) ? Boolean.FALSE : Boolean.TRUE;
                        dataEntity.set(fieldKey, value);
                        break;
                    }
                    case "basedata": {
                        if (!kd.bos.util.StringUtils.isNotEmpty((String)value.toString())) break;
                        DynamicObject baseDataObj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(value.toString()), (String)each.getBasicDataEntityNumber());
                        dataEntity.set(fieldKey, (Object)baseDataObj);
                        break;
                    }
                    case "text": 
                    case "combo": {
                        if (!kd.bos.util.StringUtils.isNotEmpty((String)value.toString())) break;
                        dataEntity.set(fieldKey, value);
                    }
                }
            }
        }
        e.setDataEntity((Object)dataEntity);
    }

    public void beforeBindData(EventObject e) {
        FormParamParser formParamParser = new FormParamParser(this.getView().getFormShowParameter());
        FlexPanelAp dynamicPanel = this.createDynamicPanel(formParamParser.getCheckItemPluginId(), formParamParser.getParamEntryInfos());
        Container myFldPanel = (Container)this.getView().getControl(FORM_FIELD_CONTAINER);
        myFldPanel.getItems().addAll(((Container)dynamicPanel.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(myFldPanel.getItems());
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        FormParamParser formParamParser = new FormParamParser(this.getView().getFormShowParameter());
        if (CollectionUtils.isNotEmpty(formParamParser.getParamEntryInfos())) {
            for (PluginParamEntryDTO each : formParamParser.getParamEntryInfos()) {
                String fieldType;
                if (!CheckItemParamSetFormPlugin.buildFieldNumber(formParamParser.getCheckItemPluginId(), each.getCode()).equalsIgnoreCase(e.getKey())) continue;
                IntegerEdit edit = null;
                switch (fieldType = each.getDataType()) {
                    case "int": {
                        edit = new IntegerEdit();
                        break;
                    }
                    case "text": {
                        edit = new TextEdit();
                        break;
                    }
                    case "boolean": {
                        edit = new FieldEdit();
                        break;
                    }
                    case "combo": {
                        edit = new ComboEdit();
                        break;
                    }
                    case "basedata": {
                        edit = new BasedataEdit();
                        edit.setFieldKey(e.getKey());
                        break;
                    }
                }
                if (edit != null) {
                    edit.setKey(e.getKey());
                    edit.setView(this.getView());
                    edit.setModel(this.getModel());
                }
                e.setControl((Control)edit);
                break;
            }
        }
    }

    private FlexPanelAp createDynamicPanel(String uniqueKey, List<PluginParamEntryDTO> paramEntries) {
        FlexPanelAp paramPanelAp = new FlexPanelAp();
        paramPanelAp.setKey("dyn_paramAp");
        if (CollectionUtils.isEmpty(paramEntries)) {
            return paramPanelAp;
        }
        for (PluginParamEntryDTO each : paramEntries) {
            String id = uniqueKey + each.getId();
            String number = uniqueKey + each.getCode();
            LocaleString name = new LocaleString(each.getName());
            FieldAp fieldAp = new FieldAp();
            fieldAp.setId(id);
            fieldAp.setKey(number);
            fieldAp.setName(name);
            fieldAp.setBackColor("#FFFFFF");
            if (kd.bos.util.StringUtils.isNotEmpty((String)each.getDesc())) {
                Tips tips = new Tips("text", null, new LocaleString(each.getDesc()), false, null);
                fieldAp.setCtlTips(tips);
            }
            fieldAp.setFireUpdEvt(true);
            String fieldType = each.getDataType();
            BigIntField field = null;
            switch (fieldType) {
                case "int": {
                    field = new BigIntField();
                    break;
                }
                case "text": {
                    field = new TextField();
                    break;
                }
                case "boolean": {
                    field = new CheckBoxField();
                    break;
                }
                case "combo": {
                    ComboField comboField = new ComboField();
                    Map comVal = each.getValueRange();
                    if (comVal.size() > 0) {
                        ArrayList<ComboItem> items = new ArrayList<ComboItem>(comVal.size());
                        int i = 0;
                        for (Map.Entry entry : comVal.entrySet()) {
                            ComboItem item = new ComboItem();
                            Object val = entry.getValue();
                            item.setSeq(i++);
                            item.setValue((String)entry.getKey());
                            item.setCaption(val == null ? new LocaleString((String)entry.getKey()) : new LocaleString(val.toString()));
                            items.add(item);
                        }
                        comboField.setItems(items);
                    }
                    field = comboField;
                    break;
                }
                case "basedata": {
                    field = new BasedataField();
                    ((BasedataField)field).setBaseEntityId(each.getBasicDataEntityNumber());
                    break;
                }
            }
            if (field != null) {
                field.setId(id);
                field.setKey(number);
                field.setMustInput(each.getIsRequire());
                if (kd.bos.util.StringUtils.isNotEmpty((String)each.getDefaultValue())) {
                    if (field instanceof BigIntField) {
                        field.setDefValue(BigDecimal.valueOf(Long.parseLong(each.getDefaultValue())));
                    } else if (field instanceof TextField) {
                        ((TextField)field).setDefValue(each.getDefaultValue());
                    } else if (field instanceof CheckBoxField) {
                        ((CheckBoxField)field).setDefValue("true".equals(each.getDefaultValue()) || "1".equals(each.getDefaultValue()));
                    } else if (field instanceof ComboField) {
                        ((ComboField)field).setDefValue(each.getDefaultValue());
                    }
                }
                fieldAp.setField((Field)field);
            }
            paramPanelAp.getItems().add(fieldAp);
        }
        return paramPanelAp;
    }

    private void registDynamicProps(MainEntityType newMainType) {
        FormParamParser formParamParser = new FormParamParser(this.getView().getFormShowParameter());
        for (PluginParamEntryDTO each : formParamParser.getParamEntryInfos()) {
            LocaleString name = new LocaleString(each.getName());
            String fieldType = each.getDataType();
            BigIntProp fieldProp = null;
            if ("basedata".equals(fieldType)) {
                String key = CheckItemParamSetFormPlugin.buildFieldNumber(formParamParser.getCheckItemPluginId(), each.getCode());
                MainEntityType billEntityType = EntityMetadataCache.getDataEntityType((String)each.getBasicDataEntityNumber());
                LongProp idprop = new LongProp();
                idprop.setName(key + "_id");
                idprop.setAlias("FBasedataId");
                BasedataProp complexFieldProp = new BasedataProp();
                complexFieldProp.setName(key);
                complexFieldProp.setDbIgnore(true);
                complexFieldProp.setComplexType((IDataEntityType)billEntityType);
                complexFieldProp.setBaseEntityId(each.getBasicDataEntityNumber());
                complexFieldProp.setRefIdProp((IDataEntityProperty)idprop);
                complexFieldProp.setRefIdPropName(idprop.getName());
                complexFieldProp.setDisplayProp("name");
                complexFieldProp.setDisplayName(billEntityType.getDisplayName());
                newMainType.registerComplexProperty((DynamicComplexProperty)complexFieldProp);
                newMainType.addProperty((DynamicProperty)idprop);
                continue;
            }
            switch (fieldType) {
                case "int": {
                    fieldProp = new BigIntProp();
                    break;
                }
                case "text": {
                    fieldProp = new TextProp();
                    break;
                }
                case "boolean": {
                    fieldProp = new BooleanProp();
                    break;
                }
                case "combo": {
                    fieldProp = new ComboProp();
                    break;
                }
            }
            if (fieldProp == null) continue;
            fieldProp.setName(CheckItemParamSetFormPlugin.buildFieldNumber(formParamParser.getCheckItemPluginId(), each.getCode()));
            fieldProp.setDisplayName(name);
            fieldProp.setDbIgnore(true);
            fieldProp.setAlias("");
            fieldProp.setMustInput(each.getIsRequire());
            newMainType.registerSimpleProperty((DynamicSimpleProperty)fieldProp);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (BTN_OK.equalsIgnoreCase(ctlSource.getKey())) {
            try {
                Map<String, Object> returnData = this.validateAndCollectPluginParams();
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(returnData));
                this.getView().close();
            }
            catch (KDBizException ke) {
                this.getView().showTipNotification(ke.getMessage());
            }
        } else {
            super.click(evt);
        }
    }

    private Map<String, Object> validateAndCollectPluginParams() {
        IFormView formView = this.getView();
        IDataModel dataModel = formView.getModel();
        String checkItemPluginId = formView.getFormShowParameter().getCustomParams().get(FORM_CUST_PARAM_PLUGINID).toString();
        DataEntityPropertyCollection props = dataModel.getDataEntityType().getProperties();
        Iterator its = props.iterator();
        IDataEntityProperty prop = null;
        String fieldName = null;
        HashMap<String, Object> paramMap = new HashMap<String, Object>(props.size());
        while (its.hasNext()) {
            boolean isMustInput;
            prop = (IDataEntityProperty)its.next();
            fieldName = prop.getName();
            if (fieldName.endsWith("_id")) continue;
            Object value = dataModel.getValue(fieldName);
            if (prop instanceof BigIntProp ? value == null || "".equals(value) || (Long)value == 0L : (prop instanceof FieldProp ? (isMustInput = ((FieldProp)prop).isMustInput()) && (value == null || StringUtils.isEmpty((CharSequence)value.toString())) : prop instanceof BasedataProp && (isMustInput = ((BasedataProp)prop).isMustInput()) && value == null)) {
                throw new KDBizException(FcmFormMsgs.pluginParamRequiredValidateFail(prop.getDisplayName().getLocaleValue()));
            }
            if (prop instanceof BasedataProp) {
                paramMap.put(CheckItemParamSetFormPlugin.restoreFieldNumber(fieldName, checkItemPluginId), ((DynamicObject)value).getLong("id"));
                continue;
            }
            paramMap.put(CheckItemParamSetFormPlugin.restoreFieldNumber(fieldName, checkItemPluginId), value);
        }
        return paramMap;
    }

    private static String buildFieldNumber(String uniqueKey, String defaultNumber) {
        return uniqueKey + defaultNumber;
    }

    public static String restoreFieldNumber(String fieldName, String uniqueKey) {
        return fieldName.replace(uniqueKey, "");
    }

    static class FormParamParser {
        private String checkItemPluginId;
        private List<PluginParamEntryDTO> paramEntryInfos;

        public FormParamParser(FormShowParameter showParameter) {
            this.checkItemPluginId = showParameter.getCustomParams().get(CheckItemParamSetFormPlugin.FORM_CUST_PARAM_PLUGINID).toString();
            this.paramEntryInfos = FormParamParser.parseFromFormParameter(showParameter.getCustomParam(CheckItemParamSetFormPlugin.FORM_CUST_PARAM_INFO).toString());
        }

        private static List<PluginParamEntryDTO> parseFromFormParameter(String jsonStr) {
            try {
                return (List)JSONUtils.cast((String)jsonStr, List.class, (Class[])new Class[]{PluginParamEntryDTO.class});
            }
            catch (IOException ex) {
                throw new IllegalStateException("failed to get variable 'paraminfo' from form parameter", ex);
            }
        }

        public String getCheckItemPluginId() {
            return this.checkItemPluginId;
        }

        public List<PluginParamEntryDTO> getParamEntryInfos() {
            return this.paramEntryInfos;
        }
    }
}

