/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcm.formplugin.checkitem;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterInfo;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterService;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.base.BaseView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.fcm.business.dto.PluginParamEntryDTO;
import kd.fi.fcm.business.service.FcmServiceFactory;
import kd.fi.fcm.business.service.ServiceRefer;
import kd.fi.fcm.business.service.bos.IDevportalBizAppService;
import kd.fi.fcm.business.service.fcm.ICheckItemStatusService;
import kd.fi.fcm.business.service.fcm.ICheckingPluginService;
import kd.fi.fcm.business.service.fcm.IClosePeriodCheckItemService;
import kd.fi.fcm.common.domain.DomainObjectCollection;
import kd.fi.fcm.common.domain.bos.DevportalBizAppDO;
import kd.fi.fcm.common.domain.fcm.BaseInfoDO;
import kd.fi.fcm.common.domain.fcm.CheckItemDO;
import kd.fi.fcm.common.domain.fcm.CheckingPluginDO;
import kd.fi.fcm.common.domain.fcm.PluginParamEntryDO;
import kd.fi.fcm.common.enums.FcmSystemType;
import kd.fi.fcm.common.helper.Checker;
import kd.fi.fcm.common.helper.DomainObjectHelper;
import kd.fi.fcm.common.helper.FilterLambdaBuilder;
import kd.fi.fcm.common.utils.EntityFieldTreeOption;
import kd.fi.fcm.common.utils.EntityFieldTreeResult;
import kd.fi.fcm.common.utils.EntityTreeUtil;
import kd.fi.fcm.common.utils.ExpressionType;
import kd.fi.fcm.formplugin.util.FcmFormMsgs;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ClosePeriodCheckItemPlugin
extends AbstractFormPlugin {
    protected static final Log LOG = LogFactory.getLog(ClosePeriodCheckItemPlugin.class);
    private static final String FIELD_CHECK_METHOD = "checkmethod";
    private static final String FIELD_CHECK_BILL_ID = "checkbillid";
    private static final String FIELD_CHECK_CONDITION_EXPR_BTN = "checkconditionexprbtn";
    private static final String FIELD_CHECK_PLUGIN_ID = "checkpluginid";
    private static final String FIELD_PLUGIN_PARAM_JSON = "pluginparamjson";
    private static final String FIELD_BILL_VIEW_ID = "billviewid";
    private static final String FIELD_SUB_BIZ_APP_ID = "subbizappid";
    private static final String FIELD_ENABLE = "enable";
    private static final String FIELD_USE_ORG = "useorg";
    private static final String DIALOG_CHECK_CONDITION_EXPR_BTN = "fcm_condition";
    private static final String OP_TO_ADD_PAGE = "showAddPage";
    private static final String FIELD_DISPLAY_CHECK_BILL = "displaycheckbill";
    private static final String[] All_ITEMS = new String[]{"name", "number", "bizappid", "subbizappid", "checkmethod", "checkpluginid", "suggesttype", "checkconditionjson_tag", "save", "bizcloud"};
    private static final String[] SYSPRESET_ENABLE_ITEMS = new String[]{"name", "number", "bizappid", "subbizappid", "checkmethod", "checkpluginid", "suggesttype", "checkconditionjson_tag", "save"};
    private ServiceRefer<IClosePeriodCheckItemService> checkItemService = ServiceRefer.of(IClosePeriodCheckItemService.class);
    private ServiceRefer<ICheckItemStatusService> checkItemStatusService = ServiceRefer.of(ICheckItemStatusService.class);
    private ServiceRefer<ICheckingPluginService> checkItemPluginService = ServiceRefer.of(ICheckingPluginService.class);
    private static ServiceRefer<IDevportalBizAppService> bizAppServiceService = ServiceRefer.of(IDevportalBizAppService.class);
    private static final String PAGE_CACHE_KEY_PLUGIN_PARAM_PAGE = "pluginParamPageId";
    private static Map<String, String> ENTITY_FORMULA_TREE_CACHE = new WeakHashMap<String, String>();

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{FIELD_CHECK_CONDITION_EXPR_BTN, "save", "saveandnew", FIELD_PLUGIN_PARAM_JSON});
    }

    public void beforeBindData(EventObject e) {
        Long id;
        super.beforeBindData(e);
        IDataModel model = this.getModel();
        String checkConditionExpr = (String)model.getValue("checkconditionjson_tag");
        DynamicObject checkBill = (DynamicObject)model.getValue(FIELD_CHECK_BILL_ID);
        this.checkMethodChange((String)model.getValue(FIELD_CHECK_METHOD), Boolean.FALSE);
        Object subBizAppId = model.getValue(FIELD_SUB_BIZ_APP_ID);
        DynamicObject bizApp = (DynamicObject)model.getValue("bizappid");
        this.initBizCloud(bizApp.getString("id"));
        if (null != bizApp) {
            this.bizAppChange(bizApp.getString("id"));
            model.setValue(FIELD_SUB_BIZ_APP_ID, subBizAppId);
        }
        if (null != checkBill) {
            model.setValue(FIELD_CHECK_BILL_ID, checkBill.get("id"));
            model.setValue(FIELD_DISPLAY_CHECK_BILL, checkBill.get("id"));
        }
        if (StringUtils.isNotBlank((CharSequence)checkConditionExpr)) {
            JSONObject jsonObject = JSONObject.parseObject((String)checkConditionExpr);
            model.setValue(FIELD_CHECK_CONDITION_EXPR_BTN, jsonObject.get((Object)"exprTran"));
            model.setValue("checkconditionjson_tag", (Object)checkConditionExpr);
        }
        if (null != (id = (Long)model.getValue("id")) && 0L != id) {
            Boolean isSystemSet = (Boolean)model.getValue("issyspresetbtn");
            Boolean enAbleChange = (Boolean)model.getValue("enablechange");
            String[] itemList = All_ITEMS;
            if (enAbleChange.booleanValue()) {
                itemList = isSystemSet != false ? SYSPRESET_ENABLE_ITEMS : new String[]{};
            }
            this.getView().setEnable(Boolean.FALSE, itemList);
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object opFlag = formShowParameter.getCustomParam(OP_TO_ADD_PAGE);
        Object isPersonalizeData = formShowParameter.getCustomParam("isPersonalizeData");
        if (Objects.equals(opFlag, "tblcopy")) {
            model.setValue("issyspresetbtn", (Object)Boolean.FALSE);
            model.setValue("enablechange", (Object)Boolean.TRUE);
        } else if (Objects.nonNull(isPersonalizeData) && ((Boolean)isPersonalizeData).booleanValue()) {
            model.setValue("enablechange", (Object)Boolean.TRUE);
            model.setValue("issyspresetbtn", (Object)Boolean.FALSE);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        CheckItemDO checkItemDO = new CheckItemDO(((BaseView)e.getSource()).getModel().getDataEntity());
        if (Objects.equals(checkItemDO.getCheckMethod(), "2")) {
            this.switchPluginParamComponent(checkItemDO.getCheckingPluginId());
        } else {
            this.switchPluginParamComponent(null);
        }
    }

    private void switchPluginParamComponent(Long pluginId) {
        List pluginParamInfos;
        if (Objects.isNull(pluginId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FIELD_PLUGIN_PARAM_JSON});
        }
        if (CollectionUtils.isEmpty((Collection)(pluginParamInfos = ((ICheckingPluginService)this.checkItemPluginService.get()).fetchParamInfos(pluginId)))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FIELD_PLUGIN_PARAM_JSON});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{FIELD_PLUGIN_PARAM_JSON});
        }
    }

    private boolean validatePluginParams(Long pluginId, String paramValueJson) {
        Map paramValues = StringUtils.isEmpty((CharSequence)paramValueJson) ? Collections.EMPTY_MAP : (Map)SerializationUtils.fromJsonString((String)paramValueJson, Map.class);
        for (PluginParamEntryDO x : ((ICheckingPluginService)this.checkItemPluginService.get()).fetchParamInfos(pluginId)) {
            Object paramValue;
            if (!x.getIsRequired().booleanValue() || !Objects.isNull(paramValue = paramValues.get(x.getCode())) && !StringUtils.isEmpty((CharSequence)paramValue.toString())) continue;
            this.getView().showTipNotification(FcmFormMsgs.requirePluginParam(x.getName().getLocaleValue()));
            return false;
        }
        return true;
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit bizAppController = (BasedataEdit)this.getControl("bizappid");
        bizAppController.addBeforeF7SelectListener(evt -> {
            DynamicObject bizCloud = (DynamicObject)this.getModel().getValue("bizcloud");
            if (null == bizCloud) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u4e91", (String)"ClosePeriodCheckItemPlugin_4", (String)"fi-fcm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            List bookRegisterInfoDOS = BookRegisterService.queryAllByCloudNum((String)bizCloud.getString("number"));
            if (null != bookRegisterInfoDOS && !bookRegisterInfoDOS.isEmpty()) {
                ArrayList<String> bizappnums = new ArrayList<String>(bookRegisterInfoDOS.size());
                for (BookRegisterInfo bookRegisterInfo : bookRegisterInfoDOS) {
                    bizappnums.add(bookRegisterInfo.getBizApp());
                }
                QFilter qFilter = new QFilter("number", "in", bizappnums);
                ListShowParameter paramd = (ListShowParameter)evt.getFormShowParameter();
                List filters = paramd.getListFilterParameter().getQFilters();
                filters.add(qFilter);
                paramd.getListFilterParameter().setOrderBy("sequence");
            } else {
                ListShowParameter paramd = (ListShowParameter)evt.getFormShowParameter();
                List filters = paramd.getListFilterParameter().getQFilters();
                filters.add(new QFilter("1", "=", (Object)-1));
                paramd.getListFilterParameter().setOrderBy("sequence");
            }
        });
        BasedataEdit bizCloudController = (BasedataEdit)this.getControl("bizcloud");
        bizCloudController.addBeforeF7SelectListener(evt -> {
            List acctBookCloudnums = BookRegisterService.queryAllCloudNum();
            if (null != acctBookCloudnums && !acctBookCloudnums.isEmpty()) {
                acctBookCloudnums = acctBookCloudnums.stream().map(num -> num.toUpperCase()).collect(Collectors.toList());
                QFilter qFilter = new QFilter("number", "in", acctBookCloudnums);
                ListShowParameter paramd = (ListShowParameter)evt.getFormShowParameter();
                List filters = paramd.getListFilterParameter().getQFilters();
                filters.add(qFilter);
                paramd.getListFilterParameter().setOrderBy("sequence");
            }
        });
        BasedataEdit checkPluginController = (BasedataEdit)this.getView().getControl(FIELD_CHECK_PLUGIN_ID);
        checkPluginController.addBeforeF7SelectListener(evt -> {
            IDataModel model = this.getModel();
            ListShowParameter paramd = (ListShowParameter)evt.getFormShowParameter();
            List filters = paramd.getListFilterParameter().getQFilters();
            DynamicObject bizApp = (DynamicObject)model.getValue("bizappid");
            QFilter bizAppFilter = new QFilter("application", "in", (Object)new Object[]{bizApp.getString("id"), " "});
            filters.add(bizAppFilter);
            QFilter subBizAppFilter = new QFilter("checktypeid", "in", (Object)new Object[]{model.getValue(FIELD_SUB_BIZ_APP_ID), " "});
            filters.add(subBizAppFilter);
            DynamicObject org = (DynamicObject)model.getValue(FIELD_USE_ORG);
            QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)DomainObjectHelper.getDomainIdentifier(CheckingPluginDO.class), (Long)org.getLong("id"));
            filters.add(orgFilter);
        });
    }

    public void afterCreateNewData(EventObject e) {
        this.checkMethodChange("1", true);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        this.initBizCloud((String)formShowParameter.getCustomParam("bizappid"));
        this.bizAppChange((String)formShowParameter.getCustomParam("bizappid"));
        this.getModel().setValue(FIELD_SUB_BIZ_APP_ID, formShowParameter.getCustomParam(FIELD_SUB_BIZ_APP_ID));
        this.getModel().setValue(FIELD_USE_ORG, formShowParameter.getCustomParam("org"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        switch (key) {
            case "checkmethod": {
                String checkMethod = (String)newValue;
                this.checkMethodChange(checkMethod, true);
                CheckItemDO curModel = new CheckItemDO(this.getModel().getDataEntity());
                Long checkingPluginId = curModel.getCheckingPluginId();
                if (null == checkingPluginId || checkingPluginId == 0L) {
                    this.switchPluginParamComponent(null);
                    break;
                }
                this.switchPluginParamComponent(checkingPluginId);
                break;
            }
            case "bizcloud": {
                this.getModel().setValue("bizappid", null);
                break;
            }
            case "bizappid": {
                DynamicObject bizApp = (DynamicObject)newValue;
                String bizAppId = "";
                if (null != bizApp) {
                    bizAppId = bizApp.getString("id");
                }
                this.bizAppChange(bizAppId);
                break;
            }
            case "checkconditionexprbtn": {
                if (!StringUtils.isBlank((CharSequence)((String)newValue))) break;
                this.clearFiled(new String[]{"checkconditionjson_tag"});
                break;
            }
            case "checkpluginid": {
                this.clearFiled(new String[]{FIELD_PLUGIN_PARAM_JSON});
                if (Objects.isNull(newValue)) {
                    this.switchPluginParamComponent(null);
                    break;
                }
                DynamicObject plugin = (DynamicObject)newValue;
                Long pluginId = plugin.getLong("id");
                this.switchPluginParamComponent(pluginId);
                try {
                    this.getModel().setValue(FIELD_PLUGIN_PARAM_JSON, (Object)JSONUtils.toString((Object)((ICheckingPluginService)this.checkItemPluginService.get()).initPluginParamValue(pluginId)));
                }
                catch (IOException ioe) {
                    LOG.error("Failed json serialization: ", (Throwable)ioe);
                }
                break;
            }
            case "displaycheckbill": {
                this.getModel().setValue(FIELD_CHECK_BILL_ID, newValue);
                this.clearFiled(new String[]{FIELD_CHECK_CONDITION_EXPR_BTN, "checkconditionjson_tag"});
                break;
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        Object source = evt.getSource();
        if (source instanceof Button) {
            Button button = (Button)source;
            String key = button.getOperationKey();
            IDataModel model = this.getModel();
            switch (key) {
                case "save": 
                case "saveandnew": {
                    DynamicObject org = (DynamicObject)model.getValue("org");
                    String number = (String)model.getValue("number");
                    DynamicObject bizApp = (DynamicObject)model.getValue("bizappid");
                    String subBizApp = (String)model.getValue(FIELD_SUB_BIZ_APP_ID);
                    ((IClosePeriodCheckItemService)this.checkItemService.get()).checkUniquness((Long)model.getValue("id"), org.getString("id"), number, bizApp != null ? bizApp.getString("id") : "", subBizApp);
                    String checkMethod = (String)model.getValue(FIELD_CHECK_METHOD);
                    if (Objects.equals(checkMethod, "2")) {
                        Checker.checkArgument((boolean)Objects.nonNull(model.getValue(FIELD_CHECK_PLUGIN_ID)), (String)ResManager.loadKDString((String)"\u201c\u63d2\u4ef6\u201d\u4e0d\u80fd\u4e3a\u7a7a", (String)"ClosePeriodCheckItemPlugin_0", (String)"fi-fcm-formplugin", (Object[])new Object[0]), (FcmSystemType)FcmSystemType.FORMPLUGIN, (String)"ClosePeriodCheckItemTips_10", (Object[])new Object[0]);
                        CheckItemDO curCheckItem = new CheckItemDO(model.getDataEntity());
                        if (this.validatePluginParams(curCheckItem.getCheckingPluginId(), curCheckItem.getPluginParam())) break;
                        evt.setCancel(true);
                        break;
                    }
                    if (!Objects.equals(checkMethod, "1")) break;
                    Checker.checkArgument((boolean)Objects.nonNull(model.getValue(FIELD_CHECK_BILL_ID)), (String)ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u5bf9\u8c61\u201d\u4e0d\u80fd\u4e3a\u7a7a", (String)"ClosePeriodCheckItemPlugin_1", (String)"fi-fcm-formplugin", (Object[])new Object[0]), (FcmSystemType)FcmSystemType.FORMPLUGIN, (String)"ClosePeriodCheckItemTips_12", (Object[])new Object[0]);
                    Checker.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)((String)model.getValue("checkconditionjson_tag"))), (String)ResManager.loadKDString((String)"\u201c\u68c0\u67e5\u6761\u4ef6\u201d\u4e0d\u80fd\u4e3a\u7a7a", (String)"ClosePeriodCheckItemPlugin_2", (String)"fi-fcm-formplugin", (Object[])new Object[0]), (FcmSystemType)FcmSystemType.FORMPLUGIN, (String)"ClosePeriodCheckItemTips_11", (Object[])new Object[0]);
                    break;
                }
            }
        }
        super.beforeClick(evt);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        DynamicObject curEntity = this.getModel().getDataEntity();
        switch (key) {
            case "checkconditionexprbtn": {
                this.showCheckConditionForm();
                break;
            }
            case "pluginparamjson": {
                CheckItemDO curCheckItem = new CheckItemDO(curEntity);
                Long pluginId = curCheckItem.getCheckingPluginId();
                if (null != pluginId) {
                    Optional checkingPluginDO = ((ICheckingPluginService)this.checkItemPluginService.get()).getById((Serializable)pluginId);
                    if (!checkingPluginDO.isPresent()) break;
                    List pluginParamInfos = new DomainObjectCollection(((CheckingPluginDO)checkingPluginDO.get()).getParamInfos(), PluginParamEntryDO.class).toList();
                    this.showPluginParamView(pluginParamInfos, pluginId);
                    break;
                }
                this.getView().showTipNotification(FcmFormMsgs.selectPluginAtFirst());
                break;
            }
            case "save": 
            case "saveandnew": {
                Long newCheckItemId = curEntity.getLong("id");
                Long creatorOrgId = this.getModel().getDataEntity().getLong("createorg.id");
                String subBizAppId = curEntity.getString(FIELD_SUB_BIZ_APP_ID);
                ((ICheckItemStatusService)this.checkItemStatusService.get()).updateStatusByItemIdAndOrg(newCheckItemId, creatorOrgId, Boolean.TRUE, subBizAppId);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "checkconditionexprbtn": {
                if (null == returnData) break;
                JSONObject jsonObject = JSONObject.parseObject((String)((String)returnData));
                this.getModel().setValue("checkconditionjson_tag", (Object)jsonObject);
                this.getModel().setValue(FIELD_CHECK_CONDITION_EXPR_BTN, jsonObject.get((Object)"exprTran"));
                break;
            }
            case "pluginparamjson": {
                if (null == returnData) break;
                this.getModel().setValue(FIELD_PLUGIN_PARAM_JSON, returnData);
                break;
            }
        }
    }

    private void checkMethodChange(String value, boolean clearField) {
        if ("1".equals(value)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FIELD_CHECK_BILL_ID, FIELD_CHECK_CONDITION_EXPR_BTN, FIELD_BILL_VIEW_ID, FIELD_DISPLAY_CHECK_BILL});
            this.getView().setVisible(Boolean.FALSE, new String[]{FIELD_CHECK_PLUGIN_ID, FIELD_PLUGIN_PARAM_JSON});
            if (clearField) {
                this.clearFiled(new String[]{FIELD_CHECK_PLUGIN_ID});
            }
        } else if ("2".equals(value)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FIELD_CHECK_BILL_ID, FIELD_CHECK_CONDITION_EXPR_BTN, FIELD_BILL_VIEW_ID, FIELD_DISPLAY_CHECK_BILL});
            this.getView().setVisible(Boolean.TRUE, new String[]{FIELD_CHECK_PLUGIN_ID, FIELD_PLUGIN_PARAM_JSON});
            if (clearField) {
                this.clearFiled(new String[]{FIELD_CHECK_BILL_ID, FIELD_CHECK_CONDITION_EXPR_BTN, "checkconditionjson_tag", FIELD_BILL_VIEW_ID, FIELD_DISPLAY_CHECK_BILL});
            }
        }
    }

    private void initBizCloud(String value) {
        DevportalBizAppDO devportalBizAppDO = (DevportalBizAppDO)((IDevportalBizAppService)bizAppServiceService.get()).selectOne(new FilterLambdaBuilder("id", "=", (Object)value));
        BookRegisterInfo bookRegisterInfo = BookRegisterService.queryByBizApp((String)devportalBizAppDO.getNumber());
        if (null != bookRegisterInfo) {
            this.getModel().setValue("bizcloud", (Object)devportalBizAppDO.getBizCloudId());
            this.getModel().setValue("bizappid", (Object)value);
        } else {
            this.getModel().setValue("bizcloud", null);
            this.getModel().setValue("bizappid", null);
        }
    }

    private void bizAppChange(String value) {
        this.initCheckBill();
        ComboEdit comboEdit = (ComboEdit)this.getControl(FIELD_SUB_BIZ_APP_ID);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        List<ComboItem> comboItems = ClosePeriodCheckItemPlugin.getSubbizAppComboItemsByBizApp(value, org.getLong("id"));
        QFilter appqf = new QFilter("id", "=", (Object)value);
        DynamicObject appInfo = QueryServiceHelper.queryOne((String)"bos_devportal_bizapp", (String)"number,name", (QFilter[])appqf.toArray());
        Boolean accountbookExist = Boolean.FALSE;
        if (appInfo != null) {
            QFilter qFilter = new QFilter("bizapp", "=", (Object)appInfo.getString("number").toLowerCase());
            accountbookExist = QueryServiceHelper.exists((String)"bd_accountbookregister", (QFilter[])qFilter.toArray());
        }
        String accountTypeName = "";
        if (accountbookExist.booleanValue()) {
            accountTypeName = appInfo.getString("name");
        }
        if (StringUtils.isBlank((CharSequence)accountTypeName)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FIELD_SUB_BIZ_APP_ID});
            this.clearFiled(new String[]{FIELD_SUB_BIZ_APP_ID, FIELD_CHECK_BILL_ID, FIELD_DISPLAY_CHECK_BILL});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{FIELD_SUB_BIZ_APP_ID});
        comboEdit.setCaption(new LocaleString(accountTypeName));
        comboEdit.setComboItems(comboItems);
        this.clearFiled(new String[]{FIELD_SUB_BIZ_APP_ID, FIELD_CHECK_BILL_ID, FIELD_DISPLAY_CHECK_BILL});
    }

    public static List<ComboItem> getSubbizAppComboItemsByBizApp(String value, Long orgId) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        List subBizApps = ((IClosePeriodCheckItemService)FcmServiceFactory.getService(IClosePeriodCheckItemService.class)).listBaseInfoDO(value, orgId);
        if (null != subBizApps && !subBizApps.isEmpty()) {
            for (BaseInfoDO baseInfoEO : subBizApps) {
                if (!Objects.nonNull(baseInfoEO.getSourceDynamicObject())) continue;
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(baseInfoEO.getLocaleName()));
                comboItem.setValue(baseInfoEO.getId().toString());
                comboItems.add(comboItem);
            }
        }
        return comboItems;
    }

    private void showCheckConditionForm() {
        Object checkBill = this.getModel().getValue(FIELD_CHECK_BILL_ID);
        if (Objects.isNull(checkBill)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"ClosePeriodCheckItemPlugin_3", (String)"fi-fcm-formplugin", (Object[])new Object[0]));
        } else {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(DIALOG_CHECK_CONDITION_EXPR_BTN);
            Object checkConditionExpr = this.getModel().getValue("checkconditionjson_tag");
            showParameter.getCustomParams().put("formula", checkConditionExpr);
            showParameter.getCustomParams().put("context_orgid", ((DynamicObject)this.getModel().getValue(FIELD_USE_ORG)).getLong("id"));
            showParameter.getCustomParams().put("context_appcode", ((DynamicObject)this.getModel().getValue("bizappid")).getString("number"));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FIELD_CHECK_CONDITION_EXPR_BTN));
            String billEntity = ((DynamicObject)checkBill).getString("billnumber");
            showParameter.getCustomParams().put("entitynumber", billEntity);
            showParameter.getCustomParams().put("treenodes", this.findMatchFields(billEntity));
            ComboEdit comboEdit = (ComboEdit)this.getControl(FIELD_SUB_BIZ_APP_ID);
            if (comboEdit != null) {
                showParameter.getCustomParams().put("accountbooktype", this.getModel().getValue(FIELD_SUB_BIZ_APP_ID));
            }
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    private String findMatchFields(String entityName) {
        if (!ENTITY_FORMULA_TREE_CACHE.containsKey(entityName)) {
            MainEntityType srcMainET = EntityMetadataCache.getDataEntityType((String)entityName);
            EntityFieldTreeOption option = new EntityFieldTreeOption((IDataEntityType)srcMainET, true, null, null, ExpressionType.Formula, false);
            option.setEntityType((IDataEntityType)srcMainET);
            option.setIsReadEntryEntity(true);
            option.setExprType(ExpressionType.Formula);
            EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes((EntityFieldTreeOption)option);
            TreeNode tree = EntityTreeUtil.buildBillTree((List)result.getNodes());
            ENTITY_FORMULA_TREE_CACHE.put(entityName, SerializationUtils.toJsonString((Object)tree));
        }
        return ENTITY_FORMULA_TREE_CACHE.get(entityName);
    }

    private void clearFiled(String[] fields) {
        for (String field : fields) {
            this.getModel().setValue(field, null);
        }
    }

    private void showPluginParamView(List<PluginParamEntryDO> pluginParamInfos, Long pluginId) {
        if (CollectionUtils.isEmpty(pluginParamInfos)) {
            return;
        }
        List pluginParamDTOList = pluginParamInfos.stream().map(x -> PluginParamEntryDTO.buildFrom((PluginParamEntryDO)x)).collect(Collectors.toList());
        String paramSetterJson = new CheckItemDO(this.getModel().getDataEntity()).getPluginParam();
        Map paramSetter = (Map)SerializationUtils.fromJsonString((String)paramSetterJson, Map.class);
        pluginParamDTOList.stream().forEach(x -> x.setSetterValue((Object)paramSetter.getOrDefault(x.getCode(), x.getDefaultValue()).toString()));
        FormShowParameter paramPageParameter = new FormShowParameter();
        if (CollectionUtils.isNotEmpty(pluginParamDTOList)) {
            paramPageParameter.setFormId("fcm_checkitem_pluginparam");
            paramPageParameter.getOpenStyle().setShowType(ShowType.Modal);
            paramPageParameter.setCustomParam("pluginid", (Object)pluginId);
            paramPageParameter.setCustomParam("paraminfo", (Object)SerializationUtils.toJsonString(pluginParamDTOList));
            paramPageParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FIELD_PLUGIN_PARAM_JSON));
            this.getView().showForm(paramPageParameter);
        }
        this.getPageCache().put(PAGE_CACHE_KEY_PLUGIN_PARAM_PAGE, paramPageParameter.getPageId());
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        if (e.getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW)) {
            LicenseCheckResult result;
            boolean needNoCheck;
            String version = LicenseServiceHelper.getProductVersion();
            boolean isConstellation = LicenseServiceHelper.getModeType() == 3;
            boolean bl = needNoCheck = isConstellation && ImmutableSet.of((Object)"1.0", (Object)"2.0", (Object)"3.0").contains((Object)version);
            if (!needNoCheck && !(result = LicenseServiceHelper.checkPerformGroup((String)"PRO_FCM")).getHasLicense().booleanValue()) {
                e.setCancel(true);
                e.setCancelFormShowParameter(result.getCancelFormShowParameter());
            }
        }
    }

    private void initCheckBill() {
        ComboEdit checkBills = (ComboEdit)this.getControl(FIELD_DISPLAY_CHECK_BILL);
        ArrayList<ComboItem> checkBill = new ArrayList<ComboItem>();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue("bizappid");
        if (bizApp != null) {
            QFilter qFilter = new QFilter("checkingbill.bizappid", "=", bizApp.get("id")).or(String.join((CharSequence)".", "checkingbill", "bizappid", "masterid"), "=", bizApp.get("id"));
            filters.add(qFilter);
        } else {
            filters.add(QFilter.of((String)"1 != 1", (Object[])new Object[0]));
        }
        DynamicObjectCollection checkBillCollection = QueryServiceHelper.query((String)"fcm_checkingbill", (String)"id, checkingbill.name", (QFilter[])filters.toArray(new QFilter[0]));
        for (DynamicObject dynamicObject : checkBillCollection) {
            checkBill.add(new ComboItem(new LocaleString(dynamicObject.getString("checkingbill.name")), dynamicObject.getString("id")));
        }
        checkBills.setComboItems(checkBill);
        DynamicObject value = (DynamicObject)this.getModel().getValue(FIELD_CHECK_BILL_ID);
        this.getModel().setValue(FIELD_DISPLAY_CHECK_BILL, Objects.nonNull(value) ? value.get("id") : null);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setSkipNoField(true);
    }
}

