/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcm.formplugin.components;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.ConditionEdit;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.fcm.business.utils.gl.AccSysUtil;

public class FcmConditionEdit
extends ConditionEdit {
    public static final String TREE_VIEW_ROOT_VISIBLE = "treeViewRootVisible";
    private static final String NON_FIELDS = "nonFields";
    private static final String APP_GL = "gl";
    private static Pattern ACCOUNTTTABLE_CONDITION_PATTERN = Pattern.compile("(\\( accounttable\\..*? \\))");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("ffiltergrid");
        Map formCustParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgId = Long.parseLong(formCustParams.get("context_orgid").toString());
        String appCode = (String)formCustParams.get("context_appcode");
        Long accountBookTypeId = 0L;
        if (formCustParams.get("accountbooktype") != null && StringUtils.isNotEmpty((CharSequence)formCustParams.get("accountbooktype").toString())) {
            accountBookTypeId = Long.parseLong(formCustParams.get("accountbooktype").toString());
        }
        String conditionJson = (String)this.getView().getFormShowParameter().getCustomParam("formula");
        CRFormula formulaObj = this.deserialize(conditionJson);
        this.getFormulaObj(formulaObj);
        filterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)new EntityFieldF7Listener(orgId, appCode, formulaObj, this.getEntityType(), accountBookTypeId));
    }

    private MainEntityType getEntityType() {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParams().get("entitynumber");
        return EntityMetadataCache.getDataEntityType((String)entityNumber);
    }

    private static class EntityFieldF7Listener
    implements BeforeFilterF7SelectListener {
        private Long orgId;
        private String appCode;
        private CRFormula curFormulaObj;
        private MainEntityType curEntityType;
        private Long bookTypeId;

        private EntityFieldF7Listener(Long orgId, String appCode, CRFormula curFormulaObj, MainEntityType curEntityType, Long bookTypeId) {
            this.orgId = orgId;
            this.appCode = appCode;
            this.curFormulaObj = curFormulaObj;
            this.curEntityType = curEntityType;
            this.bookTypeId = bookTypeId;
        }

        public void beforeF7Select(BeforeFilterF7SelectEvent evt) {
            if (!FcmConditionEdit.APP_GL.equals(this.appCode)) {
                return;
            }
            switch (evt.getRefEntityId()) {
                case "bd_accountview": {
                    String curConditionStr;
                    DynamicObject accountBook;
                    if (this.orgId != 0L) {
                        evt.getCustomQFilters().add(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)this.orgId));
                    }
                    if (this.bookTypeId != 0L && AccSysUtil.isBizUnitInBDControlOrg((Long)this.orgId) && (accountBook = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"accounttable", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.orgId), new QFilter("bookstype", "=", (Object)this.bookTypeId)})) != null) {
                        evt.getCustomQFilters().add(new QFilter("accounttable", "=", (Object)accountBook.getLong("accounttable")));
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)(curConditionStr = ((CRCondition)this.curFormulaObj).buildFullFormula(this.curEntityType)))) break;
                    Matcher matcher = ACCOUNTTTABLE_CONDITION_PATTERN.matcher(curConditionStr);
                    ArrayList<String> filterConditions = new ArrayList<String>(1);
                    while (matcher.find()) {
                        filterConditions.add(matcher.group(1));
                    }
                    if (filterConditions.isEmpty()) break;
                    filterConditions.stream().forEach(x -> evt.getCustomQFilters().add(QFilter.of((String)x, (Object[])new Object[0])));
                    break;
                }
                case "gl_vouchertype": {
                    evt.addCustomQFilter(BaseDataServiceHelper.getBaseDataFilter((String)"gl_vouchertype", (Long)this.orgId));
                }
            }
        }
    }
}

