/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcm.formplugin.financialclose;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterInfo;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterService;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.bd.financialclose.FinancialCloseInfo;
import kd.fi.bd.util.ContextUtil;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.fcm.formplugin.financialclose.FinancialCloseListDataProvider;
import kd.fi.fcm.formplugin.financialclose.SelectRowData;
import kd.fi.fcm.formplugin.financialclose.common.CloseStateEnum;
import kd.fi.fcm.formplugin.financialclose.common.FinancialCloseUtils;

public class FinancialCloseList
extends AbstractListPlugin
implements ClickListener {
    private static final Log log = LogFactory.getLog(FinancialCloseList.class);
    private static final String PERM_CLOSE = "4730fc9f000001ae";
    private static final String BTN_CLOSE = "tbclose";
    private static final String FINANCIAL_CLOSE_ENTITY = "fcm_financialclose";
    private static final String OFF_PROGRESSBAR = "offProgressbar";
    private static final String VALID_STATE = "1";
    private static final String BIZ_APP_FILTER = "bizappid.name";

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new FinancialCloseListDataProvider((ListView)this.getView()));
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        QFilter filter;
        super.filterContainerBeforeF7Select(args);
        String field = args.getFieldName();
        if (field.startsWith("org.")) {
            List<Long> orgIds = FinancialCloseUtils.getAuthorizedBankOrgId("fcm", ContextUtil.getUserId(), FINANCIAL_CLOSE_ENTITY, "47150e89000000ac");
            filter = null;
            if (CollectionUtils.isNotEmpty(orgIds)) {
                filter = new QFilter("id", "in", orgIds);
            }
            args.addCustomQFilter(filter);
        }
        if (BIZ_APP_FILTER.equals(field)) {
            List<String> appIds = this.getAppConfig();
            filter = new QFilter("id", "in", appIds);
            args.addCustomQFilter(filter);
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        String field;
        super.filterColumnSetFilter(args);
        switch (field = args.getFieldName()) {
            case "org.name": {
                QFilter filter = this.getBookOrgFilter();
                args.getQFilters().add(filter);
                break;
            }
            case "bizappid.name": {
                List<String> appIds = this.getAppConfig();
                args.getQFilters().add(new QFilter("id", "in", appIds));
                break;
            }
        }
    }

    private QFilter getBookOrgFilter() {
        Long userID = ContextUtil.getUserId();
        List<Long> orgIds = FinancialCloseUtils.getAuthorizedBankOrgId("fcm", userID, FINANCIAL_CLOSE_ENTITY, "47150e89000000ac");
        QFilter qFilter = null;
        if (CollectionUtils.isNotEmpty(orgIds)) {
            qFilter = new QFilter("id", "in", orgIds);
        }
        return qFilter;
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List listFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (CommonFilterColumn commFilter : listFilterColumns) {
            String fieldName = commFilter.getFieldName();
            if ("org.name".equals(fieldName)) {
                String defaultOrg = this.getPageCache().get("orgId");
                if (defaultOrg == null) {
                    long orgId = FinancialCloseUtils.getAuthorizedBankOrgId("fcm", ContextUtil.getUserId(), FINANCIAL_CLOSE_ENTITY, "47150e89000000ac").get(0);
                    defaultOrg = String.valueOf(orgId);
                    this.getPageCache().put("orgId", defaultOrg);
                }
                commFilter.setDefaultValue(defaultOrg);
                continue;
            }
            if (!BIZ_APP_FILTER.equals(fieldName)) continue;
            List accountTableIds = null;
            ControlFilters controlFilters = ((IListView)this.getView()).getControlFilters();
            if (controlFilters != null) {
                accountTableIds = controlFilters.getFilter("bizappid.id");
            }
            if (accountTableIds != null && !accountTableIds.isEmpty()) {
                commFilter.setDefaultValues(accountTableIds);
                continue;
            }
            commFilter.setDefaultValue("83bfebc8000017ac");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "tbclose": {
                ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
                if (selectedRows.isEmpty()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\uff01", (String)"FinancialCloseList_0", (String)"fi-fcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                StringBuilder confirmMsg = new StringBuilder();
                String headMsg = ResManager.loadKDString((String)"\u4e0b\u5217\u8d26\u7c3f\u5c06\u8fdb\u884c\u7ed3\u8d26\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PeriodcloseHomePlugin_15", (String)"fi-gl-formplugin", (Object[])new Object[0]);
                String msgTemplate = ResManager.loadKDString((String)"%1$s\u7684%2$s%3$s\uff1a%4$s\uff1b", (String)"PeriodcloseHomePlugin_14", (String)"fi-gl-formplugin", (Object[])new Object[0]);
                selectedRows.stream().forEach(listSelectedRow -> {
                    SelectRowData rowData = SelectRowData.stringSplitToObject(listSelectedRow.getBillNo());
                    confirmMsg.append(String.format(msgTemplate, rowData.getOrgName(), rowData.getBizAppName(), rowData.getType(), rowData.getCurperiodName())).append("\r\n");
                });
                this.getView().showConfirm(headMsg, confirmMsg.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(BTN_CLOSE));
                break;
            }
        }
    }

    private String checkSubSysCloseState(SelectRowData selectRowData) {
        Long orgId = selectRowData.getOrgId();
        String bizAppId = selectRowData.getBizAppId();
        Long booksTypeId = Long.valueOf(selectRowData.getBooksTypeIdStr());
        Long curperiodId = selectRowData.getCurperiodId();
        String orgName = selectRowData.getOrgName();
        String typeName = selectRowData.getType();
        String appName = selectRowData.getBizAppName();
        if (!selectRowData.getFinishInit().booleanValue()) {
            if (StringUtils.isEmpty((String)typeName)) {
                return String.format(ResManager.loadKDString((String)"%1$s\u7684%2$s%3$s\u8d26\u7c3f\u672a\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u7ed3\u8d26\u3002", (String)"FinancialCloseList_4", (String)"fi-fcm-formplugin", (Object[])new Object[0]), orgName, appName, typeName);
            }
            return String.format(ResManager.loadKDString((String)"%1$s\u7684\u8d26\u7c3f\uff1a%2$s%3$s\u672a\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u7ed3\u8d26\u3002", (String)"FinancialCloseList_6", (String)"fi-fcm-formplugin", (Object[])new Object[0]), orgName, appName, typeName);
        }
        boolean isClosing = this.existsCloseData(orgId, bizAppId, booksTypeId, curperiodId, CloseStateEnum.CLOSING.getCode());
        if (isClosing) {
            return String.format(ResManager.loadKDString((String)"%1$s\u7684%2$s%3$s\u6b63\u5728\u7ed3\u8d26\u4e2d\uff0c\u8bf7\u7a0d\u540e\u5237\u65b0\u5217\u8868\u3002", (String)"FinancialCloseList_2", (String)"fi-fcm-formplugin", (Object[])new Object[0]), orgName, appName, typeName);
        }
        return "";
    }

    private void showForm(String requestId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fcm_financialprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OFF_PROGRESSBAR));
        showParameter.setCustomParam("requestId", (Object)requestId);
        this.getView().showForm(showParameter);
    }

    private boolean existsCloseData(Long orgId, String bizAppId, Long booksTypeId, Long curperiodId, String closeState) {
        QFilterBuilder qFilterBuilder = new QFilterBuilder();
        qFilterBuilder.and(new QFilter("org", "=", (Object)orgId)).and(new QFilter("booktypeid", "=", (Object)booksTypeId)).and(new QFilter("curperiod", "=", (Object)curperiodId)).and(new QFilter("bizappid", "=", (Object)bizAppId)).and(new QFilter("closestate", "=", (Object)closeState)).and(new QFilter("state", "=", (Object)VALID_STATE));
        return QueryServiceHelper.exists((String)"fcm_financialcloselog", (QFilter[])qFilterBuilder.toArray(new QFilter[0]));
    }

    private FinancialCloseInfo buildFinancialCloseInfo(SelectRowData selectRowData, String pageId, String requestId) {
        FinancialCloseInfo closeInfo = new FinancialCloseInfo();
        closeInfo.setBizAppNumber(BizAppServiceHelp.getAppNumByAppId((String)selectRowData.getBizAppId()));
        closeInfo.setBizAppId(selectRowData.getBizAppId());
        closeInfo.setBookType((Object)Long.valueOf(selectRowData.getBooksTypeIdStr()));
        closeInfo.setCurPeriodId((Object)selectRowData.getCurperiodId());
        closeInfo.setOrg(selectRowData.getOrgId());
        closeInfo.setPageId(pageId);
        closeInfo.setCurperiodName(selectRowData.getCurperiodName());
        closeInfo.setRequestContextStr(SerializationUtils.serializeToBase64((Object)RequestContext.get()));
        closeInfo.setRequestId(requestId);
        return closeInfo;
    }

    private void asynQuery(FinancialCloseInfo closeInfo) {
        try (MessagePublisher mp = MQFactory.get().createSimplePublisher("fi", "fi.bd.financialclose_queue");){
            mp.publish(SerializationUtils.toJsonString((Object)closeInfo));
        }
    }

    public void saveLog(Long orgId, String bizAppId, Long booksTypeId, Long curperiodId, String pageId, String requestId) {
        DynamicObject logInfo = this.buildLogInfo(orgId, bizAppId, booksTypeId, curperiodId, pageId, requestId);
        DynamicObject[] dynamicObjects = new DynamicObject[]{logInfo};
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("update t_fcm_financialcloselog set fstate='0' where forgid = ? ", new Object[]{orgId});
        sqlBuilder.append(" and fbooktypeid  = ? ", new Object[]{booksTypeId});
        sqlBuilder.append(" and fbizappid  = ? ", new Object[]{bizAppId});
        sqlBuilder.append("  and fstate='1' ", new Object[0]);
        DB.execute((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }

    private DynamicObject buildLogInfo(long orgId, String bizAppId, Long booksTypeId, Long curperiodId, String pageId, String requestId) {
        DynamicObject logInfo = BusinessDataServiceHelper.newDynamicObject((String)"fcm_financialcloselog");
        logInfo.set("org", (Object)orgId);
        logInfo.set("bizappid", (Object)bizAppId);
        logInfo.set("booktypeid", (Object)booksTypeId);
        logInfo.set("curperiod", (Object)curperiodId);
        logInfo.set("closestate", (Object)CloseStateEnum.CLOSING.getCode());
        logInfo.set("closeuser", (Object)RequestContext.get().getCurrUserId());
        logInfo.set("closedate", (Object)new Date());
        logInfo.set("pageid", (Object)pageId);
        logInfo.set("state", (Object)VALID_STATE);
        logInfo.set("requestid", (Object)requestId);
        return logInfo;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (OFF_PROGRESSBAR.equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (BTN_CLOSE.equals(callBackId) && MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
            String pageId = this.getView().getPageId();
            String requestId = RequestContext.get().getRequestId();
            if (this.validate(selectedRows).booleanValue()) {
                for (ListSelectedRow row : selectedRows) {
                    String billNo = row.getBillNo();
                    SelectRowData selectRowData = SelectRowData.stringSplitToObject(billNo);
                    try {
                        this.saveLogAndSendCloseMq(selectRowData, pageId, requestId);
                    }
                    catch (Exception e) {
                        log.info("saveLogAndSendCloseMq org:{},bizApp:{},type:{},e:{}", new Object[]{selectRowData.getOrgName(), selectRowData.getBizAppName(), selectRowData.getType(), e});
                        throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
                    }
                }
                this.showForm(requestId);
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        if ("checkdetails".equals(fieldName)) {
            String id = ((IListView)this.getView()).getFocusRowPkId().toString();
            String link = this.getView().getPageCache().get(id);
            FormShowParameter formShowParameter = FormShowParameter.fromJsonString((String)link);
            formShowParameter.setSessionId(RequestContext.get().getGlobalSessionId());
            this.getView().showForm(formShowParameter);
            args.setCancel(true);
        }
    }

    public void saveLogAndSendCloseMq(SelectRowData selectRowData, String pageId, String requestId) {
        try (TXHandle handler = TX.requiresNew();){
            try {
                this.saveLog(selectRowData.getOrgId(), selectRowData.getBizAppId(), Long.valueOf(selectRowData.getBooksTypeIdStr()), selectRowData.getCurperiodId(), pageId, requestId);
                FinancialCloseInfo closeInfo = this.buildFinancialCloseInfo(selectRowData, pageId, requestId);
                this.asynQuery(closeInfo);
            }
            catch (Exception e) {
                handler.markRollback();
                log.error(e.getMessage(), (Throwable)e);
                throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        }
    }

    private Boolean validate(ListSelectedRowCollection selectedRows) {
        for (ListSelectedRow row : selectedRows) {
            String billNo = row.getBillNo();
            SelectRowData selectRowData = SelectRowData.stringSplitToObject(billNo);
            String checkRes = this.checkSubSysCloseState(selectRowData);
            if (!StringUtils.isNotEmpty((String)checkRes)) continue;
            this.getView().showErrorNotification(checkRes);
            return false;
        }
        return true;
    }

    private List<String> getAppConfig() {
        ArrayList<String> appIds = new ArrayList<String>(16);
        BookRegisterService registerService = new BookRegisterService();
        List registerInfoList = registerService.queryAll();
        for (BookRegisterInfo registerInfo : registerInfoList) {
            String appNumber = registerInfo.getBizApp();
            appIds.add(BizAppServiceHelp.getAppIdByAppNumber((String)appNumber));
        }
        return appIds;
    }
}

