/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcm.formplugin.financialclose;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.list.QueryResult;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterInfo;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterService;
import kd.bos.list.query.impl.Query;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.util.JSONUtils;
import kd.fi.fcm.common.domain.fcm.AccountBookInfo;
import kd.fi.fcm.common.domain.fcm.AccountBookRes;
import kd.fi.fcm.formplugin.financialclose.SelectRowData;
import kd.fi.fcm.formplugin.financialclose.common.FinancialCloseField;
import kd.fi.fcm.formplugin.financialclose.common.FinancialCloseUtils;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;

public class FinancialCloseListQuery
extends Query {
    private static final String VALID_STATE = "1";
    private ListView view;

    public FinancialCloseListQuery(ListView view) {
        this.view = view;
    }

    public DynamicObjectCollection getData(QueryBuilder queryBuilder) {
        DynamicObjectType returnType = queryBuilder.getReturnEntityType();
        QFilter[] filters = queryBuilder.getFilters();
        DataSet allDataSet = this.initResDataSet();
        QFilter[] orgFilters = FinancialCloseUtils.remainOrgFilters(filters);
        String appIdValues = null;
        if (filters != null && filters.length > 0) {
            for (QFilter filter : filters) {
                if (!"bizappid.id".equals(filter.getProperty())) continue;
                appIdValues = filter.getValue().toString();
                break;
            }
            allDataSet = this.getDataSetByApp(allDataSet, appIdValues, orgFilters);
        } else {
            allDataSet = this.getAllResDataSet(orgFilters, allDataSet);
        }
        return this.buildResult(queryBuilder, allDataSet, returnType);
    }

    private DataSet getDataSetByApp(DataSet allDataSet, String appIdValues, QFilter[] orgFilters) {
        if (appIdValues != null && appIdValues.length() > 0) {
            String[] appIdValueArray = appIdValues.split(",");
            if (appIdValueArray.length == 1) {
                allDataSet = this.getAccountBook(orgFilters, appIdValueArray[0]);
            } else {
                appIdValueArray = appIdValues.substring(1, appIdValues.length() - 1).split(",");
                allDataSet = this.getMultiAppData(allDataSet, appIdValueArray, orgFilters);
            }
        } else {
            allDataSet = this.getAllResDataSet(orgFilters, allDataSet);
        }
        return allDataSet;
    }

    private DataSet getMultiAppData(DataSet allDataSet, String[] appIdValueArray, QFilter[] orgFilters) {
        for (int i = 0; i < appIdValueArray.length; ++i) {
            String appId = appIdValueArray[i].trim();
            if (i == 0) {
                allDataSet = this.getAccountBook(orgFilters, appId);
                continue;
            }
            DataSet dataSet = this.getAccountBook(orgFilters, appId);
            allDataSet = allDataSet.union(dataSet);
        }
        return allDataSet;
    }

    private DynamicObjectCollection buildResult(QueryBuilder queryBuilder, DataSet allDataSet, DynamicObjectType returnType) {
        DynamicObjectCollection result = new DynamicObjectCollection(returnType, null);
        QFilter[] filters = queryBuilder.getFilters();
        int start = queryBuilder.getStart();
        int limit = queryBuilder.getLimit();
        filters = FinancialCloseUtils.removeFiltersFiled(filters, new String[]{"bizappid.id", "org"});
        int sumCount = 0;
        allDataSet = this.filterData(allDataSet, filters);
        for (Row ignored : allDataSet.copy()) {
            ++sumCount;
        }
        DataSet pageDataSet = allDataSet.limit(start, limit);
        result.beginInit();
        Map<Long, DynamicObject> orgMap = FinancialCloseUtils.getOrgInfo(pageDataSet.copy());
        HashMap<String, DynamicObject> bizappidMap = new HashMap<String, DynamicObject>();
        int i = start;
        for (Row row : pageDataSet) {
            if (!bizappidMap.containsKey(row.getString("bizappid"))) {
                bizappidMap.put(row.getString("bizappid"), BusinessDataServiceHelper.loadSingle((Object)row.getString("bizappid"), (String)"bos_devportal_bizapp", (String)"id,number,name"));
            }
            DynamicObject entity = new DynamicObject(returnType);
            Long orgId = row.getLong("org");
            String bizAppId = row.getString("bizappid");
            Long booksTypeId = row.getLong("bookstypeid");
            Long curperiodId = row.getLong("curperiodid");
            String typeName = row.getString("typename");
            String curperiodName = row.getString("curperiodname");
            entity.set("id", (Object)(++i));
            entity.set("org", (Object)orgMap.get(orgId));
            entity.set("bizappid", bizappidMap.get(bizAppId));
            entity.set("curperiodid", (Object)curperiodId);
            entity.set("curperiodname", (Object)curperiodName);
            entity.set("periodtypeid", (Object)row.getLong("periodtypeid"));
            entity.set("periodtypename", (Object)row.getString("periodtypename"));
            entity.set("bookstypeid", (Object)booksTypeId);
            entity.set("typename", (Object)typeName);
            entity.set("closestate", (Object)row.getString("closestate"));
            entity.set("dealres", (Object)row.getString("dealres"));
            entity.set("faildetails", (Object)row.getString("faildetails"));
            String link = row.getString("detailslink_tag");
            entity.set("detailslink_tag", (Object)link);
            if (StringUtils.isNotEmpty((CharSequence)link)) {
                entity.set("checkDetails", (Object)ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"FinancialCloseListQuery_0", (String)"fi-fcm-formplugin", (Object[])new Object[0]));
                this.view.getPageCache().put(entity.getString("id"), link);
            }
            String booksTypeIdStr = booksTypeId == null ? "0" : booksTypeId.toString();
            SelectRowData selectRowData = new SelectRowData();
            selectRowData.setOrgId(orgId);
            selectRowData.setBizAppId(bizAppId);
            selectRowData.setBooksTypeIdStr(booksTypeIdStr);
            selectRowData.setCurperiodId(curperiodId);
            selectRowData.setOrgName(entity.getDynamicObject("org").get("name").toString());
            selectRowData.setType(typeName == null ? "" : typeName);
            selectRowData.setCurperiodName(curperiodName);
            selectRowData.setBizAppName(entity.getDynamicObject("bizappid").get("name").toString());
            Boolean finishInit = row.getBoolean("isfinishinit");
            selectRowData.setFinishInit(finishInit);
            entity.set("billno", (Object)selectRowData.toString());
            entity.set("startperiodname", (Object)row.getString("startperiodname"));
            entity.set("isfinishinit", (Object)finishInit);
            result.add((Object)entity);
        }
        result.endInit();
        this.setQueryResult(result, sumCount, sumCount);
        this.view.getPageCache().put("realCount", String.valueOf(sumCount));
        return result;
    }

    private void setQueryResult(DynamicObjectCollection collection, int dataCount, int billDataCount) {
        QueryResult queryResult = this.getQueryResult();
        queryResult.setCollection(collection);
        queryResult.setDataCount(dataCount);
        queryResult.setBillDataCount(billDataCount);
    }

    private DataSet initResDataSet() {
        DataType[] dataTypes = new DataType[]{DataType.LongType, DataType.LongType, DataType.StringType, DataType.LongType, DataType.StringType, DataType.LongType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.LongType, DataType.StringType, DataType.StringType};
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])FinancialCloseField.LIST_FIELDS, (DataType[])dataTypes);
        return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(Collections.emptyIterator(), rowMeta);
    }

    private DataSet getAllResDataSet(QFilter[] orgFilters, DataSet allDataSet) {
        List registerInfoList = BookRegisterService.queryAll();
        for (BookRegisterInfo registerInfo : registerInfoList) {
            String appId = BizAppServiceHelp.getAppIdByAppNumber((String)registerInfo.getBizApp());
            DataSet dataSet = this.getAccountBook(orgFilters, appId);
            allDataSet = allDataSet.union(dataSet);
        }
        return allDataSet;
    }

    private DataSet getDataSet(DataSet closeData, String appId, QFilter[] logFilter, String bookMeta) {
        DataSet dataSetLog = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"fcm_financialcloselog", (String)"org,bizappid,booktypeid,curperiod,faildetails,detailslink_tag,dealres,closestate", (QFilter[])logFilter, null);
        closeData = closeData.addField(this.addSingleQuotes(appId), "bizappid");
        DataSet joinDataSet = StringUtils.isEmpty((CharSequence)bookMeta) ? closeData.leftJoin(dataSetLog).on("org", "org").on("curperiodid", "curperiod").select(FinancialCloseField.LIST_FIELDS).finish() : closeData.leftJoin(dataSetLog).on("org", "org").on("bookstypeid", "booktypeid").on("curperiodid", "curperiod").select(FinancialCloseField.LIST_FIELDS).finish();
        return joinDataSet;
    }

    private DataSet getAccountBook(QFilter[] orgFilters, String appId) {
        String appNumber = BizAppServiceHelp.getAppNumByAppId((String)appId);
        BookRegisterInfo registerInfo = BookRegisterService.queryByBizApp((String)appNumber);
        QFilter orgFilter = null;
        List orgIds = new ArrayList();
        if (orgFilters != null && orgFilters.length > 0) {
            orgFilter = orgFilters[0];
            orgIds = (List)orgFilter.getValue();
        }
        QFilter appIdFilter = new QFilter("bizappid", "=", (Object)appId);
        QFilter stateFilter = new QFilter("state", "=", (Object)VALID_STATE);
        QFilter[] logFilter = new QFilter[]{orgFilter, stateFilter, appIdFilter};
        if (registerInfo != null) {
            String queryService = registerInfo.getQueryBookMservice();
            String bookMeta = null;
            if (StringUtils.isNotEmpty((CharSequence)queryService)) {
                HashMap<String, Object> map = new HashMap<String, Object>(4);
                map.put("appNum", appNumber);
                map.put("orgIds", orgIds);
                if (StringUtils.isNotEmpty((CharSequence)registerInfo.getBookTypeFieldOnBookEntity())) {
                    bookMeta = FinancialCloseUtils.getBookMetaData(registerInfo.getBookEntityId(), registerInfo.getBookTypeFieldOnBookEntity());
                }
                DataSet closeData = this.getServiceBookData(queryService, bookMeta, map);
                return this.getDataSet(closeData, appId, logFilter, bookMeta);
            }
        }
        return this.initResDataSet();
    }

    private DataSet getServiceBookData(String queryService, String bookMeta, Map map) {
        List bookResList;
        String[] args = queryService.split(",");
        String result = (String)DispatchServiceHelper.invokeBizService((String)args[0], (String)args[1], (String)args[2], (String)args[3], (Object[])new Object[]{map});
        try {
            bookResList = (List)JSONUtils.cast((String)result, List.class, (Class[])new Class[]{AccountBookRes.class});
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
        HashSet<Long> bookTypeId = new HashSet<Long>(16);
        HashSet<Long> periodTypeId = new HashSet<Long>(16);
        HashSet<Long> currentPeriodId = new HashSet<Long>(16);
        for (AccountBookRes accountBookRes : bookResList) {
            bookTypeId.add(accountBookRes.getBookTypeId());
            periodTypeId.add(accountBookRes.getPeriodTypeId());
            currentPeriodId.add(accountBookRes.getCurrentPeriodId());
            currentPeriodId.add(accountBookRes.getStartPeriodId());
        }
        QFilter bookTypeIdFilter = new QFilter("id", "in", bookTypeId);
        QFilter periodTypeIdFilter = new QFilter("id", "in", periodTypeId);
        QFilter periodIdFilter = new QFilter("id", "in", currentPeriodId);
        DynamicObject[] bookType = null;
        if (StringUtils.isNotEmpty((CharSequence)bookMeta)) {
            bookType = BusinessDataServiceHelper.load((String)bookMeta, (String)"id,name", (QFilter[])bookTypeIdFilter.toArray());
        }
        DynamicObject[] periodType = BusinessDataServiceHelper.load((String)"bd_period_type", (String)"id,name", (QFilter[])periodTypeIdFilter.toArray());
        DynamicObject[] period = BusinessDataServiceHelper.load((String)"bd_period", (String)"id,name", (QFilter[])periodIdFilter.toArray());
        HashMap<Long, String> bookTypeMap = new HashMap<Long, String>(16);
        HashMap<Long, String> periodTypeMap = new HashMap<Long, String>(16);
        HashMap<Long, String> periodMap = new HashMap<Long, String>(16);
        if (bookType != null) {
            for (DynamicObject row : bookType) {
                bookTypeMap.put(row.getLong("id"), row.getString("name"));
            }
        }
        for (DynamicObject row : periodType) {
            periodTypeMap.put(row.getLong("id"), row.getString("name"));
        }
        for (DynamicObject row : period) {
            periodMap.put(row.getLong("id"), row.getString("name"));
        }
        ArrayList<AccountBookInfo> bookInfos = new ArrayList<AccountBookInfo>(16);
        for (AccountBookRes accountBookRes : bookResList) {
            AccountBookInfo accountBookInfo = new AccountBookInfo();
            try {
                BeanUtils.copyProperties((Object)accountBookInfo, (Object)accountBookRes);
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
                throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
            accountBookInfo.setTypeName((String)bookTypeMap.get(accountBookInfo.getBookTypeId()));
            accountBookInfo.setPeriodTypeName((String)periodTypeMap.get(accountBookInfo.getPeriodTypeId()));
            accountBookInfo.setCurrentPeriodName((String)periodMap.get(accountBookInfo.getCurrentPeriodId()));
            accountBookInfo.setStartPeriodName((String)periodMap.get(accountBookInfo.getStartPeriodId()));
            bookInfos.add(accountBookInfo);
        }
        ArrayList<String> fields = new ArrayList<String>(16);
        fields.add("org");
        fields.add("startperiodid");
        fields.add("curperiodid");
        fields.add("bookstypeid");
        fields.add("periodtypeid");
        fields.add("isfinishinit");
        fields.add("typename");
        fields.add("periodtypename");
        fields.add("curperiodname");
        fields.add("startperiodname");
        ArrayList<DataType> dataTypes = new ArrayList<DataType>(16);
        dataTypes.add((DataType)DataType.LongType);
        dataTypes.add((DataType)DataType.LongType);
        dataTypes.add((DataType)DataType.LongType);
        dataTypes.add((DataType)DataType.LongType);
        dataTypes.add((DataType)DataType.LongType);
        dataTypes.add((DataType)DataType.StringType);
        dataTypes.add((DataType)DataType.StringType);
        dataTypes.add((DataType)DataType.StringType);
        dataTypes.add((DataType)DataType.StringType);
        dataTypes.add((DataType)DataType.StringType);
        ArrayList<List<Object>> values = new ArrayList<List<Object>>(16);
        for (AccountBookInfo bookInfo : bookInfos) {
            ArrayList<Object> row = new ArrayList<Object>(16);
            row.add(bookInfo.getOrgId());
            row.add(bookInfo.getStartPeriodId());
            row.add(bookInfo.getCurrentPeriodId());
            row.add(bookInfo.getBookTypeId());
            row.add(bookInfo.getPeriodTypeId());
            row.add(bookInfo.getIsEndInit());
            row.add(bookInfo.getTypeName());
            row.add(bookInfo.getPeriodTypeName());
            row.add(bookInfo.getCurrentPeriodName());
            row.add(bookInfo.getStartPeriodName());
            values.add(row);
        }
        return FinancialCloseUtils.createDatSet(((Object)((Object)this)).getClass(), fields, dataTypes, values);
    }

    private DataSet filterData(DataSet dataSet, QFilter[] filters) {
        block17: for (QFilter filter : filters) {
            String cp = filter.getCP();
            String property = filter.getProperty();
            String value = filter.getValue() == null ? "" : filter.getValue().toString();
            switch (cp) {
                case "ftlike": 
                case "like": {
                    String filterStr = property + " like " + this.addSingleQuotes(value);
                    dataSet = dataSet.filter(filterStr);
                    continue block17;
                }
                case "not like": {
                    dataSet = dataSet.filter(property + " not like " + this.addSingleQuotes(value));
                    continue block17;
                }
                case "=": {
                    dataSet = this.filterEqualsData(dataSet, property, value);
                    continue block17;
                }
                case "!=": {
                    dataSet = dataSet.filter(property + " != " + this.addSingleQuotes(value));
                    continue block17;
                }
                case "is not null": {
                    dataSet = dataSet.filter(property + " is not null ");
                    continue block17;
                }
                case "in": {
                    dataSet = dataSet.filter(filter.toString());
                    continue block17;
                }
            }
        }
        return dataSet.orderBy(new String[]{"bizappid", "org"});
    }

    private DataSet filterEqualsData(DataSet dataSet, String property, String value) {
        dataSet = "EMPTY".equals(value) ? dataSet.filter(property + " is null or " + property + " =' '") : dataSet.filter(property + " = " + this.addSingleQuotes(value));
        return dataSet;
    }

    private String addSingleQuotes(String value) {
        return "'" + value + "'";
    }
}

