/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcm.formplugin.financialclose;

import java.text.NumberFormat;
import java.util.EventObject;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.fcm.formplugin.financialclose.common.CloseStateEnum;

public class FinancialProgressPlugin
extends AbstractFormPlugin
implements ClickListener,
ProgresssListener {
    private int progressNum = 0;
    private static final String PROGRESS_BAR = "progressbarap";
    private static final Log log = LogFactory.getLog(FinancialProgressPlugin.class);
    private static final String TIPS_LABEL = "tipslabel";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESS_BAR);
        bar.start();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESS_BAR);
        bar.addProgressListener((ProgresssListener)this);
    }

    public void onProgress(ProgressEvent progressEvent) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        int allCount = 0;
        String requestId = (String)parameter.getCustomParam("requestId");
        ++this.progressNum;
        QFilter pageFilter = new QFilter("requestid", "=", (Object)requestId);
        QFilter stateFilter = new QFilter("state", "=", (Object)"1");
        QFilter[] qFilters = new QFilter[]{pageFilter, stateFilter};
        int successCount = 0;
        int failCount = 0;
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"fcm_financialcloselog", (String)"closestate", (QFilter[])qFilters, null);
        for (Row row : dataSet) {
            ++allCount;
            String closeState = row.getString("closestate");
            if (CloseStateEnum.SUCCESS.getCode().equals(closeState)) {
                ++successCount;
                continue;
            }
            if (!CloseStateEnum.FAIL.getCode().equals(closeState)) continue;
            ++failCount;
        }
        int finishCount = successCount + failCount;
        String tips = String.format(ResManager.loadKDString((String)"\u5171\uff1a%1$d\u6761\uff0c\u6210\u529f\uff1a%2$d\u6761\uff0c\u5931\u8d25\uff1a%3$d\u6761", (String)"FinancialProgressPlugin_2", (String)"fi-fcm-formplugin", (Object[])new Object[0]), allCount, successCount, failCount);
        if (allCount == finishCount) {
            progressEvent.setProgress(100);
            progressEvent.setText(ResManager.loadKDString((String)"\u7ed3\u8d26\u5b8c\u6210", (String)"FinancialProgressPlugin_0", (String)"fi-fcm-formplugin", (Object[])new Object[0]));
            this.setProgressTip(tips);
            ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESS_BAR);
            bar.stop();
        } else if (this.progressNum <= BillParamUtil.getIntegerValue((String)"104BM8137+43", (String)"fi.fcm.financialprogress.maxnum", (int)720)) {
            int progress = this.calcProgress(finishCount, allCount);
            if (progress < 100) {
                progressEvent.setProgress(progress);
                progressEvent.setText(ResManager.loadKDString((String)"\u7ed3\u8d26\u4e2d", (String)"FinancialProgressPlugin_1", (String)"fi-fcm-formplugin", (Object[])new Object[0]));
                this.setProgressTip(tips);
            }
        } else {
            log.info("progressNum--over:" + this.progressNum);
            ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESS_BAR);
            bar.stop();
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btnok": {
                this.getView().close();
                break;
            }
        }
    }

    private int calcProgress(int finishCount, int allCount) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(0);
        return Integer.parseInt(numberFormat.format((float)finishCount / (float)allCount * 100.0f));
    }

    private void setProgressTip(String tip) {
        Label lblTip = (Label)this.getControl(TIPS_LABEL);
        lblTip.setText(tip);
    }
}

