/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcm.formplugin.financialclose.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bd.util.ContextUtil;
import kd.fi.bd.util.DebugTrace;
import org.apache.commons.lang3.StringUtils;

public class FinancialCloseUtils {
    private static final Log log = LogFactory.getLog(FinancialCloseUtils.class);
    public static final String FISACCOUNTING = "fisaccounting";
    public static final String ORG_BANKROLL = "fisbankroll";
    private static final int FILTER_LEN_LIMIT = 500;

    public static void enhanceFilters(QueryBuilder queryBuilder) {
        QFilter[] filters = queryBuilder.getFilters();
        QFilter[] enhanceFilters = FinancialCloseUtils.enhanceFilters(filters);
        queryBuilder.setFilters(enhanceFilters);
    }

    private static QFilter[] enhanceFilters(QFilter[] originalFilters) {
        if (originalFilters == null || originalFilters.length == 0) {
            return originalFilters;
        }
        if (DebugTrace.enable()) {
            log.info("FinancialClose_filter_enhance original filters is : " + FinancialCloseUtils.formatFilterAsString(Arrays.stream(originalFilters)));
        }
        try {
            List<Object> filterList = Arrays.stream(originalFilters).filter(Objects::nonNull).collect(Collectors.toList());
            filterList = FinancialCloseUtils.distinctToFilterList(filterList.toArray(new QFilter[0]));
            if (DebugTrace.enable()) {
                log.info("FinancialClose_filter_enhance final filters is : " + FinancialCloseUtils.formatFilterAsString(filterList.stream()));
            }
            return filterList.toArray(new QFilter[0]);
        }
        catch (Exception e) {
            log.error("FinancialClose_filter_enhance failed on:" + e.getMessage(), (Throwable)e);
            return originalFilters;
        }
    }

    private static String formatFilterAsString(Stream<QFilter> filterStream) {
        if (null == filterStream) {
            return "- null -";
        }
        return StringUtils.join((Iterable)filterStream.map(x -> {
            if (null == x) {
                return "null";
            }
            String fullString = x.toString();
            return fullString.length() <= 500 ? fullString : fullString.substring(0, 500) + String.format("--ignore %s chars -- ", fullString.length() - 500);
        }).collect(Collectors.toList()), (String)" | ");
    }

    private static List<QFilter> distinctToFilterList(QFilter[] filters) {
        LinkedHashMap<String, QFilter> filterMap = new LinkedHashMap<String, QFilter>(filters.length);
        for (QFilter filter : filters) {
            List nests = filter.getNests(true);
            if (nests.stream().anyMatch(x -> !x.isAnd())) {
                filterMap.put(filter.toString(), filter);
                continue;
            }
            QFilter firstFilter = new QFilter(filter.getProperty(), filter.getCP(), filter.getValue());
            filterMap.put(firstFilter.toString(), firstFilter);
            for (QFilter.QFilterNest nest : nests) {
                QFilter nestFilter = new QFilter(nest.getFilter().getProperty(), nest.getFilter().getCP(), nest.getFilter().getValue());
                filterMap.put(nestFilter.toString(), nestFilter);
            }
        }
        return new LinkedList<QFilter>(filterMap.values());
    }

    public static QFilter[] removeFiltersFiled(QFilter[] filters, String[] filterFiled) {
        List<QFilter> filterList = Arrays.stream(filters).filter(qFilter -> !Arrays.asList(filterFiled).contains(qFilter.getProperty())).collect(Collectors.toList());
        return filterList.toArray(new QFilter[0]);
    }

    public static QFilter[] remainOrgFilters(QFilter[] filters) {
        List<QFilter> filterList = Arrays.stream(filters).filter(qFilter -> "org".equals(qFilter.getProperty())).collect(Collectors.toList());
        return filterList.toArray(new QFilter[0]);
    }

    public static List<Long> getAuthorizedBankOrgId(String app, Long userID, String entityID, String permissionItem) {
        DataSet orgColl = FinancialCloseUtils.getAuthorizedOrgs(app, userID, entityID, permissionItem);
        return FinancialCloseUtils.getIdList(orgColl);
    }

    public static DataSet getAuthorizedOrgs(String app, Long userID, String entityID, String permissionItem) {
        DataSet org;
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userID, (String)app, (String)entityID, (String)permissionItem);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter functionFilter = new QFilter(FISACCOUNTING, "=", (Object)Boolean.TRUE);
        functionFilter.or(new QFilter(ORG_BANKROLL, "=", (Object)Boolean.TRUE));
        if (result.hasAllOrgPerm()) {
            org = QueryServiceHelper.queryDataSet((String)FinancialCloseUtils.class.getName(), (String)"bos_org", (String)"id", (QFilter[])new QFilter[]{enableFilter, functionFilter}, null);
        } else {
            List orgIdList = result.getHasPermOrgs();
            QFilter pkFilter = new QFilter("id", "in", (Object)orgIdList);
            org = QueryServiceHelper.queryDataSet((String)FinancialCloseUtils.class.getName(), (String)"bos_org", (String)"id", (QFilter[])new QFilter[]{enableFilter, functionFilter, pkFilter}, null);
        }
        return org;
    }

    public static List<Long> getIdList(DataSet orgList) {
        ArrayList<Long> idList = new ArrayList<Long>();
        for (Row org : orgList) {
            idList.add(org.getLong("id"));
        }
        return idList;
    }

    public static List<Long> getBookTypeDataPermission(List<Long> orgIdList) {
        QFilter dataPermissionFilter = orgIdList == null || orgIdList.isEmpty() ? PermissionServiceHelper.getDataPermission((long)ContextUtil.getUserId(), null, (String)"bd_accountbookstype") : PermissionServiceHelper.getDataPermission((long)ContextUtil.getUserId(), null, (String)"bd_accountbookstype", orgIdList);
        return QueryServiceHelper.queryPrimaryKeys((String)"bd_accountbookstype", (QFilter[])new QFilter[]{dataPermissionFilter}, (String)"accounttype", (int)-1).stream().map(x -> Long.valueOf(x.toString())).collect(Collectors.toList());
    }

    public static Map<Long, DynamicObject> getOrgInfo(DataSet dataSet) {
        Map<Long, DynamicObject> orgMap = new HashMap<Long, DynamicObject>(128);
        ArrayList<Long> orgIds = new ArrayList<Long>(128);
        for (Row row : dataSet) {
            if (row.getLong("org") == null) continue;
            orgIds.add(row.getLong("org"));
        }
        if (!orgIds.isEmpty()) {
            QFilter filter = new QFilter("id", "in", orgIds);
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,number,name", (QFilter[])filter.toArray(), null);
            orgMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(x -> x.getLong("id"), x -> x));
        }
        return orgMap;
    }

    public static DataSet createDatSet(Class clazz, List<String> fields, List<DataType> dataType, List<List<Object>> fValList) {
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fields.toArray(new String[fields.size()]), (DataType[])dataType.toArray(new DataType[dataType.size()]));
        Algo algo = Algo.create((String)(Objects.isNull(clazz) ? "" : clazz.getName()));
        DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
        for (List<Object> row : fValList) {
            builder.append(row.toArray(new Object[row.size()]));
        }
        return builder.build();
    }

    public static String getBookMetaData(String formId, String formField) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)formId);
        String bookMeta = null;
        if (StringUtils.isNotEmpty((CharSequence)formField)) {
            bookMeta = ((BasedataProp)entityType.getProperties().get((Object)formField)).getBaseEntityId();
        }
        return bookMeta;
    }
}

