/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcm.common.domain;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.Assert;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fcm.common.annotations.DomainInfo;
import kd.fi.fcm.common.annotations.DomainInfoProperty;
import kd.fi.fcm.common.helper.Checker;
import kd.fi.fcm.common.helper.DomainObjectHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public abstract class BaseDO
implements Serializable {
    protected static final Log LOG = LogFactory.getLog(BaseDO.class);
    private static final long serialVersionUID = 1L;
    public static final String WRAP_SOURCE_OBJECT_NAME = "sourceDynamicObject";
    private static final Map<Class<?>, Map<String, DomainInfoProperty>> META_CLAZZ_CACHE = new WeakHashMap();
    private static final Map<Class<?>, List<String>> VALIDATED_ENTITY_DOMAINS = new WeakHashMap();
    private static final Map<Class<?>, DomainInfo> CLASS_DOMAININFO_META_CACHE = new WeakHashMap();
    private static final Map<Class<? extends BaseDO>, Constructor<?>> CLASS_CONSTRUCTOR_CACHE = new WeakHashMap();
    @JSONField(serialize=false)
    @JsonIgnore
    protected transient DynamicObject sourceDynamicObject;

    public BaseDO() {
        this.sourceDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)DomainObjectHelper.getDomainIdentifier(this.getClass()));
    }

    public BaseDO(DynamicObject dynamicObject) {
        this.sourceDynamicObject = dynamicObject;
        ReflectionUtils.doWithFields(this.getClass(), field -> {
            FieldInfo fieldInfo = BaseDO.getDynamicObjectProperty(this.getClass(), field.getName());
            String propName = fieldInfo.getDomainPropName();
            IDataEntityType dataEntityType = this.sourceDynamicObject.getDataEntityType();
            if (dataEntityType.getProperties().stream().map(x -> x.getName()).noneMatch(x -> x.equals(propName))) {
                return;
            }
            DynamicObject nestedValue = this.sourceDynamicObject.getDynamicObject(propName);
            if (Objects.isNull(nestedValue)) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn(String.format(ResManager.loadKDString((String)"\u6570\u636e\u8bb0\u5f55 %s \u5d4c\u5957\u5bf9\u8c61 %s \u7684\u503c\u4e3anull, \u8bf7\u8c28\u614e\u4f7f\u7528", (String)"BaseDO_0", (String)"fi-fcm-common", (Object[])new Object[0]), this.toString(), propName));
                }
                FieldUtils.writeField((Field)field, (Object)this, null, (boolean)Boolean.TRUE);
            } else {
                BaseDO nestedInfoInstance;
                Constructor<?> constructor = BaseDO.getConstructor(field.getType());
                try {
                    nestedInfoInstance = (BaseDO)constructor.newInstance(nestedValue);
                }
                catch (InstantiationException e) {
                    throw new IllegalArgumentException(e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalArgumentException(e);
                }
                FieldUtils.writeField((Field)field, (Object)this, (Object)nestedInfoInstance, (boolean)Boolean.TRUE);
            }
        }, field -> !WRAP_SOURCE_OBJECT_NAME.equals(field.getName()) && BaseDO.class.isAssignableFrom(field.getType()));
        this.validateDomainProp(this.getClass());
    }

    private void validateDomainProp(Class<? extends BaseDO> clazz) {
        DomainInfo metaDomainInfo = BaseDO.getByClazz(clazz);
        if (Objects.nonNull(metaDomainInfo) && metaDomainInfo.propValidate() && Objects.nonNull(this.sourceDynamicObject)) {
            IDataEntityType dataEntityType = this.sourceDynamicObject.getDataEntityType();
            if (CollectionUtils.isEmpty((Collection)VALIDATED_ENTITY_DOMAINS.get(clazz)) || !VALIDATED_ENTITY_DOMAINS.get(clazz).contains(dataEntityType.getName())) {
                List metaProps = dataEntityType.getProperties().stream().map(IMetadata::getName).collect(Collectors.toList());
                Arrays.stream(clazz.getDeclaredFields()).forEach(x -> {
                    FieldInfo fieldInfo = BaseDO.getDynamicObjectProperty(clazz, x.getName());
                    Checker.checkState(metaProps.contains(fieldInfo.getDomainPropName()), String.format("%s has property '%s'(%s) which is not mapped from data entity type: %s", clazz.getName(), fieldInfo.getField().getName(), fieldInfo.getDomainPropName(), dataEntityType), new Object[0]);
                });
                if (!VALIDATED_ENTITY_DOMAINS.containsKey(clazz)) {
                    VALIDATED_ENTITY_DOMAINS.put(clazz, new ArrayList());
                }
                VALIDATED_ENTITY_DOMAINS.get(clazz).add(dataEntityType.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends BaseDO> void buildMetaCache(Class<T> domainClazz) {
        Assert.notNull(domainClazz);
        if (META_CLAZZ_CACHE.containsKey(domainClazz)) {
            return;
        }
        Map<Class<?>, Map<String, DomainInfoProperty>> map = META_CLAZZ_CACHE;
        synchronized (map) {
            if (META_CLAZZ_CACHE.containsKey(domainClazz)) {
                return;
            }
            HashMap<String, DomainInfoProperty> fieldInfoMap = new HashMap<String, DomainInfoProperty>();
            Field[] fields = domainClazz.getDeclaredFields();
            String[] filedNames = new String[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                DomainInfoProperty domainObjectMeta = fields[i].getAnnotation(DomainInfoProperty.class);
                if (!Objects.nonNull(domainObjectMeta)) continue;
                fieldInfoMap.put(fields[i].getName(), domainObjectMeta);
            }
            META_CLAZZ_CACHE.put(domainClazz, fieldInfoMap);
        }
    }

    public DynamicObject getSourceDynamicObject() {
        return this.sourceDynamicObject;
    }

    public static final <T extends BaseDO> Map<String, DomainInfoProperty> getModelPropertyMeta(Class<T> clazz) {
        if (!META_CLAZZ_CACHE.containsKey(clazz)) {
            BaseDO.buildMetaCache(clazz);
        }
        return META_CLAZZ_CACHE.get(clazz);
    }

    public static final <T extends BaseDO> FieldInfo getDynamicObjectProperty(Class<T> domainClazz, String fieldName) {
        if (Objects.isNull(domainClazz) || StringUtils.isEmpty((CharSequence)fieldName)) {
            throw new IllegalArgumentException("parameter clazz or field can not be null");
        }
        DomainInfoProperty domainObjectProperty = BaseDO.getModelPropertyMeta(domainClazz).get(fieldName);
        String domainInfoPropName = Objects.isNull(domainObjectProperty) ? fieldName : domainObjectProperty.name();
        Class<T> clazz = domainClazz;
        while (Objects.nonNull(clazz) && BaseDO.class.isAssignableFrom(clazz)) {
            if (Arrays.stream(clazz.getDeclaredFields()).anyMatch(x -> x.getName().equals(fieldName))) {
                try {
                    Field field = clazz.getDeclaredField(fieldName);
                    return new FieldInfo(field, domainInfoPropName, BaseDO.class.isAssignableFrom(field.getType()));
                }
                catch (NoSuchFieldException e) {
                    LOG.error(String.format(ResManager.loadKDString((String)"\u7c7b\u578b %1$s \u4e2d\u4e0d\u5b58\u5728\u5b57\u6bb5 %2$s", (String)"BaseDO_1", (String)"fi-fcm-common", (Object[])new Object[0]), clazz.getName(), fieldName), (Throwable)e);
                    throw new IllegalStateException(String.format(ResManager.loadKDString((String)"\u7c7b\u578b %1$s \u4e2d\u4e0d\u5b58\u5728\u5b57\u6bb5 %2$s", (String)"BaseDO_1", (String)"fi-fcm-common", (Object[])new Object[0]), clazz.getName(), fieldName), e);
                }
            }
            if (!BaseDO.class.isAssignableFrom(clazz.getSuperclass())) break;
            clazz = clazz.getSuperclass();
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u7c7b\u578b %1$s \u4e2d\u4e0d\u5b58\u5728\u5b57\u6bb5 %2$s", (String)"BaseDO_1", (String)"fi-fcm-common", (Object[])new Object[0]), domainClazz.getName(), fieldName));
    }

    public static <T extends BaseDO> Constructor<?> getConstructor(Class<T> clazz) {
        return Optional.ofNullable(CLASS_CONSTRUCTOR_CACHE.get(clazz)).orElseGet(() -> {
            Constructor constructor = null;
            try {
                constructor = clazz.getDeclaredConstructor(DynamicObject.class);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("the DO object need provide the construct function as BaseDO(DynamicObject dynamicObject)");
            }
            CLASS_CONSTRUCTOR_CACHE.put(clazz, constructor);
            return constructor;
        });
    }

    public static <T extends BaseDO> DomainInfo getByClazz(Class<T> clazz) {
        return Optional.ofNullable(CLASS_DOMAININFO_META_CACHE.get(clazz)).orElseGet(() -> {
            DomainInfo domainObject = clazz.getDeclaredAnnotation(DomainInfo.class);
            Checker.checkState(Objects.nonNull(domainObject), String.format(" %s has no @DomainInfo annotated.", clazz.getName()), new Object[0]);
            CLASS_DOMAININFO_META_CACHE.put(clazz, domainObject);
            return domainObject;
        });
    }

    public static <T extends BaseDO> Optional<T> loadOne(Object pk, Class<T> clazz) {
        DomainInfo metaDomainInfo = BaseDO.getByClazz(clazz);
        try {
            DynamicObject source = BusinessDataServiceHelper.loadSingle((Object)pk, (String)metaDomainInfo.name(), (String)String.join((CharSequence)",", metaDomainInfo.selectedFields()));
            Constructor<?> constructor = BaseDO.getConstructor(clazz);
            try {
                return Optional.of((BaseDO)constructor.newInstance(source));
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }
        catch (Exception e) {
            LOG.error(String.format("load %s by PK: %s failed on %s", pk, metaDomainInfo.name(), e.getMessage()), (Throwable)e);
            return Optional.empty();
        }
    }

    public static class FieldInfo {
        private Field field;
        private String domainPropName;
        private boolean isNestedDomainInfo;

        public FieldInfo(Field field, String bindDomainPropName, boolean isNestedDomainInfo) {
            this.field = field;
            this.domainPropName = bindDomainPropName;
            this.isNestedDomainInfo = isNestedDomainInfo;
        }

        public Field getField() {
            return this.field;
        }

        public String getDomainPropName() {
            return this.domainPropName;
        }

        public boolean isNestedDomainInfo() {
            return this.isNestedDomainInfo;
        }
    }
}

