/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcm.common.domain;

import com.alibaba.fastjson.annotation.JSONField;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.fcm.common.domain.BaseDO;
import kd.fi.fcm.common.helper.Checker;

public class DomainObjectCollection<T extends BaseDO>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JSONField(serialize=false)
    private transient DynamicObjectCollection sourceDynamicObjectCollection;
    @JSONField(serialize=false)
    private transient WeakReference<T>[] sourceList = null;
    private final Class<T> domainClazz;

    public DomainObjectCollection(DynamicObjectCollection sourceDynamicObjectCollection, Class<T> domainClazz) {
        this.sourceDynamicObjectCollection = sourceDynamicObjectCollection;
        this.domainClazz = domainClazz;
    }

    public void clear() {
        this.sourceDynamicObjectCollection.clear();
    }

    public int size() {
        if (Objects.isNull(this.sourceDynamicObjectCollection)) {
            return 0;
        }
        return this.sourceDynamicObjectCollection.size();
    }

    public DynamicObjectCollection source() {
        return this.sourceDynamicObjectCollection;
    }

    public T get(int index) {
        if (Objects.isNull(this.sourceList)) {
            this.sourceList = new WeakReference[this.size()];
        }
        Checker.checkState(Objects.nonNull(this.sourceDynamicObjectCollection.get(index)), "index = %s exceed the data collection. ", index);
        return (T)Optional.ofNullable(this.sourceList[index]).map(Reference::get).orElseGet(() -> {
            BaseDO nestedInfoInstance;
            Constructor<?> constructor = BaseDO.getConstructor(this.domainClazz);
            try {
                nestedInfoInstance = (BaseDO)constructor.newInstance(this.sourceDynamicObjectCollection.get(index));
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
            this.sourceList[index] = new WeakReference<BaseDO>(nestedInfoInstance);
            return nestedInfoInstance;
        });
    }

    public void handle(Consumer<T> handleFunction, Integer startIndex, Integer endIndex) {
        if (Objects.isNull(startIndex)) {
            startIndex = 0;
        }
        if (Objects.isNull(endIndex)) {
            endIndex = this.size();
        }
        Checker.checkArgument(startIndex <= endIndex, ResManager.loadKDString((String)"\u53c2\u6570 startIndex=%1$s \u4e0d\u80fd\u5927\u4e8e endIndex=%2$s", (String)"DomainObjectCollection_0", (String)"fi-fcm-common", (Object[])new Object[0]), startIndex, endIndex);
        for (int i = startIndex.intValue(); i < endIndex; ++i) {
            handleFunction.accept(this.get(i));
        }
    }

    public void handle(Consumer<T> handleFunction) {
        this.handle(handleFunction, null, null);
    }

    public <V> List<V> map(Function<T, V> convertFunction) {
        LinkedList<V> result = new LinkedList<V>();
        for (int i = 0; i < this.size(); ++i) {
            result.add(convertFunction.apply(this.get(i)));
        }
        return result;
    }

    public List<T> toList() {
        LinkedList<T> result = new LinkedList<T>();
        for (int i = 0; i < this.size(); ++i) {
            result.add(this.get(i));
        }
        return result;
    }
}

