/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcm.common.helper;

import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.exception.KDBizException;
import kd.fi.fcm.common.enums.FcmSystemType;

public class Checker {
    public static void checkArgument(boolean expression, String chineseMsg, FcmSystemType systemType, String resourceID, Object ... msgPlaceHolder) {
        if (!expression) {
            throw new KDBizException(Checker.buildMessage(chineseMsg, systemType, resourceID, msgPlaceHolder));
        }
    }

    public static void checkArgument(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void checkArgument(boolean expression, String chineseMsg, Object ... msgPlaceHolder) {
        if (!expression) {
            throw new KDBizException(Checker.buildMessage(chineseMsg, msgPlaceHolder));
        }
    }

    public static void checkState(boolean expression, String chineseMsg, FcmSystemType systemType, String resourceID, Object ... msgPlaceHolder) {
        if (!expression) {
            throw new KDBizException(Checker.buildMessage(chineseMsg, systemType, resourceID, msgPlaceHolder));
        }
    }

    public static void checkState(boolean expression, String chineseMsg, Object ... msgPlaceHolder) {
        if (!expression) {
            throw new KDBizException(Checker.buildMessage(chineseMsg, msgPlaceHolder));
        }
    }

    public static String buildMessage(String chineseMsg, FcmSystemType systemType, String resourceID, Object ... msgPlaceHolder) {
        String internationalMsg = ResManager.loadKDString((String)chineseMsg, (String)resourceID, (String)(Objects.isNull((Object)systemType) ? null : systemType.getName()), (Object[])new Object[0]);
        return !ArrayUtils.isEmpty((Object[])msgPlaceHolder) ? String.format(internationalMsg, msgPlaceHolder) : internationalMsg;
    }

    private static String buildMessage(String chineseMsg, Object ... msgPlaceHolder) {
        return !ArrayUtils.isEmpty((Object[])msgPlaceHolder) ? String.format(chineseMsg, msgPlaceHolder) : chineseMsg;
    }

    public static KDBizException toException(String chineseMsg, FcmSystemType systemType, String resourceID, Object ... msgPlaceHolder) {
        return new KDBizException(Checker.buildMessage(chineseMsg, systemType, resourceID, msgPlaceHolder));
    }
}

