/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcm.common.helper;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fcm.common.annotations.DomainInfo;
import kd.fi.fcm.common.domain.BaseDO;
import kd.fi.fcm.common.helper.QuerySorter;
import org.apache.commons.lang3.StringUtils;

public class DomainInfoQueryHelper {
    protected static final Log LOG = LogFactory.getLog(DomainInfoQueryHelper.class);

    private DomainInfoQueryHelper() {
    }

    public static <T extends BaseDO> Optional<T> fetchByPk(Class<T> domainClazz, Object pk) {
        try {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)BaseDO.getByClazz(domainClazz).name());
            return dynamicObject == null ? Optional.empty() : Optional.of(DomainInfoQueryHelper.build(dynamicObject, domainClazz));
        }
        catch (Exception e) {
            LOG.info(String.format("Failed_to_get_record by PK:%s on class: %s", Objects.isNull(domainClazz) ? null : domainClazz.getName(), pk));
            return Optional.empty();
        }
    }

    public static <T extends BaseDO> void batchUpdate(Collection<T> models) {
        if (!CollectionUtils.isEmpty(models)) {
            if (models.stream().anyMatch(x -> Objects.isNull(x.getSourceDynamicObject()))) {
                throw new IllegalArgumentException("model with null source dynamic object");
            }
            List<DynamicObject> objectList = models.stream().map(BaseDO::getSourceDynamicObject).collect(Collectors.toList());
            SaveServiceHelper.update((DynamicObject[])objectList.toArray(new DynamicObject[objectList.size()]));
        }
    }

    public static <T extends BaseDO> List<T> query(Class<T> domainClazz, String specificEntityName, QFilter[] filters, List<QuerySorter> sorters, int top) {
        String queryEntityName = StringUtils.isNotEmpty((CharSequence)specificEntityName) ? specificEntityName : BaseDO.getByClazz(domainClazz).name();
        return Arrays.stream(BusinessDataServiceHelper.load((String)queryEntityName, (String)StringUtils.join((Object[])domainClazz.getAnnotation(DomainInfo.class).selectedFields(), (String)","), (QFilter[])filters, (String)QuerySorter.convertToSortInfo(sorters), (int)top)).map(x -> DomainInfoQueryHelper.build(x, domainClazz)).collect(Collectors.toList());
    }

    public static <T extends BaseDO> List<T> query(Class<T> domainClazz, QFilter[] filters, List<QuerySorter> sorters, int top) {
        return Arrays.stream(BusinessDataServiceHelper.load((String)BaseDO.getByClazz(domainClazz).name(), (String)StringUtils.join((Object[])domainClazz.getAnnotation(DomainInfo.class).selectedFields(), (String)","), (QFilter[])filters, (String)QuerySorter.convertToSortInfo(sorters), (int)top)).map(x -> DomainInfoQueryHelper.build(x, domainClazz)).collect(Collectors.toList());
    }

    private static <T extends BaseDO> T build(DynamicObject dynamicObject, Class<T> clazz) {
        Constructor<T> constructor;
        try {
            constructor = clazz.getDeclaredConstructor(DynamicObject.class);
        }
        catch (NoSuchMethodException e) {
            LOG.error("the DO object need provide the construct function as BaseDO(DynamicObject dynamicObject)");
            throw new IllegalArgumentException("the DO object need provide the construct function as BaseDO(DynamicObject dynamicObject)", e);
        }
        try {
            return (T)((BaseDO)constructor.newInstance(dynamicObject));
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

