/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcm.common.helper;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.fcm.common.domain.BaseDO;
import org.apache.commons.lang3.ArrayUtils;

public class DomainObjectHelper {
    public static final <T extends BaseDO> String getDomainIdentifier(Class<T> clazz) {
        return BaseDO.getByClazz(clazz).name();
    }

    public static <T extends BaseDO> List<T> build(DynamicObject[] dynamicObjects, Class<T> domainClazz) {
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return Collections.EMPTY_LIST;
        }
        Constructor<?> constructor = BaseDO.getConstructor(domainClazz);
        return Arrays.stream(dynamicObjects).map(x -> {
            try {
                return (BaseDO)constructor.newInstance(x);
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }).collect(Collectors.toList());
    }
}

