/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcm.common.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.fi.fcm.common.helper.Checker;
import kd.fi.fcm.common.helper.QuerySorter;

public class FilterLambdaBuilder {
    private final List<QFilter> filters = new ArrayList<QFilter>(4);
    private final List<QuerySorter> sorters = new ArrayList<QuerySorter>(1);

    public FilterLambdaBuilder() {
    }

    public FilterLambdaBuilder(String property, String cp, Object value) {
        this.addFilter(new QFilter(property, cp, value));
    }

    public final FilterLambdaBuilder addFilter(String property, String cp, Object value) {
        return this.addFilter(new QFilter(property, cp, value));
    }

    public final FilterLambdaBuilder addFilterEq(String property, Object value) {
        return this.addFilter(new QFilter(property, "=", value));
    }

    public final FilterLambdaBuilder addFilter(QFilter filter) {
        Checker.checkArgument(Objects.nonNull(filter), ResManager.loadKDString((String)"\u53c2\u6570 filter \u4e3anull", (String)"FilterLambdaBuilder_0", (String)"fi-fcm-common", (Object[])new Object[0]));
        this.filters.add(filter);
        return this;
    }

    public QFilter[] toFilters() {
        if (this.filters.isEmpty()) {
            return new QFilter[0];
        }
        return this.filters.toArray(new QFilter[this.filters.size()]);
    }

    public List<QuerySorter> toSorters() {
        return this.sorters;
    }
}

