/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcm.common.helper;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.fcm.common.domain.BaseDO;
import kd.fi.fcm.common.helper.DomainInfoQueryHelper;
import kd.fi.fcm.common.helper.FilterLambdaBuilder;
import kd.fi.fcm.common.helper.IService;
import kd.fi.fcm.common.helper.QuerySorter;

public class ServiceImpl<T extends BaseDO>
implements IService<T> {
    protected static final Log LOG = LogFactory.getLog(ServiceImpl.class);
    private static final Integer LIMIT_ALL = -1;

    @Override
    public Optional<T> getById(Serializable pk) {
        return DomainInfoQueryHelper.fetchByPk(this.currentModelClass(), pk);
    }

    @Override
    public List<T> listByIds(List<?> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.EMPTY_LIST;
        }
        return DomainInfoQueryHelper.query(this.currentModelClass(), new QFilter[]{new QFilter("id", "in", ids)}, null, LIMIT_ALL);
    }

    @Override
    public boolean removeById(Serializable id) {
        String entityName = BaseDO.getByClazz(this.currentModelClass()).name();
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityName), (Object[])new Object[]{id});
        return true;
    }

    @Override
    public void batchUpdate(Collection<T> models) {
        DomainInfoQueryHelper.batchUpdate(models);
    }

    @Override
    public List<T> listByFilters(QFilter[] filters, List<QuerySorter> sorters, int top) {
        if (Objects.isNull(filters)) {
            filters = new QFilter[]{};
        }
        return DomainInfoQueryHelper.query(this.currentModelClass(), filters, sorters, LIMIT_ALL);
    }

    @Override
    public List<T> listByFilters(QFilter[] filters, List<QuerySorter> sorters) {
        return this.listByFilters(filters, sorters, LIMIT_ALL);
    }

    @Override
    public T selectOne(QFilter[] filters, List<QuerySorter> sorters) {
        List<T> domains = this.listByFilters(filters, sorters, 1);
        return (T)(CollectionUtils.isEmpty(domains) ? null : (BaseDO)domains.get(0));
    }

    @Override
    public List<T> listByFilterBuilder(FilterLambdaBuilder filterLambdaBuilder, int top) {
        return DomainInfoQueryHelper.query(this.currentModelClass(), Objects.isNull(filterLambdaBuilder) ? new QFilter[]{} : filterLambdaBuilder.toFilters(), Objects.isNull(filterLambdaBuilder) ? Collections.EMPTY_LIST : filterLambdaBuilder.toSorters(), top);
    }

    @Override
    public List<T> listByFilterBuilder(FilterLambdaBuilder filterLambdaBuilder) {
        return this.listByFilterBuilder(filterLambdaBuilder, LIMIT_ALL);
    }

    @Override
    public List<T> listAll() {
        return this.listByFilterBuilder(new FilterLambdaBuilder());
    }

    @Override
    public T selectOne(FilterLambdaBuilder filterLambdaBuilder) {
        List<T> domains = this.listByFilterBuilder(filterLambdaBuilder, 1);
        return (T)(CollectionUtils.isEmpty(domains) ? null : (BaseDO)domains.get(0));
    }

    @Override
    public long count(QFilter[] filters) {
        return 0L;
    }

    @Override
    public long count(FilterLambdaBuilder filterLambdaBuilder) {
        return 0L;
    }

    @Override
    public T save(T t) {
        if (Objects.isNull(t)) {
            return t;
        }
        BusinessDataWriter.save((IDataEntityType)((BaseDO)t).getSourceDynamicObject().getDataEntityType(), (Object[])new Object[]{((BaseDO)t).getSourceDynamicObject()});
        return t;
    }

    @Override
    public List<T> batchSave(List<T> ts) {
        if (CollectionUtils.isEmpty(ts)) {
            return ts;
        }
        BusinessDataWriter.save((IDataEntityType)((BaseDO)ts.get(0)).getSourceDynamicObject().getDataEntityType(), (Object[])ts.stream().map(x -> x.getSourceDynamicObject()).toArray());
        return ts;
    }

    protected Class<T> currentModelClass() {
        return ServiceImpl.getSuperClassGenericType(this.getClass(), 0);
    }

    public static Class getSuperClassGenericType(Class clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            LOG.warn(String.format("Warn: %s's superclass not ParameterizedType", clazz.getSimpleName()));
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            LOG.warn(String.format("Warn: Index: %s, Size of %s's Parameterized Type: %s .", index, clazz.getSimpleName(), params.length));
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            LOG.warn(String.format("Warn: %s not set the actual class on superclass generic parameter", clazz.getSimpleName()));
            return Object.class;
        }
        return (Class)params[index];
    }
}

