/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcm.common.utils;

import java.util.Collection;
import java.util.Objects;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;

public class CRCondtionUtils {
    private CRCondtionUtils() {
    }

    public static QFilter buildFullFormulaForSql(String entityNumber, CRCondition crCondition) {
        Objects.requireNonNull(entityNumber, "param entitynumber is null");
        Objects.requireNonNull(crCondition, "param crCondition is null");
        QFilter formulaFilter = null;
        if (!CollectionUtils.isEmpty((Collection)crCondition.getFilterCondition().getFilterRow())) {
            FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityNumber), crCondition.getFilterCondition());
            filterBuilder.setTimeService((ITimeService)new TimeService());
            filterBuilder.setUserService(IUserService.getDefInstance());
            filterBuilder.buildFilter(true);
            formulaFilter = CRCondtionUtils.replaceIllegalStatement(filterBuilder.getQFilter());
        }
        String handFormula = crCondition.getExpression();
        return CRCondtionUtils.joinFilter(formulaFilter, handFormula);
    }

    private static QFilter joinFilter(QFilter filter1, String filterStr2) {
        if (filter1 == null) {
            return QFilter.of((String)filterStr2, (Object[])new Object[0]);
        }
        return StringUtils.isBlank((CharSequence)filterStr2) ? filter1 : filter1.and(QFilter.of((String)filterStr2, (Object[])new Object[0]));
    }

    public static QFilter replaceIllegalStatement(QFilter qFilter) {
        if (qFilter == null) {
            return null;
        }
        Consumer replaceEmpty = filter -> {
            if (filter.getCP().equals("=") && filter.getValue() instanceof QEmptyValue) {
                filter.__setCP("is null");
                filter.__setValue(null);
            }
        };
        replaceEmpty.accept((Object)qFilter);
        qFilter.getNests(true).forEach(x -> replaceEmpty.accept((Object)x.getFilter()));
        return qFilter;
    }
}

