/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcm.business.dto;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.fi.fcm.common.domain.fcm.PluginParamEntryDO;
import kd.fi.fcm.common.enums.FcmSystemType;

public class PluginParamEntryDTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(PluginParamEntryDTO.class);
    private String id;
    private String code;
    private String name;
    private boolean isRequire;
    private Object setterValue;
    private String defaultValue;
    private String desc;
    private String dataType;
    private Map<String, Object> valueRange;

    public static PluginParamEntryDTO buildFrom(PluginParamEntryDO entryDO) {
        PluginParamEntryDTO dto = new PluginParamEntryDTO();
        dto.setId(entryDO.getId());
        dto.setCode(entryDO.getCode());
        dto.setName(Objects.nonNull(entryDO.getName()) ? entryDO.getName().getLocaleValue() : "");
        dto.setIsRequire(entryDO.getIsRequired());
        dto.setDesc(Objects.nonNull(entryDO.getDesc()) ? entryDO.getDesc().getLocaleValue() : "");
        dto.setDataType(entryDO.getParamType());
        dto.setDefaultValue(entryDO.getDefaultValue());
        if (Objects.nonNull(entryDO.getEffectiveRange())) {
            try {
                if (Objects.isNull(entryDO.getEffectiveRange().getLocaleValue())) {
                    dto.setValueRange(Collections.EMPTY_MAP);
                    throw new KDBizException(ResManager.loadKDString((String)"\u63d2\u4ef6\u4e2d\u6709\u53c2\u6570\u7684\u201c\u6709\u6548\u503c\u8303\u56f4\u201d\u5728\u5f53\u524d\u8bed\u8a00\u73af\u5883\u4e2d\u6ca1\u6709\u914d\u7f6e\u3002", (String)"PluginParamEntryDTO_1", (String)FcmSystemType.BUSINESS.getName(), (Object[])new Object[0]));
                }
                Map valueRange = (Map)JSONUtils.cast((String)entryDO.getEffectiveRange().getLocaleValue(), HashMap.class);
                dto.setValueRange(valueRange);
            }
            catch (IOException e) {
                LOG.error(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u63d2\u4ef6\u53c2\u6570 %1 \u7684\u201c\u6709\u6548\u503c\u8303\u56f4\u201d\u914d\u7f6e\u9519\u8bef\u3002", (String)"PluginParamEntryDTO_0", (String)"fi-fcm-business", (Object[])new Object[0]), (String)"Common_1", (String)FcmSystemType.BUSINESS.getName(), (Object[])new Object[]{dto.getName()}));
                dto.setValueRange(Collections.EMPTY_MAP);
            }
        } else {
            dto.setValueRange(Collections.EMPTY_MAP);
        }
        return dto;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean getIsRequire() {
        return this.isRequire;
    }

    public void setIsRequire(boolean require) {
        this.isRequire = require;
    }

    public Object getSetterValue() {
        return this.setterValue;
    }

    public void setSetterValue(Object setterValue) {
        this.setterValue = setterValue;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public Map<String, Object> getValueRange() {
        return this.valueRange;
    }

    public String getBasicDataEntityNumber() {
        return this.valueRange.getOrDefault("key", "").toString();
    }

    public void setValueRange(Map<String, Object> valueRange) {
        this.valueRange = valueRange;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }
}

