/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcm.business.service.billcheckingplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import kd.fi.fcm.business.service.FcmServiceFactory;
import kd.fi.fcm.business.service.billcheckingplugin.CheckTypeStrategy;
import kd.fi.fcm.business.service.gl.IAccountBookService;
import kd.fi.fcm.business.service.gl.IAccountBookTypeService;
import kd.fi.fcm.common.domain.fcm.BaseInfoDO;
import kd.fi.fcm.common.domain.gl.AccountBookDO;
import kd.fi.fcm.common.domain.gl.AccountBooksTypeDO;

public class GLCheckTypeStrategy
implements CheckTypeStrategy {
    private long orgId;
    private IAccountBookService accountBookService = FcmServiceFactory.getService(IAccountBookService.class);
    private IAccountBookTypeService accountBookTypeService = FcmServiceFactory.getService(IAccountBookTypeService.class);

    public GLCheckTypeStrategy(long orgId) {
        this.orgId = orgId;
    }

    @Override
    public List<BaseInfoDO> getCheckTypeList() {
        ArrayList<BaseInfoDO> result = new ArrayList<BaseInfoDO>();
        List<AccountBookDO> accountBookList = this.accountBookService.listEnabledByOrgId(this.orgId);
        if (accountBookList == null || accountBookList.size() == 0) {
            return result;
        }
        accountBookList.forEach(accountBook -> {
            Optional<AccountBooksTypeDO> accountBooksType = this.accountBookTypeService.getAccountBookTypById(accountBook.getBookTypeId());
            if (!accountBooksType.isPresent()) {
                return;
            }
            BaseInfoDO baseInfo = new BaseInfoDO(accountBooksType.get().getSourceDynamicObject());
            result.add(baseInfo);
        });
        return result;
    }
}

