/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcm.business.service.fcm.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.fcm.business.service.fcm.ICheckItemStatusService;
import kd.fi.fcm.business.strategy.CheckItemPermStrategy;
import kd.fi.fcm.common.domain.fcm.CheckItemStatusDO;
import kd.fi.fcm.common.helper.FilterLambdaBuilder;
import kd.fi.fcm.common.helper.ServiceImpl;

public class CheckItemStatusServiceImpl
extends ServiceImpl<CheckItemStatusDO>
implements ICheckItemStatusService {
    @Override
    public void updateStatusByItemIdAndOrg(Long checkItemId, Long curOrgId, Boolean newStatus, String subBizAppId) {
        Objects.requireNonNull(checkItemId);
        Objects.requireNonNull(curOrgId);
        Objects.requireNonNull(newStatus);
        CheckItemStatusDO existingRecord = (CheckItemStatusDO)super.selectOne(new FilterLambdaBuilder().addFilterEq("checkitemid", (Object)checkItemId).addFilterEq("useorg", (Object)curOrgId).addFilterEq("subbizappid", (Object)(subBizAppId != null ? subBizAppId : "")));
        if (Objects.isNull(existingRecord)) {
            DynamicObject statusDy = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fcm_checkitem_status"));
            statusDy.set("checkitemid", (Object)checkItemId);
            statusDy.set("useorg", (Object)curOrgId);
            statusDy.set("createtime", (Object)new Date());
            statusDy.set("modifytime", (Object)new Date());
            statusDy.set("iseffective", (Object)newStatus);
            statusDy.set("subbizappid", (Object)subBizAppId);
            BusinessDataWriter.save((IDataEntityType)statusDy.getDynamicObjectType(), (Object[])new Object[]{statusDy});
        } else {
            DynamicObject statusDy = existingRecord.getSourceDynamicObject();
            statusDy.set("iseffective", (Object)newStatus);
            statusDy.set("modifytime", (Object)new Date());
            SaveServiceHelper.update((DynamicObject)existingRecord.getSourceDynamicObject());
        }
    }

    @Override
    public Optional<Boolean> queryCheckItemStatus(Long checkItemId, Long curOrgId, String subBizAppId) {
        Objects.requireNonNull(checkItemId);
        Objects.requireNonNull(curOrgId);
        FilterLambdaBuilder filterLambdaBuilder = new FilterLambdaBuilder().addFilterEq("checkitemid", (Object)checkItemId).addFilterEq("useorg", (Object)curOrgId);
        if (StringUtils.isNotBlank((CharSequence)subBizAppId)) {
            filterLambdaBuilder.addFilterEq("subbizappid", (Object)subBizAppId);
        }
        List existingRecordList = super.listByFilterBuilder(filterLambdaBuilder);
        Optional<Boolean> result = Optional.empty();
        for (CheckItemStatusDO existingRecord : existingRecordList) {
            if (!Objects.nonNull(existingRecord)) continue;
            if (existingRecord.getIsEffective().booleanValue()) {
                return Optional.of(true);
            }
            result = Optional.of(false);
        }
        return result;
    }

    @Override
    public Optional<Boolean> decideCheckItemStatusOnOrg(Long checkItemId, Long curOrgId, String subBizAppId) {
        Objects.requireNonNull(checkItemId);
        Objects.requireNonNull(curOrgId);
        List allSuperiorOrgs = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"16", (long)curOrgId);
        allSuperiorOrgs.add(curOrgId);
        List sortedOrgStatusList = allSuperiorOrgs.stream().map(x -> this.queryCheckItemStatus(checkItemId, (Long)x, subBizAppId)).filter(x -> x.isPresent()).map(x -> (Boolean)x.get()).collect(Collectors.toList());
        Optional<Boolean> superOrgStatus = Optional.empty();
        if (!sortedOrgStatusList.isEmpty()) {
            superOrgStatus = CheckItemPermStrategy.DEFAULT() == CheckItemPermStrategy.DISABLE_SUBORDINATE_SWITCH ? (sortedOrgStatusList.stream().anyMatch(x -> x) ? Optional.of(Boolean.TRUE) : Optional.of(Boolean.FALSE)) : Optional.of(sortedOrgStatusList.get(sortedOrgStatusList.size() - 1));
        }
        return superOrgStatus;
    }

    @Override
    public void removedByCheckItem(Long checkItemId) {
        super.listByFilterBuilder(new FilterLambdaBuilder().addFilterEq("checkitemid", (Object)checkItemId)).stream().forEach(x -> super.removeById((Serializable)((Object)x.getId())));
    }
}

