/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcm.business.service.fcm.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.ext.fi.util.StringUtils;
import kd.fi.fcm.business.service.fcm.ICheckingPluginService;
import kd.fi.fcm.common.domain.DomainObjectCollection;
import kd.fi.fcm.common.domain.fcm.CheckingPluginDO;
import kd.fi.fcm.common.domain.fcm.PluginParamEntryDO;
import kd.fi.fcm.common.helper.ServiceImpl;

public class CheckingPluginServiceImpl
extends ServiceImpl<CheckingPluginDO>
implements ICheckingPluginService {
    @Override
    public List<PluginParamEntryDO> fetchParamInfos(Long pluginId) {
        if (Objects.isNull(pluginId) || 0L == pluginId) {
            return Collections.EMPTY_LIST;
        }
        Optional checkingPluginDO = this.getById(pluginId);
        if (checkingPluginDO.isPresent()) {
            return new DomainObjectCollection(((CheckingPluginDO)checkingPluginDO.get()).getParamInfos(), PluginParamEntryDO.class).toList();
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public Map<String, Object> initPluginParamValue(Long pluginId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        this.fetchParamInfos(pluginId).stream().filter(x -> StringUtils.isNotEmpty((String)x.getDefaultValue())).forEach(x -> {
            String fieldType = x.getParamType();
            Object defaultValue = x.getDefaultValue();
            if ("int".equals(fieldType)) {
                defaultValue = Long.parseLong(x.getDefaultValue());
            } else if ("boolean".equals(fieldType)) {
                defaultValue = Boolean.parseBoolean(x.getDefaultValue());
            }
            paramMap.put(x.getCode(), defaultValue);
        });
        return paramMap;
    }
}

