/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcm.business.service.fcm.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.fcm.CheckExecutionResult;
import kd.bos.ext.fi.fcm.CheckItemExecutionParam;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterInfo;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterService;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.service.DispatchService;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.service.operation.OperationService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.JSONUtils;
import kd.fi.fcm.business.service.ServiceRefer;
import kd.fi.fcm.business.service.bos.IDevportalBizAppService;
import kd.fi.fcm.business.service.fcm.ICheckItemStatusService;
import kd.fi.fcm.business.service.fcm.IClosePeriodCheckItemService;
import kd.fi.fcm.business.service.gl.IAccountBookService;
import kd.fi.fcm.business.utils.gl.AccSysUtil;
import kd.fi.fcm.common.domain.BaseDO;
import kd.fi.fcm.common.domain.bos.DevportalBizAppDO;
import kd.fi.fcm.common.domain.fcm.BaseInfoDO;
import kd.fi.fcm.common.domain.fcm.CheckItemDO;
import kd.fi.fcm.common.domain.gl.AccountBookDO;
import kd.fi.fcm.common.domain.gl.AccountBooksTypeDO;
import kd.fi.fcm.common.enums.FcmSystemType;
import kd.fi.fcm.common.helper.Checker;
import kd.fi.fcm.common.helper.DomainObjectHelper;
import kd.fi.fcm.common.helper.FilterLambdaBuilder;
import kd.fi.fcm.common.helper.ServiceImpl;
import kd.fi.fcm.common.utils.CommonConverters;
import kd.fi.fcm.common.utils.ErrMsgUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ClosePeriodCheckItemServiceImpl
extends ServiceImpl<CheckItemDO>
implements IClosePeriodCheckItemService {
    private static final String CHECK_METHOD_STANDARD = "1";
    private static final String MESSAGE_RESOURCE_KEY = "ClosePeriodCallbackExecutorOp_1";
    private static final String MESSAGE_RESOURCE_TEMPLATE = "a";
    private static final String MESSAGE_CHECK_BEFORE_NEW = "b";
    private static final String[] IGNORE_CHECKITEM = new String[]{"gl_VoucherConsistent"};
    private ServiceRefer<IAccountBookService> accountBookService = ServiceRefer.of(IAccountBookService.class);
    private ServiceRefer<IDevportalBizAppService> devportalBizAppService = ServiceRefer.of(IDevportalBizAppService.class);
    private ServiceRefer<ICheckItemStatusService> checkItemStatusService = ServiceRefer.of(ICheckItemStatusService.class);
    private static ServiceRefer<IDevportalBizAppService> bizAppServiceService = ServiceRefer.of(IDevportalBizAppService.class);
    private static Map<String, String> SUB_APP_TYPE_IDNAME_CACHE = new WeakHashMap<String, String>();
    private static Function<Object, ErrorCode> CALLBACK_ERR_BUILDER = x -> new ErrorCode("ClosePeriodCallbackExecutorOp_2", String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7cfb\u7edf\u68c0\u67e5\u9879\u6267\u884c\u5f02\u5e38\uff1a%1$s\u3002", (String)"ClosePeriodCheckItemServiceImpl_6", (String)FcmSystemType.BUSINESS.getName(), (Object[])new Object[0]), x));

    private String getErrorMsg(String msg) {
        switch (msg) {
            case "a": {
                return "\u53c2\u6570:%1$s\u6ca1\u6709\u8fdb\u884c\u521d\u59cb\u8bbe\u7f6e\uff0c\u4e0d\u80fd\u6267\u884c\u7ed3\u8d26\u68c0\u67e5\u9879";
            }
            case "b": {
                return "\u8bf7\u9009\u62e9\u201c\u5e94\u7528\u201d";
            }
        }
        return "error!!";
    }

    @Override
    public List<BaseInfoDO> listBaseInfoDO(String bizAppId, Long useOrgId) {
        DevportalBizAppDO devportalBizAppDO = (DevportalBizAppDO)bizAppServiceService.get().selectOne(new FilterLambdaBuilder("id", "=", (Object)bizAppId));
        if (devportalBizAppDO == null || StringUtils.isBlank((CharSequence)devportalBizAppDO.getNumber())) {
            return Collections.EMPTY_LIST;
        }
        BookRegisterInfo bookRegisterInfo = BookRegisterService.queryByBizApp((String)devportalBizAppDO.getNumber());
        return bookRegisterInfo != null && StringUtils.isNotBlank((CharSequence)bookRegisterInfo.getBookEntityId()) ? this.getComboItemDataByType(useOrgId, bookRegisterInfo) : Collections.EMPTY_LIST;
    }

    @Override
    public List<AccountBooksTypeDO> getMainAccountBooksTypeByOrgId(Long orgId) {
        ArrayList<AccountBooksTypeDO> accountBooksTypeDOS = new ArrayList<AccountBooksTypeDO>();
        FilterLambdaBuilder filterLambdaBuilder = new FilterLambdaBuilder();
        filterLambdaBuilder.addFilter("org.id", "=", (Object)orgId);
        filterLambdaBuilder.addFilter(new QFilter("bookstype.accounttype", "=", (Object)CHECK_METHOD_STANDARD));
        filterLambdaBuilder.addFilter(new QFilter("status", "=", (Object)"C"));
        filterLambdaBuilder.addFilter(new QFilter("enable", "=", (Object)CHECK_METHOD_STANDARD));
        List accountBookDOS = this.accountBookService.get().listByFilterBuilder(filterLambdaBuilder);
        if (CollectionUtils.isNotEmpty((Collection)accountBookDOS)) {
            for (AccountBookDO accountBookDO : accountBookDOS) {
                DynamicObject bookstype = (DynamicObject)accountBookDO.getSourceDynamicObject().get("bookstype");
                if (null == bookstype) continue;
                accountBooksTypeDOS.add(new AccountBooksTypeDO(bookstype));
            }
        }
        return accountBooksTypeDOS;
    }

    @Override
    public void checkBeforeNewBtn(String filterStr, List<String> checkFields) {
        if (CollectionUtils.isEmpty(checkFields)) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)filterStr)) {
            Checker.checkArgument((boolean)filterStr.contains("bizappid.id"), (String)this.getErrorMsg(MESSAGE_CHECK_BEFORE_NEW), (FcmSystemType)FcmSystemType.BUSINESS, (String)"ClosePeriodBeforeNewBtn_0", (Object[])new Object[0]);
            List maps = (List)JSONObject.parseObject((String)filterStr, (TypeReference)new TypeReference<List<Map<String, List<String>>>>(){}, (Feature[])new Feature[0]);
            for (Map field : maps) {
                if (!checkFields.contains(((List)field.get("FieldName")).get(0))) continue;
                List values = (List)field.get("Value");
                Checker.checkArgument((null != values && !values.isEmpty() && StringUtils.isNotBlank((CharSequence)((CharSequence)values.get(0))) ? 1 : 0) != 0, (String)this.getErrorMsg(MESSAGE_CHECK_BEFORE_NEW), (FcmSystemType)FcmSystemType.BUSINESS, (String)"ClosePeriodBeforeNewBtn_0", (Object[])new Object[0]);
            }
        }
    }

    @Override
    public List<CheckItemDO> query(Long orgId, String bizAppId, String subBizAppCode, Boolean isEffective) {
        try (TraceSpan span = Tracer.create((String)"queryOrgCheckItemList", (String)String.format("bizAppId: %s, subBizAppCode: %s, orgId: %s", bizAppId, subBizAppCode, orgId));){
            QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)DomainObjectHelper.getDomainIdentifier(CheckItemDO.class), (Long)orgId);
            if (StringUtils.isBlank((CharSequence)subBizAppCode)) {
                subBizAppCode = " ";
            }
            List visibleCheckItems = this.listByFilterBuilder(new FilterLambdaBuilder().addFilter(orgFilter).addFilter(new QFilter("bizappid.id", "=", (Object)bizAppId).or(new QFilter("bizappid.masterid", "=", (Object)bizAppId))).addFilter(new QFilter("subbizappid", "=", (Object)" ").or(new QFilter("subbizappid", "=", (Object)subBizAppCode))).addFilterEq("enable", CommonConverters.convertBoolToStr.apply(Boolean.TRUE)));
            String finalSubBizAppCode = subBizAppCode;
            visibleCheckItems.stream().forEach(x -> x.getSourceDynamicObject().set("iseffective", (Object)this.queryIsEffectiveOnOrg(x.getId(), orgId, finalSubBizAppCode)));
            if (Objects.isNull(isEffective)) {
                List list = visibleCheckItems;
                return list;
            }
            List<CheckItemDO> list = visibleCheckItems.stream().filter(x -> isEffective.equals(x.getIsEffective())).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public boolean queryIsEffectiveOnOrg(Long checkItemId, Long orgId, String subBizAppId) {
        Optional checkItemDO = super.getById((Serializable)checkItemId);
        Set ignoreCheckItem = Arrays.stream(IGNORE_CHECKITEM).collect(Collectors.toSet());
        String bizAppNumber = ((CheckItemDO)checkItemDO.get()).getSourceDynamicObject().getString("bizappid.number");
        if (((CheckItemDO)checkItemDO.get()).getIsSysPreset().booleanValue() && !((CheckItemDO)checkItemDO.get()).getEnableChange().booleanValue() && !ignoreCheckItem.contains(bizAppNumber + "_" + ((CheckItemDO)checkItemDO.get()).getNumber())) {
            return ((CheckItemDO)checkItemDO.get()).getIsEffective();
        }
        Optional<Boolean> statusOptional = this.checkItemStatusService.get().decideCheckItemStatusOnOrg(checkItemId, orgId, subBizAppId);
        if (!statusOptional.isPresent()) {
            return Boolean.TRUE;
        }
        return statusOptional.get();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CheckExecutionResult executeCheckItems(String bizAppId, String subBizAppCode, Long orgId, List<Long> checkItemIds) {
        Checker.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)bizAppId), (String)this.getErrorMsg(MESSAGE_RESOURCE_TEMPLATE), (FcmSystemType)FcmSystemType.BUSINESS, (String)MESSAGE_RESOURCE_KEY, (Object[])new Object[]{"bizAppId"});
        Checker.checkArgument((boolean)Objects.nonNull(subBizAppCode), (String)this.getErrorMsg(MESSAGE_RESOURCE_TEMPLATE), (FcmSystemType)FcmSystemType.BUSINESS, (String)MESSAGE_RESOURCE_KEY, (Object[])new Object[]{"subBizAppCode"});
        Checker.checkArgument((boolean)Objects.nonNull(orgId), (String)this.getErrorMsg(MESSAGE_RESOURCE_TEMPLATE), (FcmSystemType)FcmSystemType.BUSINESS, (String)MESSAGE_RESOURCE_KEY, (Object[])new Object[]{"orgId"});
        Checker.checkArgument((!CollectionUtils.isEmpty(checkItemIds) ? 1 : 0) != 0, (String)this.getErrorMsg(MESSAGE_RESOURCE_TEMPLATE), (FcmSystemType)FcmSystemType.BUSINESS, (String)MESSAGE_RESOURCE_KEY, (Object[])new Object[]{"checkItemIds"});
        Optional bizAppDO = BaseDO.loadOne((Object)bizAppId, DevportalBizAppDO.class);
        if (!bizAppDO.isPresent()) {
            Checker.toException((String)String.format(ResManager.loadKDString((String)"\u5e94\u7528ID\u65e0\u6cd5\u8bc6\u522b:%1$s\u3002", (String)"ClosePeriodCheckItemServiceImpl_0", (String)"fi-fcm-business", (Object[])new Object[0]), bizAppId), (FcmSystemType)FcmSystemType.BUSINESS, (String)"ClosePeriodCallbackExecutorOp_3", (Object[])new Object[]{bizAppId});
        }
        Map orgInfo = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.TRUE, (Boolean)Boolean.TRUE);
        Long periodId = this.parseBizAppCurrentPeriod(((DevportalBizAppDO)bizAppDO.get()).getNumber(), orgId, subBizAppCode);
        Checker.checkState((boolean)Objects.nonNull(periodId), (String)ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u6839\u636e\u5f53\u524d\u5e94\u7528[%1$s],\u7ec4\u7ec7[%2$s]\u4ee5\u53ca\u6307\u5b9a\u7c7b\u578b\u83b7\u53d6\u5f53\u524d\u671f\u95f4\u3002", (String)"ClosePeriodCheckItemServiceImpl_1", (String)"fi-fcm-business", (Object[])new Object[0]), (FcmSystemType)FcmSystemType.BUSINESS, (String)"ClosePeriodCallbackExecutorOp_4", (Object[])new Object[]{((DevportalBizAppDO)bizAppDO.get()).getName().getLocaleValue(), orgInfo.getOrDefault("name", orgId), subBizAppCode});
        String resultStr = null;
        try (TraceSpan span = Tracer.create((String)"testExecuteCheckItemOnBizApp", (String)((DevportalBizAppDO)bizAppDO.get()).getNumber());){
            String serviceAppId = ServiceLookup.getServiceAppId((String)((DevportalBizAppDO)bizAppDO.get()).getNumber());
            DispatchService dispatchService = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)serviceAppId);
            resultStr = (String)dispatchService.invoke("kd.bos.ext.fi.servicehelper.ServiceFactory", "CheckItemExecuteCallBackService", "executeCheckItems", new Object[]{new CheckItemExecutionParam(bizAppId, subBizAppCode, orgId, periodId, checkItemIds, null).toString()});
            CheckExecutionResult checkExecutionResult = (CheckExecutionResult)SerializationUtils.fromJsonString((String)resultStr, CheckExecutionResult.class);
            return checkExecutionResult;
        }
        catch (KDBizException ke) {
            ErrorCode errCode = CALLBACK_ERR_BUILDER.apply(ke.getMessage());
            LOG.error(errCode.getMessage(), (Throwable)ke);
            throw new KDBizException((Throwable)ke, errCode, new Object[0]);
        }
        catch (Exception e) {
            LOG.error(String.format("execute_checkitem_micro_service failed: %s", e.getMessage()), (Throwable)e);
            if (!StringUtils.isNotEmpty((CharSequence)e.getMessage())) throw new KDBizException("unknown exp");
            if (e.getMessage().indexOf(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230", (String)"ClosePeriodCheckItemServiceImpl_2", (String)"fi-fcm-business", (Object[])new Object[0])) <= 0) throw new KDBizException("unknown exp");
            throw new KDBizException(e.getMessage());
        }
    }

    @Override
    @Deprecated
    public CheckExecutionResult executeCheckItemsByOperate(String bizAppId, String subBizAppCode, Long orgId, List<Long> checkItemIds, String pageId) {
        Checker.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)bizAppId), (String)this.getErrorMsg(MESSAGE_RESOURCE_TEMPLATE), (FcmSystemType)FcmSystemType.BUSINESS, (String)MESSAGE_RESOURCE_KEY, (Object[])new Object[]{"bizAppId"});
        Checker.checkArgument((boolean)Objects.nonNull(subBizAppCode), (String)this.getErrorMsg(MESSAGE_RESOURCE_TEMPLATE), (FcmSystemType)FcmSystemType.BUSINESS, (String)MESSAGE_RESOURCE_KEY, (Object[])new Object[]{"subBizAppCode"});
        Checker.checkArgument((boolean)Objects.nonNull(orgId), (String)this.getErrorMsg(MESSAGE_RESOURCE_TEMPLATE), (FcmSystemType)FcmSystemType.BUSINESS, (String)MESSAGE_RESOURCE_KEY, (Object[])new Object[]{"orgId"});
        Checker.checkArgument((!CollectionUtils.isEmpty(checkItemIds) ? 1 : 0) != 0, (String)this.getErrorMsg(MESSAGE_RESOURCE_TEMPLATE), (FcmSystemType)FcmSystemType.BUSINESS, (String)MESSAGE_RESOURCE_KEY, (Object[])new Object[]{"checkItemIds"});
        DevportalBizAppDO bizAppDO = (DevportalBizAppDO)this.devportalBizAppService.get().getById((Serializable)((Object)bizAppId)).orElseThrow(() -> Checker.toException((String)String.format(ResManager.loadKDString((String)"\u5e94\u7528ID\u65e0\u6cd5\u8bc6\u522b:%1$s\u3002", (String)"ClosePeriodCheckItemServiceImpl_0", (String)"fi-fcm-business", (Object[])new Object[0]), bizAppId), (FcmSystemType)FcmSystemType.BUSINESS, (String)"ClosePeriodCallbackExecutorOp_3", (Object[])new Object[]{bizAppId}));
        Map orgInfo = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.TRUE, (Boolean)Boolean.TRUE);
        Long periodId = this.parseBizAppCurrentPeriod(bizAppDO.getNumber(), orgId, subBizAppCode);
        Checker.checkState((boolean)Objects.nonNull(periodId), (String)ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u6839\u636e\u5f53\u524d\u5e94\u7528[%1$s],\u7ec4\u7ec7[%2$s]\u4ee5\u53ca\u6307\u5b9a\u7c7b\u578b\u83b7\u53d6\u5f53\u524d\u671f\u95f4\u3002", (String)"ClosePeriodCheckItemServiceImpl_1", (String)"fi-fcm-business", (Object[])new Object[0]), (FcmSystemType)FcmSystemType.BUSINESS, (String)"ClosePeriodCallbackExecutorOp_4", (Object[])new Object[]{bizAppDO.getName().getLocaleValue(), orgInfo.getOrDefault("name", orgId), subBizAppCode});
        DynamicObject[] dataEntities = new DynamicObject[checkItemIds.size()];
        MainEntityType checkItemEntityType = EntityMetadataCache.getDataEntityType((String)"fcm_checkitem");
        for (int i = 0; i < checkItemIds.size(); ++i) {
            DynamicObject entity = new DynamicObject((DynamicObjectType)checkItemEntityType);
            entity.set("id", (Object)checkItemIds.get(i));
            dataEntities[i] = entity;
        }
        OperateOption opt = OperateOption.create();
        opt.setVariableValue("bizAppId", bizAppId);
        opt.setVariableValue("subBizAppCode", subBizAppCode);
        opt.setVariableValue("orgId", String.valueOf(orgId));
        opt.setVariableValue("periodId", String.valueOf(periodId));
        opt.setVariableValue("pageId", pageId);
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("fi-fcm");
        String cacheResultKey = String.format("fi-fcm-checkitem-execute_%s", pageId);
        cache.remove(cacheResultKey);
        String opResultStr = (String)DispatchServiceHelper.invokeBOSService((String)bizAppDO.getNumber(), (String)OperationService.class.getSimpleName(), (String)"invokeOperation", (Object[])new Object[]{"execheckitem", dataEntities, opt});
        return (CheckExecutionResult)SerializationUtils.fromJsonString((String)((String)cache.get(cacheResultKey)), CheckExecutionResult.class);
    }

    private CheckExecutionResult executePluginCheckItemByMService(DevportalBizAppDO bizAppDO, CheckItemExecutionParam executionParam) {
        String resultStr = null;
        try (TraceSpan span = Tracer.create((String)"testExecuteCheckItemOnBizApp", (String)bizAppDO.getNumber());){
            resultStr = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)bizAppDO.getNumber(), (String)"CheckItemExecuteCallBackService", (String)"executeCheckItems", (Object[])new Object[]{executionParam.toString()});
        }
        catch (KDBizException ke) {
            ErrorCode errCode = CALLBACK_ERR_BUILDER.apply(ke.getMessage());
            LOG.error(errCode.getMessage(), (Throwable)ke);
            throw new KDBizException(errCode, new Object[0]);
        }
        catch (Exception e) {
            if (StringUtils.isNotEmpty((CharSequence)e.getMessage()) && e.getMessage().indexOf(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230", (String)"ClosePeriodCheckItemServiceImpl_2", (String)"fi-fcm-business", (Object[])new Object[0])) > 0) {
                throw new KDBizException(ErrMsgUtils.requiredCheckCallBackMService((String)bizAppDO.getName().getLocaleValue()), new Object[0]);
            }
            LOG.error((Throwable)e);
            throw new KDBizException(ErrMsgUtils.unknownError(), new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)resultStr)) {
            ErrorCode errCode = CALLBACK_ERR_BUILDER.apply(ResManager.loadKDString((String)"\u4e1a\u52a1\u65b9\u8fd4\u56de\u4e3a\u7a7a", (String)"ClosePeriodCheckItemServiceImpl_3", (String)"fi-fcm-business", (Object[])new Object[0]));
            LOG.error(errCode.getMessage());
            throw new KDBizException(errCode, new Object[0]);
        }
        try {
            return (CheckExecutionResult)JSONUtils.cast((String)resultStr, CheckExecutionResult.class);
        }
        catch (IOException e) {
            ErrorCode errCode = CALLBACK_ERR_BUILDER.apply(ResManager.loadKDString((String)"\u4e1a\u52a1\u65b9\u7ed3\u679c\u83b7\u53d6\u5931\u8d25", (String)"ClosePeriodCheckItemServiceImpl_4", (String)"fi-fcm-business", (Object[])new Object[0]));
            LOG.error(errCode.getMessage(), (Throwable)e);
            throw new KDBizException(errCode, new Object[]{e});
        }
    }

    @Override
    public Long parseBizAppCurrentPeriod(String bizAppCode, Long orgId, String subBizAppCode) {
        BookRegisterInfo bookRegisterInfo = BookRegisterService.queryByBizApp((String)bizAppCode);
        if (Objects.isNull(bookRegisterInfo) || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{bookRegisterInfo.getQueryBookMservice()})) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e94\u7528\u7f3a\u5c11\u5e94\u7528\u8d26\u7c3f\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u66f4\u65b0\u3002", (String)"ClosePeriodCheckItemServiceImpl_5", (String)FcmSystemType.BUSINESS.getName(), (Object[])new Object[0]));
        }
        String[] periodServiceStrs = bookRegisterInfo.getQueryBookMservice().split(",");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("appNum", bizAppCode);
        params.put("orgIds", Collections.singletonList(orgId));
        if (!ObjectUtils.isEmpty((Object)subBizAppCode)) {
            params.put("bookTypeId", Long.valueOf(subBizAppCode));
        }
        String resultStr = (String)DispatchServiceHelper.invokeBizService((String)periodServiceStrs[0], (String)periodServiceStrs[1], (String)periodServiceStrs[2], (String)periodServiceStrs[3], (Object[])new Object[]{params});
        try {
            List result = (List)JSONUtils.cast((String)resultStr, List.class);
            if (CollectionUtils.isEmpty((Collection)result)) {
                return null;
            }
            return Long.parseLong(((Map)result.get(0)).get("currentPeriodId").toString());
        }
        catch (IOException e) {
            throw new KDException(BosErrorCode.systemError, new Object[]{e});
        }
    }

    @Override
    public void checkBeforeEdit(Long id) {
        CheckItemDO checkItemDO = (CheckItemDO)this.getById(id).get();
        Checker.checkArgument((boolean)checkItemDO.getEnableChange(), (String)ResManager.loadKDString((String)"\u8be5\u6570\u636e\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"ClosePeriodCheckItemServiceImpl_7", (String)"fi-fcm-business", (Object[])new Object[0]), (FcmSystemType)FcmSystemType.BUSINESS, (String)"ClosePeriodBeforeEdit_0", (Object[])new Object[0]);
    }

    @Override
    public void checkUniquness(Long id, String orgId, String number, String bizAppId, String subAppId) {
        FilterLambdaBuilder flterLambdaBuilder = new FilterLambdaBuilder();
        flterLambdaBuilder.addFilter("org.id", "=", (Object)Long.valueOf(orgId));
        flterLambdaBuilder.addFilter("number", "=", (Object)number);
        flterLambdaBuilder.addFilter("bizappid.id", "=", (Object)bizAppId);
        if (Objects.nonNull(subAppId)) {
            flterLambdaBuilder.addFilter("subbizappid", "=", (Object)subAppId);
        } else {
            flterLambdaBuilder.addFilter("subbizappid", "=", (Object)" ");
        }
        if (null != id && id != 0L) {
            flterLambdaBuilder.addFilter("id", "!=", (Object)id);
        }
        Checker.checkArgument((boolean)CollectionUtils.isEmpty((Collection)this.listByFilterBuilder(flterLambdaBuilder)), (String)ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u91cd\u590d\u3002", (String)"ClosePeriodCheckItemServiceImpl_8", (String)"fi-fcm-business", (Object[])new Object[0]), (FcmSystemType)FcmSystemType.BUSINESS, (String)"ClosePeriodCheckUnique_0", (Object[])new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<BaseInfoDO> getComboItemDataByType(Long orgId, BookRegisterInfo bookRegisterInfo) {
        ArrayList<BaseInfoDO> comboItems = new ArrayList<BaseInfoDO>();
        if (AccSysUtil.isBizUnitInBDControlOrg(orgId)) {
            String[] periodServiceStrs = bookRegisterInfo.getQueryBookMservice().split(",");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("appNum", bookRegisterInfo.getBizApp());
            params.put("orgIds", Collections.singletonList(orgId));
            String resultStr = (String)DispatchServiceHelper.invokeBizService((String)periodServiceStrs[0], (String)periodServiceStrs[1], (String)periodServiceStrs[2], (String)periodServiceStrs[3], (Object[])new Object[]{params});
            try {
                List result = (List)JSONUtils.cast((String)resultStr, List.class);
                if (CollectionUtils.isEmpty((Collection)result)) return comboItems;
                HashSet<Long> bookstypeIds = new HashSet<Long>();
                for (Map data : result) {
                    long bookstypeId = Long.parseLong(data.get("bookTypeId").toString());
                    if (!Objects.nonNull(bookstypeId)) continue;
                    bookstypeIds.add(bookstypeId);
                }
                BasedataProp accountTypeEntityProp = (BasedataProp)EntityMetadataCache.getDataEntityType((String)bookRegisterInfo.getBookEntityId()).getProperty(bookRegisterInfo.getBookTypeFieldOnBookEntity());
                BusinessDataServiceHelper.loadFromCache((String)accountTypeEntityProp.getBaseEntityId(), (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", bookstypeIds)}, (String)"id").values().stream().forEach(x -> comboItems.add(new BaseInfoDO(x)));
                return comboItems;
            }
            catch (IOException e) {
                throw new KDException(BosErrorCode.systemError, new Object[]{e});
            }
        } else {
            if (!StringUtils.isNotEmpty((CharSequence)bookRegisterInfo.getBookEntityId()) || !StringUtils.isNotEmpty((CharSequence)bookRegisterInfo.getBookTypeFieldOnBookEntity())) return comboItems;
            BasedataProp accountTypeEntityProp = (BasedataProp)EntityMetadataCache.getDataEntityType((String)bookRegisterInfo.getBookEntityId()).getProperty(bookRegisterInfo.getBookTypeFieldOnBookEntity());
            BusinessDataServiceHelper.loadFromCache((String)accountTypeEntityProp.getBaseEntityId(), (String)"id,number,name", null, (String)"id").values().stream().forEach(x -> comboItems.add(new BaseInfoDO(x)));
        }
        return comboItems;
    }

    @Override
    public String getSubBizAppName(String bizAppId, String subBizAppId, Long orgId) {
        if (StringUtils.isBlank((CharSequence)subBizAppId)) {
            return "";
        }
        String typeKey = StringUtils.join((Object[])new Object[]{bizAppId, subBizAppId, orgId, Lang.get().toString()}, (String)"|");
        String subBizAppName = SUB_APP_TYPE_IDNAME_CACHE.get(typeKey);
        if (StringUtils.isEmpty((CharSequence)subBizAppName)) {
            List<BaseInfoDO> baseInfoDOList = this.listBaseInfoDO(bizAppId, orgId);
            if (CollectionUtils.isNotEmpty(baseInfoDOList)) {
                for (BaseInfoDO baseInfoDO : baseInfoDOList) {
                    if (Objects.isNull(baseInfoDO.getSourceDynamicObject())) {
                        LOG.info(String.format("got app account setting with null id on bizApp:%s, subBizApp: %s, orgId: %s, DO: %s", bizAppId, subBizAppId, orgId, baseInfoDO.toString()));
                    }
                    if (!Objects.nonNull(baseInfoDO.getSourceDynamicObject()) || !StringUtils.equals((CharSequence)subBizAppId, (CharSequence)baseInfoDO.getId().toString()) || !StringUtils.isNotBlank((CharSequence)baseInfoDO.getLocaleName())) continue;
                    subBizAppName = baseInfoDO.getLocaleName();
                    break;
                }
            }
            SUB_APP_TYPE_IDNAME_CACHE.put(typeKey, subBizAppName);
        }
        return subBizAppName;
    }

    @Override
    public String getSubBizAppNameById(Long id) {
        CheckItemDO checkItemDO = (CheckItemDO)this.getById(id).get();
        return this.getSubBizAppName(checkItemDO.getBizAppId(), checkItemDO.getSubBizAppId(), checkItemDO.getOrgID());
    }
}

